/*
 * Stdio header file.	Version of 25-Nov-85
 *
 * 07 11-Jan-85 DK	EOS #define added
 * 08 14-Nov-85 DK	Killed RSX definition
 * 09 25-Nov-85 DK	Added IO_NFD and IO_NSD
 */

#ifndef	IO_OPN

#ifdef rt11
typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_uget;	/* Unget char storage	*/
	char	*io_name;	/* File name pointer	*/
	char	*io_wild;	/* Wild card buffer	*/
	int	io_lun;		/* RT11 channel number	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	int	io_bnbr;	/* Disk block number	*/
	char	io_bbuf[512];	/* Data buffer		*/
} FILE;

#endif

/*
 * Bits in iov.io_flag.
 *
 * These could be redone as
 *
 *	extern	VF$OPN;
 *	#define	IO_OPN	((int)(&VF$OUT))
 *
 * etc.
 */

#define	IO_OPN	0100000		/* Open file		*/
#define	IO_REC	0040000		/* Record device	*/
#define	IO_TTY	0020000		/* Console terminal	*/
#define	IO_EOF	0010000		/* EOF seen		*/
#define	IO_ERR	0004000		/* Error seen		*/
#define	IO_FIL	0002000		/* Disk file		*/
#define	IO_BAD	0001000		/* Buffer needs filling	*/
#define	IO_NOS	0000400		/* No newlines needed	*/
#define	IO_UBF	0000200		/* User does buffering	*/
#define	IO_BZY	0000100		/* Buffer busy (RT11)	*/
#define IO_NFS	0000040		/* nonst. file syst.	*/
#define	IO_MOD	0000003		/* File open mode 	*/
				/* 0    means read	*/
				/* 1    means write	*/
				/* 2    means append	*/
				/* != 0 means output	*/

#define EOF	(-1)
#define NULL	0
#define TRUE	1
#define FALSE	0
#define EOS	0	/* 07 */
 
extern	FILE	*stdin;		/* Standard input file	*/
extern	FILE	*stdout;	/* Standard output file	*/
extern 	FILE	*stderr;	/* Standard error file	*/
extern	int	$$ferr;		/* Error codes set here	*/

#endif
