.;.MODULE ZEMU,RELEASE=Y01,VERSION=17,COMMENT=<ZEMU build command procedure>

.;+
.;
.;                 Copyright (c) 2000 by Megan Gentry
.;                     Framingham, Massachussetts
.;                        All Rights Reserved
.;             Commercial use and Distribution Prohibited
.;
.; This software  was developed  for use  with the Z-machine emulator by
.; Johnny Billquist.   In this  context,  rights are  hereby granted  by
.; the author  for the  software to  be freely  copied and  used in  its
.; entirety  for  any  non-commercial  purpose  so  long  as  the  above
.; copyright notice and these comments are preserved.
.;
.; The author has used best efforts in the research, design, development
.; and  testing of  this software.  The author  makes no warranty of any
.; kind,  expressed or  implied,  with  regard to  this software and its
.; suitability for a given application.  The author shall not  be liable
.; in any  event for  incidental or  consequential damages in connection
.; with, or arising out of, the use or performance of this software. Use
.; of this software constitutes acceptance of these terms.
.;
.; The author  is committed to making a best effort at fixing any errors
.; found in the software and welcomes any reports of problems, comments,
.; or suggestions regarding the software at <mbg@world.std.com>.
.;
.;-

.;+
.;
.; Portions Copyright (c) 2000 by Johnny Billquist
.;
.; Abstract:
.;	This command procedure is designed to build the Z-Machine
.;	Emulator, ZEMU, on either RT or RSX.
.;
.; Invocation:
.;   RT: IND ZEMU.CMD [option [option...]] [<module_name> [<module_name>...]]
.;   RSX: @ZEMU [option [option...]] [<module_name> [<module_name>...]]
.;
.;	Where 'option' is one or more of the following:
.;
.;	ALL	causes all modules to be built
.;
.;	NOALL	disables the second-pass build of any missing required
.;		modules (disables the link phase if any required modules
.;		are unavailable)
.;
.;	CONFIG	executes only that portion of the command procedure which
.;		queries the user for configuration parameters.  A
.;		configuration file is produced and no build is performed.
.;
.;	NOCONFIG inhibits use of an existing configuration file
.;
.;	EXPRESS	performs an express build without asking the question
.;
.;	FCSFSL	(RSX) causes FCSFSL library to be used
.;
.;	FCSRES	(RSX) causes FCSRES library to be used
.;
.;	ID	(RSX) Link as a separate I/D task
.;
.;	NOID	(RSX) Link task without separated I/D
.;
.;	LINK	(default) requests executable to be built if possible
.;
.;	NOLINK	prevents an executable from being produced
.;
.;	LIST	(default) produces listing files
.;
.;	NOLIST	does not produce listing files
.;
.;	MULTI	(RSX) builds an image which reduces the amount of memory
.;		used by having only one copy of the RO psect regardless
.;		of the number of users using the program.
.;
.; Notes:
.;	This procedure is designed to be used by someone who simply
.;	wants the executable (express build), or by someone who is
.;	doing development/maintenance and needs to build an executable
.;	using a new source module without having to rebuild all the
.;	other modules.
.;
.;	When 'express build' is selected (the default), all required
.;	object modules are built, the executable is built, and then
.;	all the object modules are deleted.
.;
.;	If 'express build' is rejected, the procedure asks whether
.;	the user wishes to configure ZEMU.  If so, various questions
.;	are asked about how ZEMU should be built and a configuration
.;	file reflecting these responses is created.
.;
.;	The user is then asked if they wish to retain the object
.;	modules, whether they wish to obtain listing files (and if they
.;	wish a cross reference) and whether they wish a map file.  If
.;	the appropriate devices have not been assigned on RT, the user
.;	will be queried about them as well.
.;
.;	If any options or module names are specified on the command line
.;	which invokes the procedure, 'express build' is defaulted to
.;	<FALSE> and it is assumed that the user has made the appropriate
.;	assignments so that full commands with all outputs can be specified.
.;
.;	If any modules required to build an executable are missing, they
.;	will be automatically built.
.;
.;-

.;+
.;
.; Edit History:
.;
.; (01/00) 26-Sep-2000 Megan Gentry
.;	Initial development
.;
.; (01/01) 27-Sep-2000 Megan Gentry
.;	Adding support RSX and the stubs for support under RSTS (and
.;	other PDP-11 OSes
.;
.; (01/02) 28-Sep-2000 Megan Gentry
.;	o Added code to allow user to obtain listing and/or map files
.;	o Added code to discard the .OBJs when done
.;	o Rolled in portions of ZEMURSX.CMD
.;
.; (01/03) 29-Sep-2000 Megan Gentry
.;	o Added changes relating to RSX due to review by Johnny Billquist
.;	  Different commands for MCR vs. DCL
.;	o For express build on RT, defaults SRC, OBJ, etc, to DK
.;
.; (01/04) 02-Oct-2000 Megan Gentry
.;	o Added some consistency in label names
.;	o Added support for multiple RSX CLIs by simply saving the
.;	  CLI at the beginning and forcing DCL (to make things
.;	  more consistent) and then restoring the CLI at the end.
.;
.; (01/05) 02-Oct-2000 Megan Gentry
.;	o Code review revealed flaw in RSX-related assembly commands.
.;
.; (01/06) 03-Oct-2000 Megan Gentry
.;	o Changes due to testing on RSX by Johnny Billquist
.;
.; (01/07) 04-Oct-2000 Megan Gentry
.;	o More changes due to testing on RSX
.;
.; (01/08) 05-Oct-2000 Megan Gentry
.;	o Yet more changes, suggestions from Johnny Billquist
.;	o Added code for RT expert build to detect when a MAP or
.;	  LST device is assigned to null and to disable those
.;	  options to make the build faster.
.;	o Added NOLINK and NOALL as command line options
.;
.; (01/09) 12-Oct-2000 Megan Gentry
.;	o Adding support for creation of a conditional file based
.;	  on responses from the user
.;	o Added information provided by responding with an <ESCAPE>
.;	  at many prompts
.;	o Allow production of a configuration file without doing
.;	  a build
.;
.; (01/10) 20-Oct-2000 Megan Gentry
.;	o Changed global symbols to local ones (mostly).  Tried to
.;	  standardize names
.;
.; (01/11) 23-Oct-2000 Megan Gentry
.;	o Corrected some problems with the RSX build
.;	o Added code to detect a pre-existing configuration file
.;	  and to give the user the option of using it, setting
.;	  new configuration parameters, or ignoring it.
.;	o Finally got multiple module expert build working
.;
.; (01/12) 25-Oct-2000 Megan Gentry
.;	o Fixed defaults for FCSFSL vs. FCSRES for express build
.;
.; (01/13) 26-Oct-2000 Megan Gentry
.;	o EXPRESS option, some documentation
.;
.; (01/14) 30-Oct-2000 Megan Gentry
.;	o Added support for new functionality in ZEMU -- scripting files.
.;
.; (01/15) 31-Nov-2000 Megan Gentry
.;	o Corrected code (again) which handles building missing modules.
.;
.; (01/16) 01-NOV-2000 Megan Gentry
.;	o Incorporated fixes from Johnny -- removed comments which
.;	  include apostrophes since the RSX version of IND attempts
.;	  to do a substitution.
.;	o Incorporated changes from Johnny -- changes to the build procedure
.;	  for RSX so that the new scripting feature is included.
.;
.; (01/17) 01-Nov-2000 Megan Gentry
.;	o Added some RSX-specific options, FCSRES and FCSFSL so that
.;	  an expert build on RSX can specify something other than the
.;	  default.  Also, ID vs NOID to enable (default) or disable
.;	  linking as an ID executable.  Also, MULTI to enable multi-
.;	  user image (one copy of read-only PSECT).
.;	o Fixed procedure on RSX so that all errors will exit through
.;	  a common point which restores the original CLI
.;
.;-

.;+
.;
.; To Be Done:
.;	o Mechanism for specifying program name
.;
.;	o Mechanism for specifying definition file
.;
.;	o Mechanism for specifying link-time libraries, and maybe
.;	  invocation of command procedure which would build them
.;	  when needed.
.;
.;	o add code to remove options from parameter string once
.;	  processed.
.;
.;	o Options need to be somehow signified by '-' or '/'
.;	  or something since smaller option names have an increased
.;	  chance of being a substring of a module name.  eg. 'OBJ'
.;	  would be found in a string requesting the module ZOBJ
.;
.;		or
.;
.;	  There needs to be a smarter parsing algorithm for options.
.;
.;-

.; This is the initialization phase of the procedure

	.Enable Substitution,TimeOut,Global
	.Enable Escape

	.Disable Lowercase

	.SETF OS$IAS
	.SETF OS$RST
	.SETF OS$RSX
	.SETF OS$RMP
	.SETF OS$RT
	.SETF OS$VMS

	.IF <SYSTEM> EQ 3 .SETT OS$IAS

	.IF <SYSTEM> EQ 4 .SETT OS$RST

	.IF <SYSTEM> EQ 0 .OR .IF <SYSTEM> EQ 1 .SETT OS$RSX
	.IF <SYSTEM> EQ 2 .OR .IF <SYSTEM> EQ 6 .SETT OS$RSX
	.IF <SYSTEM> EQ 6 .SETT OS$RMP

	.IF <SYSTEM> EQ 7 .OR .IF <SYSTEM> EQ 10 .SETT OS$RT

	.IF <SYSTEM> EQ 5 .SETT OS$VMS

	.IFT OS$RSX .OR .IFT OS$RT .GOTO OSOKAY
	;
	; Unsupported operating system
	.EXIT

.OSOKAY:

	.IFT OS$RT .Disable Octal,Prefix
	.IFT OS$RSX .Enable Decimal

.; If the command line which invoked this procedure contains any
.; parameters whatsoever, we assume that the user wants an expert
.; build which will perform a build without any query.

	.SETF EXPERT
	.IF P1 NE "" .SETT EXPERT

.; Get all parameters in one symbol

	.SETS PARAMS ""
	.TEST COMMAN
	.SETN STREND <STRLEN>
	.TEST COMMAN " "
	.IF <STRLEN> NE 0 .SETS PARAMS COMMAN[<STRLEN>+1:'STREND']

.; Parse the parameters for recognized options

	.SETT OP$ALL
	.IFT EXPERT .SETF OP$ALL
	.TEST "'PARAMS'" "ALL"
	.IF <STRLEN> NE 0 .SETT OP$ALL
	.TEST "'PARAMS'" "NOALL"
	.IF <STRLEN> NE 0 .SETF OP$ALL

	.SETT OP$LNK
	.TEST "'PARAMS'" "LINK"
	.IF <STRLEN> NE 0 .SETT OP$LNK
	.TEST "'PARAMS'" "NOLINK"
	.IF <STRLEN> NE 0 .SETF OP$LNK

	.SETF OP$NCF
	.SETF OP$CFG
	.TEST "'PARAMS'" "NOCONFIG"
	.IF <STRLEN> NE 0 .SETT OP$NCF
	.IFF OP$NCF .TEST "'PARAMS'" "CONFIG"
	.IFF OP$NCF .IF <STRLEN> NE 0 .SETT OP$CFG

	.SETF EXPRES
	.TEST "'PARAMS'" "EXPRESS"
	.IF <STRLEN> NE 0 .SETT EXPRES
	.IFT EXPRES .SETF EXPERT

	.SETF OP$FSL
	.TEST "'PARAMS'" "FCSFSL"
	.IF <STRLEN> NE 0 .SETT OP$FSL

	.SETF OP$RES
	.TEST "'PARAMS'" "FCSRES"
	.IF <STRLEN> NE 0 .SETT OP$RES

	.IFT OP$RES .AND .IFT OP$FSL ;
	.IFT OP$RES .AND .IFT OP$FSL ; Conflicting options FCSRES and FCSFSL
	.IFT OP$RES .AND .IFT OP$FSL .GOTO REPDON

	.SETF OP$NID
	.SETF OP$ID
	.TEST "'PARAMS'" "NOID"
	.IF <STRLEN> NE 0 .SETT OP$NID
	.IFF OP$NID .TEST "'PARAMS'" "ID"
	.IFF OP$NID .IF <STRLEN> NE 0 .SETT OP$ID

	.SETT OP$LST
	.TEST "'PARAMS'" "LIST"
	.IF <STRLEN> NE 0 .SETT OP$LST
	.TEST "'PARAMS'" "NOLIST"
	.IF <STRLEN> NE 0 .SETF OP$LST

	.SETF OP$MUL
	.TEST "'PARAMS'" "MULTI"
	.IF <STRLEN> NE 0 .SETT OP$MUL

	.SETN $Error 0
	.SETS STARS "****************************************************************"

.; List the names of the source modules which comprise this program

	.SETS FI$SRC "ZEMU ZALU ZCTRL ZINTER ZIO ZMEM"
	.SETS FI$SRC "'FI$SRC' ZOBJ ZOPTAB ZPARSE ZPRINT ZSCREE ZTEXT"
	.IFT OS$RSX .SETS FI$SRC "'FI$SRC' ZRSX"
	.IFT OS$RT .SETS FI$SRC "'FI$SRC' ZRT ZRTLIB"

.; If we are running under RSX, then change our CLI to DCL so that we
.; can use a common set of commands... we'll restore the CLI when it
.; comes time to exit

	.IFF OS$RSX .GOTO NOCLI1
	.SETS OP$CLI "'<CLI>'"
MCR SET /CLI=TI:DCL
.NOCLI1:

	.SETF FG$OBJ
	.SETF FG$LST
	.SETF FG$CRF
	.SETF FG$MAP

	.; For most RSX systems, default to FCSRES
	.SETT FG$RES
	.SETF FG$FSL

	.; For RSX-11M+, default to FCSFSL
	.IFT OS$RMP .SETF FG$RES
	.IFT OS$RMP .SETT FG$FSL

	.SETS CRSW ""

	.SETS IDSW ""
	.IFT FG$FSL .SETS IDSW "/ID"

	.SETS MUSW ""

	.GOSUB CHKLOG

	.IFT EXPERT .GOTO INOQ
	.IFT EXPRES .GOTO IFAST2

	;
	; 'STARS'
	;	Build Procedure for ZEMU, The Z-Machine Emulator
	; 'STARS'

.Q1:
	;
	.Ask [<TRUE>] EXPRES Do you wish to perform an express build of ZEMU
	.IFF <ESCAPE> .GOTO A1
	;
	; If you select YES, this command procedure will build an executable
	; copy of ZEMU appropriate for this system, using all defaults.  If
	; you select NO, you will be prompted for additional information
	; before an executable is built.
	.GOTO Q1
.A1:
	.IFF EXPRES .GOTO IFAST1

	.GOTO IFAST2

.; Here we do setup for an expert-mode build, in which the user wants
.; specific modules built.

.INOQ:
	.IFT OP$CFG .GOTO CONFIG

	.SETT FG$OBJ
	.SETT FG$LST
	.SETT FG$CRF
	.SETT FG$MAP

.; Pick up any expert settings which may override defaults

	.IFF OP$LST .SETF FG$LST
	.IFF FG$LST .SETF FG$CRF

	.IFT OP$RES .SETT FG$RES
	.IFT OP$RES .SETF FG$FSL

	.IFT OP$FSL .SETF FG$RES
	.IFT OP$FSL .SETT FG$FSL

	.IFT OP$NID .SETS IDSW ""
	.IFT OP$ID  .SETS IDSW "/ID"

	.IFT OP$MUL .SETS MUSW "/MU"

	.GOTO IFAST2

.IFAST1:

	.GOSUB CHKCND

	.IF FI$CND EQ "" .GOTO Q2
.Q2B:
	;
	.ASK [<TRUE>] ANS Do you wish to use the existing configuration file
	.IFF <ESCAPE> .GOTO A2B
	;
	; An existing configuration file (possibly from a prior build)
	; has been detected.  You may select YES to use it unmodified,
	; or NO if you wish to be given the option of specifying the
	; configuration parameters.
	.GOTO Q2B
.A2B:
	.IFT ANS .GOTO USECFG
	.SETT OP$NCF

.Q2:
	;
	.ASK [<FALSE>] ANS Do you wish to configure ZEMU
	.IFF <ESCAPE> .GOTO A2
	;
	; If you answer YES you will be prompted for various ZEMU
	; configuration parameters which will be placed in the file
	; ZEMU.CND and used to build the executable.  If you answer
	; NO the defaults will be used.
	.GOTO Q2
.A2:
	.IFF ANS .GOTO NOCONF

	;
	;	Help is available for these questions.  Respond with
	;	an <ESCAPE> character (and hit <RETURN>) and you will
	;	receive an explanation of the question and the responses.

.CONFIG:

.Q3:
	.SETS CF$GAM ""

	.IFF OS$RSX .GOTO A3

	;
	.SETS DF$GAM "LB:'<UIC>'"
	.IFT OS$RMP .SETS DF$GAM "LB:'<DIRECT>'"
	.ASKS [::"'DF$GAM'"] CF$GAM What is the location of the default game file directory
	.IFF <ESCAPE> .GOTO A3
	;
	; This parameter allows one to specify a directory which will
	; be the default directory which ZEMU will search for a specified
	; game.
	.GOTO Q3
.A3:

.Q4:
	.SETS CF$SAV ""

	.IFF OS$RSX .GOTO A4

	.SETS DF$SAV "SY:.ZSG;0"
	.IFT OS$RMP .SETS DF$SAV "SYS$LOGIN:.ZSG;0"
	.ASKS [::"'DF$SAV'"] CF$SAV What is the default location and file type for saved games
	.IFF <ESCAPE> .GOTO A4
	;
	; This parameter allows one to specify the default location and
	; file type for saved games.
	.GOTO Q4
.A4:

.Q4B:
	.SETS CF$SCP ""

	.IFF OS$RSX .GOTO A4B

	.SETS DF$SCP "SY:.LOG;0"
	.IFT OS$RMP .SETS DF$SCP "SYS$LOGIN:.LOG;0"
	.ASKS [::"'DF$SCP'"] CF$SCP What is the default location and file type for game script files (logs)
	.IFF <ESCAPE> .GOTO A4B
	;
	; This parameter allows one to specify the default location and
	; file type for any script files.
	.GOTO Q4B
.A4B:

.Q5:
	;
	.ASKN [2.:128.:128.] CF$CSZ What is the default cache size in pages
	.IFF <ESCAPE> .GOTO A5
	;
	; This paramter selects the number of cache pages which the emulator
	; will attempt to obtain from available memory.  The larger the cache,
	; the better the performance will be.
	.GOTO Q5
.A5:

.Q6:
	;
	.ASKN [512.:16384.:1024.] CF$SSZ What is the default size of the game stack
	.IFF <ESCAPE> .GOTO A6
	;
	; Johnny - what can I say here?
	.GOTO Q6
.A6:

.Q7:
	;
	.ASKN [1:11.:1.] CF$IID What interpreter ID should be used
	.IFF <ESCAPE> .GOTO A7
	;
	; This parameter establishes the value which is used by
	; the ZEMU emulator to identify itself.
	;
	;   1   DECsystem-20     5   Atari ST           9   Apple IIc
	;   2   Apple IIe        6   IBM PC            10   Apple IIgs
	;   3   Macintosh        7   Commodore 128     11   Tandy Color
	;   4   Amiga            8   Commodore 64
	.GOTO Q7
.A7:

.Q8:
	.SETN CF$TID 0

	.IFF OS$RT .GOTO A8

	;
	.ASKN [0:8.:3] CF$TID What is the default terminal type
	.IFF <ESCAPE> .GOTO A8
	;
	; This parameter sets the terminal type which will be used by
	; ZEMU when the RT-11 console is SET SCOPE.  The options are:
	;
	;	0 = Unknown
	;	1 = VT52	5 = VT200
	;	2 = ANSI	6 = VT300
	;	3 = VT100	7 = VT400
	;	4 = VT102	8 = VT500
	;
	; When the RT-11 console is SET NOSCOPE, type UNKNOWN will
	; always be used.
	.GOTO Q8
.A8:

.Q9:
	;
	.ASK [<TRUE>] CF$EIS Do you wish to build ZEMU using EIS instructions
	.IFF <ESCAPE> .GOTO A9
	;
	; If you answer YES the ZEMU emulator will be built using the
	; EIS instructions.  This can result in a performance increase,
	; but results in an executable which can only be used on those
	; PDP-11s which have the EIS instruction set.
	;
	; If you answer NO the ZEMU emulator will be built using those
	; instructions which are available on all PDP-11s.  This will
	; result in an executable which can be used on any PDP-11, but
	; one which will run more slowly.
	.GOTO Q9
.A9:

.Q10:
	.SETF CF$ESO
	.IFT CF$EIS ;
	.IFT CF$EIS .ASK [<FALSE>] CF$ESO Do you wish to build ZEMU using an emulated SOB instruction
	.IFF <ESCAPE> .GOTO A10
	;
	; On some PDP-11 machines, a DEC/BNE pair of instructions are
	; actually faster than the EIS instruction SOB.
	;
	; If you answer YES the SOB will be emulated using DEC/BNE.
	; If you answer NO, the true EIS SOB instruction will be used.
	.GOTO Q10
.A10:

.Q11:
	;
	.ASK [<FALSE>] CF$ZDB Do you wish to include debugging code
	.IFF <ESCAPE> .GOTO A11
	;
	; The ZEMU emulator can be built with code which allows debugging.
	; The code, although included, is not normally operative until
	; selected through a command line option.
	;
	; If you answer YES the ZEMU emulator will be built with the
	; debugging code included.  This will result in a larger
	; executable and a marginal affect to performance.  It might
	; also prevent larger games from being used.
	;
	; If you anwer NO the ZEMU emulator will be built without the
	; debugging code included.  This will result in a smaller
	; executable.
	.GOTO Q11
.A11:

.; Questions have been answered, now produce the file

	.OPEN #1 'L$SRC'ZEMU.CND
			.DATA #1 ;<ZEMU.CND> created at '<TIME>' on '<DATE>'
			.DATA #1
	.IFT OS$RSX	.DATA #1	.MACRO GAMDIR
	.IFT OS$RSX	.DATA #1	.ASCII "'CF$GAM'"
	.IFT OS$RSX	.DATA #1	.ENDM GAMDIR
	.IFT OS$RSX	.DATA #1 GAMMAC = 1
	.IFT OS$RSX	.DATA #1
	.IFT OS$RSX	.DATA #1	.MACRO SAVDIR
	.IFT OS$RSX	.DATA #1	.ASCII "'CF$SAV'"
	.IFT OS$RSX	.DATA #1	.ENDM SAVDIR
	.IFT OS$RSX	.DATA #1 SAVMAC = 1
	.IFT OS$RSX	.DATA #1
	.IFT OS$RSX	.DATA #1	.MACRO SCPDIR
	.IFT OS$RSX	.DATA #1	.ASCII "'CF$SCP'"
	.IFT OS$RSX	.DATA #1	.ENDM SCPDIR
	.IFT OS$RSX	.DATA #1 SCPMAC = 1
	.IFT OS$RSX	.DATA #1
			.DATA #1 DCSIZE	= 'CF$CSZ'.
			.DATA #1 GAMSTK	= 'CF$SSZ'.
			.DATA #1 DIID	= 'CF$IID'.
	.IFT OS$RT	.DATA #1 TERMDF	= 'CF$TID'.
	.IFF CF$ZDB	.DATA #1 DBUG	= 0
	.IFT CF$ZDB	.DATA #1 DBUG	= 1
	.IFF CF$EIS	.DATA #1 EIS	= 1
	.IFT CF$EIS	.DATA #1 EIS	= 0
	.IFF CF$ESO	.DATA #1 ESOB	= 0
	.IFT CF$ESO	.DATA #1 ESOB	= 1

	.CLOSE #1

	.IFT OP$CFG .GOTO REPDON

.USECFG:
	.SETS FI$CND "'L$SRC'ZEMU.CND+"
	.SETF OP$NCF

.NOCONF:
	.Disable Escape

.; Now we query them about what they want done with the files

	;
	.Ask [<TRUE>] FG$OBJ Do you wish to retain the object files when done

	;
	.Ask [<FALSE>] FG$LST Do you wish to obtain listing files

	.IFT FG$LST ;
	.IFT FG$LST .Ask [<FALSE>] FG$CRF Do you wish to include a cross-reference (CREF)

	;
	.Ask [<FALSE>] FG$MAP Do you wish to obtain a map file

	.GOSUB CHKOPT

	.IFF OS$RSX .GOTO IFAST2

	.SETF FG$CMP
	.IFT FG$MAP ;
	.IFT FG$MAP .ASK [<FALSE>] FG$CMP Do you wish to include a cross-reference (MAP)
	.IFT FG$CMP .SETS CRSW "/CR"

	.IFT OS$RMP ;
	.IFT OS$RMP .ASK [<TRUE>] FG$FSL Should ZEMU be linked with FCSFSL

	.IFF FG$FSL ;
	.IFF FG$FSL .ASK [<TRUE>] FG$RES Should ZEMU be linked with FCSRES

	.IFT FG$FSL .SETS IDSW "/ID"

.IFAST2:

	;
	; 'STARS'
	.IFT OS$IAS ; Building ZEMU/IAS at '<TIME>' on '<DATE>'
	.IFT OS$RST ; Building ZEMU/RSTS at '<TIME>' on '<DATE>'
	.IFT OS$RSX ; Building ZEMU/RSX at '<TIME>' on '<DATE>'
	.IFT OS$RT ; Building ZEMU/RT at '<TIME>' on '<DATE>'
	; 'STARS'

	.GOSUB CHKCND

	.IF FI$CND NE "" ;
	.IF FI$CND NE "" ; [Using configuration file <ZEMU.CND>]

	.IFT EXPRES .GOTO M2FAST

.;
.; For an expert build, this is the first phase of the module build
.; step during which we build any modules which have been specifically
.; requested by the user.
.;

	.; If we're going to build all the modules anyway, then don't
	.; bother building any individual ones
	.IFT OP$ALL .GOTO M2FAST

	.SETS P2 "'PARAMS'"

.M1SLOP:
	.SETS F2 "'FI$SRC'"
	.GOTO M1ELOP

.M1ILOP:
	.PARSE "'F2'" " " F1 F2
	.IF F1 EQ "" .GOTO M1SLOP

	.IF F1 NE P1 .GOTO M1ILOP

.; Build module assembly command for DCL

	.SETS MAC ""
	.IFT OS$RT .SETS MAC "$"

	.SETS MAC "'MAC'MACRO/OBJECT:'L$OBJ''F1'"
	.IFT FG$LST .SETS MAC "'MAC'/LIST:'L$LST''F1'"
	.IFT OS$RT .IFT FG$CRF .SETS MAC "'MAC'/CROSSREFERENCE"
	.IFT OS$RSX .IFT FG$CRF .SETS MAC "'MAC'/CROSS_REFERENCE"
	.SETS MAC "'MAC' 'FI$CND''L$SRC''F1'"

	;
'MAC'

	.GOSUB CHECK

.M1ELOP:
	.PARSE "'P2'" " " P1 P2
	.IF P1 NE "" .GOTO M1ILOP

	.IF $Error NE 0 .GOTO REPORT

.;
.; For an expert build, this is the second phase of the module build
.; step during which we build any modules not specified by the user
.; which are required for a complete build.  If NOALL has been
.; specified, then any missing required modules are not build and the
.; procedure doesn't attempt to perform the link step.
.;
.; For any other kind of build (express or non-express/non-expert), this
.; is the only module build phase, and all modules will be built.
.;

.M2FAST:
	.SETS F2 "'FI$SRC'"
	.GOTO M2ELOP

.M2SLOP:
	.IFF EXPERT .GOTO M2ILOP

	.SETF NEED

	.TESTFILE 'F1'.OBJ
	.IF <FILERR> NE <SUCCES> .SETT NEED

	.IFT OP$ALL .SETT NEED

	.IF L$LST NE "" .TESTFILE 'F1'.LST
	.IF L$LST NE "" .IF <FILERR> NE <SUCCES> .SETT NEED

	.IFF NEED .GOTO M2ELOP

	.TEST PARAMS "NOALL"
	.IF <STRLEN> NE 0 .SETF OP$LNK
	.IF <STRLEN> NE 0 .GOTO REPORT

.; Build module assembly command for DCL

.M2ILOP:
	.SETS MAC ""
	.IFT OS$RT .SETS MAC "$"

	.SETS MAC "'MAC'MACRO/OBJECT:'L$OBJ''F1'"
	.IFT FG$LST .SETS MAC "'MAC'/LIST:'L$LST''F1'"
	.IFT OS$RT .IFT FG$CRF .SETS MAC "'MAC'/CROSSREFERENCE"
	.IFT OS$RSX .IFT FG$CRF .SETS MAC "'MAC'/CROSS_REFERENCE"
	.SETS MAC "'MAC' 'FI$CND''L$SRC''F1'"

	;
'MAC'

	.GOSUB CHECK

.M2ELOP:
	.PARSE "'F2'" " " F1 F2
	.IF F1 NE "" .GOTO M2SLOP

	.IF $Error NE 0 .GOTO REPORT

.;
.; The final step in the build procedure is to link the modules into
.; an executable image.
.;

.LRTP:
	.IFF OP$LNK .GOTO REPORT

	.IFF OS$RT .GOTO LRSXP

	.SETS FILES "'FI$SRC'"

	.OPEN #1 ZEMU.TMP
	.SETS LINK "$LINK/PROMPT/EXECUTE:'L$BIN'ZEMU"
	.IFT FG$MAP .SETS LINK "'LINK'/MAP:'L$MAP'ZEMU"
	.DATA #1 'LINK'
.LLOOP:
	.PARSE "'FILES'" " " F1 FILES
	.IF F1 EQ "" .GOTO ELOOP
	.DATA #1 'L$OBJ''F1'
	.GOTO LLOOP

.ELOOP:
	.DATA #1 //
	.CLOSE #1

	.enable quiet
$SET TT NOQUIET
	.disable quiet

	;
$@ZEMU.TMP

	.GOSUB CHECK
	;
$Delete ZEMU.TMP

	.IFT FG$OBJ .GOTO REPORT
	.SETS FILES "'FI$SRC'"

	.OPEN #1 ZEMU.TMP

	.PARSE "'FILES'" " " F1 FILES

.RTDLOP:
	.DATA #1 $Delete 'L$OBJ''F1'.OBJ

	.PARSE "'FILES'" " " F1 FILES
	.IF F1 NE "" .GOTO RTDLOP

	.CLOSE #1
	;
$@ZEMU.TMP

	.GOSUB CHECK
	;
$Delete ZEMU.TMP

	.GOTO REPORT

.LRSXP:
	.IFF OS$RSX .GOTO LUNS

	.OPEN #1 ZEMU.TMP

	.IFF FG$MAP .DATA #1 ZEMU'IDSW''MUSW'/FM=ZEMU,ZRSX,ZMEM
	.IFT FG$MAP .DATA #1 ZEMU'IDSW''MUSW'/FM,ZEMU'CRSW'=ZEMU,ZRSX,ZMEM

	.DATA #1 ZINTER,ZOPTAB,ZCTRL,ZALU,ZIO,ZOBJ,ZPARSE,ZPRINT,ZSCREE,ZTEXT
	.DATA #1 /
	.DATA #1 TASK=...ZEM
	.DATA #1 IDENT=Y1.5
	.DATA #1 WNDWS=6

	.IFT FG$FSL .DATA #1 SUPLIB=FCSFSL:SV
	.IFT FG$RES .DATA #1 LIBR=FCSRES:RO

	.DATA #1 UNITS=10
	.DATA #1 GBLDEF=CMDLUN:1
	.DATA #1 GBLDEF=TILUN:2
	.DATA #1 GBLDEF=DBLUN:3
	.DATA #1 GBLDEF=SAVLUN:4
	.DATA #1 GBLDEF=INLUN:5
	.DATA #1 GBLDEF=SCRLUN:7
	.DATA #1 ASG=TI:1:2:5
	.DATA #1 GBLDEF=CMDEFN:1
	.DATA #1 GBLDEF=TIEFN:2
	.DATA #1 GBLDEF=DBEFN:3
	.DATA #1 GBLDEF=CLKEFN:4
	.DATA #1 GBLDEF=TIIEFN:5
	.DATA #1 GBLDEF=SAVEFN:6
	.DATA #1 GBLDEF=SCREFN:7
	.DATA #1 //

	.CLOSE #1
	;
LINK @ZEMU.TMP

	.GOSUB CHECK
	;
DELETE/NOWARNINGS ZEMU.TMP;

	.GOSUB CHECK

	.IFT FG$OBJ .GOTO REPORT

	.SETS FILES "'FI$SRC'"

	.PARSE "'FILES'" " " F1 FILES

.RXDLOP:
	;
DELETE/NOWARNINGS 'F1'.OBJ;

	.GOSUB CHECK

	.PARSE "'FILES'" " " F1 FILES
	.IF F1 NE "" .GOTO RXDLOP

	.GOTO REPORT

.LUNS:
	;
	; Unsupported operating system
	.GOTO REPDON

.REPORT:
	.Enable Lowercase

	.IFT OS$RT .SETS MAINT "<mbg@world.std.com>"
	.IFT OS$RSX .SETS MAINT "<bqt@update.uu.se>"

	;
	; 'STARS'
	.IFF OP$LNK .IF $Error EQ 0 ; Partial build of ZEMU completed at '<TIME>' on '<DATE>'
	.IFT OP$LNK .IF $Error EQ 0 ; Build of ZEMU completed at '<TIME>' on '<DATE>'
	.IFF OP$LNK .IF $Error NE 0 ; Partial build of ZEMU failed at '<TIME>' on '<DATE>'
	.IFT OP$LNK .IF $Error NE 0 ; Build of ZEMU failed at '<TIME>' on '<DATE>'
	; 'STARS'
	.IF $Error EQ 0 .GOTO REPDON
	; If the  reason for  the ZEMU  build failure is obvious, please
	; correct the problem and retry.   If the reason for the failure
	; is not obvious, please report the problem to 'MAINT'
	; and include the output from the procedure.
	; 'STARS'
.REPDON:

	.IFF OS$RSX .GOTO NOCLI2
MCR SET /CLI=TI:'OP$CLI'
.NOCLI2:

	.IF $Error NE 0 .STOP
	.EXIT

.CHECK:
	.IF <EXSTAT> NE <SUCCES> .INC $Error
	.RETURN

.; This routine is used under RT11 to quietly ensure that the minimal
.; required logicals have been assigned.

.CHKLOG:
	.SETS L$SRC ""
	.SETS L$OBJ ""
	.SETS L$BIN ""
	.SETS L$LST ""
	.SETS L$MAP ""

	.IFF OS$RT .RETURN

	.TESTDEVICE SRC:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IF DNAME NE "NSD" .SETS L$SRC "SRC:"
	.IF DNAME EQ "NL0" .SETS L$SRC ""

	.TESTDEVICE OBJ:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IF DNAME NE "NSD" .SETS L$OBJ "OBJ:"
	.IF DNAME EQ "NL0" .SETS L$OBJ ""

	.TESTDEVICE BIN:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IF DNAME NE "NSD" .SETS L$BIN "BIN:"
	.IF DNAME EQ "NL0" .SETS L$BIN ""

	.TESTDEVICE LST:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IF DNAME NE "NSD" .SETS L$LST "LST:"
	.IF DNAME EQ "NL0" .SETS L$LST ""

	.TESTDEVICE MAP:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IF DNAME NE "NSD" .SETS L$MAP "MAP:"
	.IF DNAME EQ "NL0" .SETS L$MAP ""

	.RETURN

.; This routine is used under RT11 to check for the optionally used
.; logicals LST and MAP.  If they are to be used but are not
.; established, we prompt the user for them.

.CHKOPT:

	.SETS L$LST ""
	.SETS L$MAP ""

	.IFF OS$RT .RETURN

	.ENABLE QUIET

.; If we're not going to produce listings, we don't care if LST is assigned

	.IFF FG$LST .GOTO ALST

.TSTLST:
	.TESTDEVICE LST:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IFT EXPERT .AND .IF DNAME EQ "NSD" .SETF FG$LST
	.IFT EXPERT .AND .IF DNAME EQ "NL0" .SETF FG$LST
	.IFT FG$LST .SETS L$LST "LST:'
	.IFF FG$LST .SETF FG$CRF
	.IFF FG$LST .GOTO ALST
	.IF DNAME NE "NSD" .GOTO ALST

.QLST:
	;
	.ASKS [::"DK"] LST$DV On which device do you wish to place the listing files
$Assign 'LST$DV' LST
	.IF <EXSTAT> NE <SUCCES> .GOTO QLST
	.GOTO TSTLST

.ALST:

.; If we're not going to produce a map file, we don't care if MAP is assigned

	.IFF FG$MAP .GOTO AMAP

.TSTMAP:
	.TESTDEVICE MAP:
	.PARSE "'<EXSTRI>'" "," DNAME REST
	.IFT EXPERT .AND .IF DNAME EQ "NSD" .SETF FG$MAP
	.IFT EXPERT .AND .IF DNAME EQ "NL0" .SETF FG$MAP
	.IFT FG$MAP .SETS L$MAP "MAP:'
	.IFF FG$MAP .GOTO AMAP
	.IF DNAME NE "NSD" .GOTO AMAP

.QMAP:
	;
	.ASKS [::"DK"] MAP$DV On which device do you wish to place the map file
$Assign 'MAP$DV' MAP
	.IF <EXSTAT> NE <SUCCES> .GOTO QMAP
	.GOTO TSTMAP

.AMAP:

	.Disable Quiet

	.RETURN

.; This routine checks for a pre-existing configuration file,

.CHKCND:
	.SETS FI$CND ""
	.TESTFILE 'L$SRC'ZEMU.CND
	.IF <FILERR> EQ <SUCCES> .SETS FI$CND "'L$SRC'ZEMU.CND+"

	.IFT OP$NCF .SETS FI$CND ""

	.RETURN
