PROGRAM VOCABULARY;

(* programma sozdaniq i nakopleniq ~astotnogo slowarq slow *) 


CONST
  WORDLENGTH     = 20;			   (* maks. dlina slowa *)

TYPE
  TYPWORD        = ARRAY [1..WORDLENGTH] OF CHAR; (* tip slowa *)
  FILNAME        = ARRAY [1..12] OF CHAR;	  (* specifikaciq fajla *)
  RUSSLETTERS    = SET OF '`'..'~';		  (* mnovestwo russk. bukw *)
  POINT          = ^TYPSTRING;			  (* ukazatelx na stroku *)
  TYPSTRING      = RECORD			  (* stroka slowarq *)
                     LEFT,RIGHT  :POINT;
                     WORD        :TYPWORD;	  (* slowo *)
                     COUNTER     :1..MAXINT	  (* s~et~ik *)
                   END;
  TYPTREE        = ARRAY [0..32] OF POINT;	  (* derewo slow *)

VAR
  TRACKWORD          : TYPWORD; 		  (* sled. slowo *)
  INPFNAME 	     : TYPWORD; 		  (* imq fajla *)
  INPV,INPF          : TEXT;			  (* identifikatory fajlow *)
  I                  : INTEGER; 		  (* s~et~ik bukw w slowe *)
  COUNT 	     : INTEGER; 		  (* s~et~ik-nakopitelx *)
  k		     : INTEGER; 		  (* s~et~ik podderewxew *)
  LENFIL             : INTEGER; 		  (* razmer fajla *)
  LETTERS            : RUSSLETTERS;		  (* russkie bukwy *)
  OLDTREE,NEWTREE    : TYPTREE; 		  (* staroe i nowoe derewo *)
  WORDOUT            : BOOLEAN; 		  (* flag odnokoren. slowa *)
  FLAG  	     : BOOLEAN; 		  (* flag sozdaniq nowoj 
 						     stroki slowarq *)
  ALPHA              : ARRAY [0..32] OF INTEGER;  (* massiw dlq kodirowki *)
  REPLY,ANSWER       : CHAR;			  (* 'Y' ili 'N' *)
  MEMWORDS	     : INTEGER; 		  (* razmer swobod. pamqti  *)



PROCEDURE NILTREE (VAR TREEWORD :TYPTREE);
(* iniciirowanie derewa *)
VAR
  K :INTEGER;

BEGIN
  FOR K:=0 TO 32 DO
    TREEWORD[K]:=NIL
END;


FUNCTION CODER (CH :CHAR):CHAR;
(* kodirowka (dlq raspoloveniq slow 
   po alfawitu) *)

VAR
  N :INTEGER;

BEGIN
  IF ORD(CH)=40B
    THEN
      N:=32
    ELSE
      IF ORD(CH)=47B	     (* twerdyj znak *)
	THEN
          N:=31
	ELSE
          N:=ORD(CH)-ORD('`');
  CODER:=CHR(ALPHA[N])
END;


FUNCTION DECODER (CH :CHAR):CHAR;
(* perekodirowka *)
VAR
  N,L :INTEGER;

BEGIN
  N:=ORD(CH);
  FOR L:=0 TO 32 DO
    IF N=ALPHA[L]
      THEN
        IF L=32
	  THEN
	    DECODER:=CHR(40B)
	  ELSE
            IF L=31
	      THEN
		DECODER:=CHR(47B)
	      ELSE
                DECODER:=CHR(L+ORD('`'))
END;


FUNCTION MEMLEFT : INTEGER;
(* wy~islenie razmera swobodnoj pamqti *)

VAR
  TMP :INTEGER;

BEGIN
  (*$C.GLOBL $KORE
	MOV	SP,R0
	SUB	$KORE,R0
	CLC
	ROR	R0
	MOV	R0,TMP(SP)
  *)
  MEMLEFT:=TMP
END;


PROCEDURE READWORD (VAR WORD :TYPWORD);
(* s~itywanie slowa *)

VAR
  C,CH :CHAR;
  k    :INTEGER;
  FLAGKIR :BOOLEAN;	     (* flag kirillicy *)

  PROCEDURE STORENEXTCHAR (X :CHAR);
  (* zapolnenie massiwa WORD *)
    BEGIN
      IF I<WORDLENGTH
	THEN
	  BEGIN
	    IF NOT (X IN LETTERS) AND (ORD(X)#47B)
	      THEN
		X:=CHR(ORD(X)+ORD(' '))
	      ELSE
		FLAGKIR:=TRUE;
	    I:=I+1;
	    WORD[I]:=CODER(X)
	  END
    END;

BEGIN
  REPEAT
  WORD := '                    ';
  I:=0;
  FLAGKIR:=FALSE;
  IF NOT EOF(INPF)
    THEN
      REPEAT	              (* s~itywanie simwolow do perwogo poqwleniq*)
	CH:=INPF^; GET(INPF)	                          (*russk. bukwy *)
      UNTIL (CH >=CHR(101B)) OR EOF(INPF) OR (ORD(CH) = 26);
  WHILE (CH >=CHR(101B)) AND NOT EOF(INPF) DO
    BEGIN
      STORENEXTCHAR(CH);
      CH := INPF^; GET(INPF);
      IF ORD(CH)=47B
	THEN
          BEGIN
	    IF EOF(INPF) THEN EXIT;
            C:=CH;
            CH := INPF^; GET(INPF);
            IF (CH IN LETTERS)
	      THEN
		STORENEXTCHAR(C)
          END (* IF *)
     END; (* WHILE *)
  IF I>3
    THEN
      FOR K:=I+1 TO WORDLENGTH DO
        WORD[K]:=CODER(WORD[K])
  UNTIL FLAGKIR OR EOF(INPF)
END; (* READWORD *)


PROCEDURE ASSIGN (STRING :TYPWORD; WORD:TYPWORD);

VAR
  K :INTEGER;	     (* ~islo odinakowyh bukw *)

  PROCEDURE EXCLUDEWORD (STRING :TYPWORD; WORD :TYPWORD);
  (* procedura prowerki na odnokorennoe slowo 
     (po dline slowa i ~islu odinakowyh bukw) *)

    BEGIN
      K:=K+1;
      IF STRING[K]=WORD[K]
	THEN
          CASE K OF
            3 : IF (I>=4) AND (I<=6)
		 THEN
		   FLAG:=TRUE
		 ELSE
                   EXCLUDEWORD(STRING,WORD);
            4 : IF (I>=5) AND (I<=7)
		  THEN
		    FLAG:=TRUE
  		    ELSE
		    EXCLUDEWORD(STRING,WORD);
            5 : FLAG:=TRUE;
            ELSE
	      EXCLUDEWORD(STRING,WORD)
	  END (* CASE *)
	ELSE
	  WORDOUT:=FALSE
    END; (* EXCLUDEWORD *)

BEGIN (* ASSIGN *)
  K:=1;
  WORDOUT:=TRUE;
  EXCLUDEWORD(STRING,WORD)
END;


PROCEDURE CREATESTRING (VAR TREE :POINT; STRING : TYPWORD; COUNT : INTEGER);
						       (*s~et~ik-nakopitelx*)
(* sozdanie stroki slowarq *)

BEGIN
  IF TREE=NIL
           THEN
      BEGIN
        IF FLAG
	  THEN
	    BEGIN
              NEW(TREE);
              WITH TREE^ DO
                BEGIN
                  WORD:=STRING;
                  COUNTER:=COUNT;
                  LEFT:=NIL;
                  RIGHT:=NIL
                END (* WITH *)
            END (* IF *)
      END (* IF *)
    ELSE
      WITH TREE^ DO
        IF STRING=WORD
	  THEN
            BEGIN
              COUNTER:=COUNTER+COUNT;          (*uweli~enie s~et~ika - slowo*)
              FLAG:=TRUE		              (* uve estx w sloware *)
            END
          ELSE
            BEGIN
	      IF REPLY='N'		        (*slowarx bez odnokor. slow*)
		THEN
	          ASSIGN(STRING,WORD)
		ELSE
		  WORDOUT:=FALSE;
              CASE WORDOUT OF
                FALSE : IF STRING<WORD
			 THEN
			   CREATESTRING(LEFT,STRING,COUNT)
			 ELSE
         		   CREATESTRING(RIGHT,STRING,COUNT);
	        TRUE : ;
              END (* CASE *)
            END (* ELSE *)
END; (* CREATESTRING *)


PROCEDURE CREATETREE (CONTROL :BOOLEAN);
		     (*flag kontrolq za wkl`~eniem slow w slowarx*)
(*postroenie derewa slow *)

  BEGIN
    REPEAT
      READWORD(TRACKWORD);                    (*s~itywanie slowa iz teksta*)
	IF I>3		              (* w slowe dolvno bytx bolee 4-h bukw *)
	  THEN
	    IF NOT CONTROL
	      THEN
		BEGIN
		  FLAG:=TRUE;	 (*flag-razre{enie na sozdanie nowoj stroki *)
	          CREATESTRING(OLDTREE[ORD(TRACKWORD[1])],TRACKWORD,1)
		END
	      ELSE
		BEGIN
		  FLAG:=FALSE;
		  CREATESTRING(OLDTREE[ORD(TRACKWORD[1])],TRACKWORD,1);
	          IF NOT FLAG
		    THEN
		      BEGIN
			FLAG:=TRUE;
		        CREATESTRING(NEWTREE[ORD(TRACKWORD[1])],TRACKWORD,1)
		      END             
		END	                               
    UNTIL EOF(INPF)
  END;


PROCEDURE FILEREADING (SPF :TEXT; NAME :FILNAME);
(* s~itywanie fajla *)

BEGIN
  RESET(SPF,NAME,'DAT',LENFIL);
  FLAG:=TRUE;
  IF NOT EOF(SPF) THEN
  REPEAT
    READLN(SPF,TRACKWORD,COUNT);
    FOR I:=1 TO WORDLENGTH DO
      TRACKWORD[I]:=CODER(TRACKWORD[I]);
    CREATESTRING(OLDTREE[ORD(TRACKWORD[1])],TRACKWORD,COUNT);
    IF EOLN(SPF) AND NOT EOF(SPF)
      THEN READLN(SPF)
  UNTIL EOF(SPF)
END; (* FILEREADING *)


PROCEDURE QUESTION;
VAR
  ANSWER :CHAR;
  VOCNAME:FILNAME;

BEGIN
  WRITE('fajl-slowarx uve su}estwuet?(Y,N) ');
  READLN(ANSWER);
  IF ANSWER='Y'
    THEN
      BEGIN
	WRITE('ukavite ego specifikaci`: ');
	READLN(VOCNAME);
        FILEREADING(INPV,VOCNAME)              (* zagruzka starogo slowarq *)
     END
END; (* QUESTION *)

PROCEDURE EDITTREE;
 (* kontrolx za wkl`~eniem nowyh slow w slowarx *)

VAR
  TEMPF :TEXT;	      	           (* wremennyj fajl dlq zapisi nowyh slow *)
  K     :INTEGER;


  PROCEDURE EDIT (VAR TREE :POINT);
  VAR
    ANSWER :CHAR;
    I      :INTEGER;

  BEGIN
    IF TREE#NIL
      THEN
        WITH TREE^ DO
          BEGIN
            EDIT(LEFT);
            FOR I:=1 TO WORDLENGTH DO
              WORD[I] := DECODER(WORD[I]);
            WRITE(WORD,COUNTER,'(Y,N)?');
            READLN(ANSWER);
            IF ANSWER='Y'
	      THEN
                WRITELN(TEMPF,WORD,COUNTER);
            EDIT(RIGHT)
          END; (* WITH *)
    DISPOSE(TREE)
  END; (* EDIT *)

BEGIN (* EDITTREE *)
  REWRITE(TEMPF,'VOC1','DAT');
  WRITELN('dlq wkl`~eniq slowa w slowarx navmite Y');
  WRITELN;
 FOR K:=0 TO 32 DO
    EDIT(NEWTREE[K]);
  CLOSE(TEMPF);
  FILEREADING(TEMPF,'VOC1        ')
END;  (* EDITTREE *)


PROCEDURE VOCPRINT;
(* zapisx slowarq *)

VAR
  OUTF :TEXT;
  K,S  :INTEGER;
  VOCNAME:FILNAME;	         (* specifikaciq sozdawaemogo fajla-slowarq *)

   PROCEDURE PRINTTREE (VAR TREE :POINT);
   VAR
     CH :CHAR;
     I  :INTEGER;

   BEGIN
     IF TREE#NIL
       THEN
         WITH TREE^ DO
	   BEGIN
             PRINTTREE(LEFT);
             FOR I:=1 TO WORDLENGTH DO
               WORD[I]:=DECODER(WORD[I]);
             WRITELN(OUTF,WORD,COUNTER);
             S:=S+1;
             PRINTTREE(RIGHT)
           END (* WITH *)
   END; (* PRINTTREE *)

BEGIN (* VOCPRINT *)
  WRITELN('ukavite specifikaci` fajla-slowarq,');
  WRITE('kotoryj wy sozdaete: ');
  READLN(VOCNAME);
  REWRITE(OUTF,VOCNAME,'DAT');
  S:=0;
  FOR K:=0 TO 32 DO
    IF OLDTREE[K]#NIL
      THEN
        BEGIN
          PRINTTREE(OLDTREE[K]);
	  IF K#32 THEN
            WRITELN(OUTF)
	END;
  WRITELN(' ~islo slow w sloware:',S:4);
  CLOSE(OUTF)
END; (* VOCPRINT *)

BEGIN	  (*MAIN*)
  LETTERS:=['j','c','u','k','e','n','g','{','}','z',
            'h','f','y','w','a','p','r','o','l','d',
            'v','|','q','~','s','m','i','t','x','b','`'];
  ALPHA[0]:=31;  ALPHA[1]:=1;   ALPHA[2]:=2;
  ALPHA[3]:=23;  ALPHA[4]:=5;   ALPHA[5]:=6;
  ALPHA[6]:=21;  ALPHA[7]:=4;   ALPHA[8]:=22;
  ALPHA[9]:=9;   ALPHA[10]:=10; ALPHA[11]:=11;
  ALPHA[12]:=12; ALPHA[13]:=13; ALPHA[14]:=14;
  ALPHA[15]:=15; ALPHA[16]:=16; ALPHA[17]:=32;
  ALPHA[18]:=17; ALPHA[19]:=18; ALPHA[20]:=19;
  ALPHA[21]:=20; ALPHA[22]:=7;  ALPHA[23]:=3;
  ALPHA[24]:=27; ALPHA[25]:=28; ALPHA[26]:=8;
  ALPHA[27]:=25; ALPHA[28]:=30; ALPHA[29]:=26;
  ALPHA[30]:=24; ALPHA[31]:=29; ALPHA[32]:=0;
  NILTREE(OLDTREE);
  QUESTION;
  REPEAT
    MEMWORDS:=MEMLEFT;
    WRITELN;
    WRITELN('razmer swobodnoj pamqti:  ',MEMWORDS);
    WRITELN;
    WRITE('wa{ tekstowoj fajl? ');
    READLN(INPFNAME);
    RESET(INPF,INPFNAME,'TXT',LENFIL);
    WRITELN('hotite li wy sdelatx slowarx polnym');
    WRITE('s wkl`~eniem wseh odnokorennyh slow?(Y,N) ');
    READLN(REPLY);
    WRITELN;
    WRITELN('nuven li kontrolx s terminala'); 
    WRITE('za  wwedeniem slow w slowarx?(Y,N) ');
    READLN(ANSWER);
    IF ANSWER='N'
      THEN
        CREATETREE(FALSE)
      ELSE
	BEGIN
	  NILTREE(NEWTREE);
	  CREATETREE(TRUE);
	  EDITTREE
	END;
    WRITE('estx li e}e tekstowoj fajl?(Y,N) ');
    READLN(ANSWER);
    IF ANSWER='N' THEN EXIT
  UNTIL (MEMWORDS<500);
  IF MEMWORDS<500
    THEN
      WRITELN('malo pamqti');
  VOCPRINT
END. (* VOCABULARY *)

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               