(*             
STRINGS ARE STORED AS A RECORD STRUCTURE WITH A FIXED 
MAXIMUM NUMBER OF CHARACTERS (NORMALLY 100 BUT EASILY 
CHANGEABLE), AND AN INTEGER MARKING THE CURRENT LENGTH OF 
THE STRING.   
              
    TYPE STRING = RECORD
           LEN: INTEGER;
           CH:  ARRAY[1..STRINGMAX] OF CHAR 
           END
              
THE CAPABILITIES PROVIDED ARE:
              
LEN(S) - A FUNCTION GIVING THE CURRENT LENGTH OF STRING S;
              
CLEAR(S) - INITIALIZES STRING S TO EMPTY; 
              
READSTRING(F,S) - READS A VALUE FOR STRING S FROM THE TEXT
  FILE F.  THE STRING IS TERMINATED BY EOLN(F) AND A
  READLN(F) IS PERFORMED.  STRING OVERFLOW (A STRING LONGER 
  THAN STRINGMAX) RESULTS IN TRUNCATION.
              
WRITESTRING(F,S) - WRITES THE STRING S TO THE TEXT FILE F.
  THIS FUNCTION CAN ALSO BE PERFORMED BY
  WRITE(F,S.CH:S.LEN).
              
CONCATENATE(T,S) - APPENDS STRING S TO THE TARGET STRING T. 
  THE RESULTING VALUE IS STRING T.  OVERFLOW RESULTS IN 
  TRUNCATION TO STRINGMAX CHARACTERS. 
              
SEARCH(S,T,START) - SEARCHS STRING S FOR THE FIRST
  OCCURRENCE OF STRING T TO THE RIGHT OF POSITION START 
  (CHARACTERS ARE NUMBERED BEGINNING WITH ONE).  THE
  FUNCTION SEARCH() RETURNS THE POSITION OF THE FIRST 
  CHARACTER IN THE MATCHING SUBSTRING, OR THE VALUE ZERO IF 
  THE STRING T DOES NOT APPEAR. 
              
INSERT(T,S,START) - INSERTS THE STRING S INTO THE TARGET
  STRING T AT POSITION START.  CHARACTERS ARE SHIFTED TO THE
  RIGHT AS NECESSARY.  OVERFLOW PRODUCES A TRUNCATED TARGET 
  STRING;  A START POSITION WHICH WOULD PRODUCE A STRING
  WHICH WAS NOT CONTIGUOUS HAS NO EFFECT. 
              
THE START AND SPAN PARAMETERS IN THE FOLLOWING PROCEDURES 
DEFINE A SUBSTRING BEGINNING AT POSITION START (BETWEEN 
CHARACTERS START-1 AND START) WITH A LENGTH OF ABS(SPAN). 
IF SPAN IS POSITIVE, THE SUBSTRING IS TO THE RIGHT OF START;
IF NEGATIVE, THE SUBSTRING IS TO THE LEFT.
              
DELETE(S,START,SPAN) - DELETES THE SUBSTRING DEFINED BY 
  START, SPAN FROM THE STRING S.
              
SUBSTRING(T,S,START,SPAN) - THE SUBSTRING OF STRING S 
  DEFINED BY START, SPAN IS ASSIGNED TO THE TARGET STRING T.
*)             
CONST   STRINGMAX=100;
TYPE    STRING=RECORD 
           LEN: 0..STRINGMAX; 
           CH: PACKED ARRAY[1..STRINGMAX] OF CHAR 
           END; 
              
FUNCTION LEN(VAR S:STRING):INTEGER; 
BEGIN   LEN:= S.LEN 
END;          
              
PROCEDURE CLEAR(VAR S:STRING);
VAR     I: INTEGER; 
BEGIN   S.LEN:=0; 
        FOR I:=1 TO STRINGMAX DO S.CH[I]:=' ' 
END;          
              
PROCEDURE CONCATENATE(VAR S:STRING; VAR T:STRING);
VAR     I,J: INTEGER; 
BEGIN         
        IF S.LEN+T.LEN>STRINGMAX
           THEN J:=STRINGMAX-S.LEN (* OVERFLOW *) 
           ELSE J:=T.LEN; 
        FOR I:=1 TO J DO S.CH[S.LEN+I]:=T.CH[I];
        S.LEN:=S.LEN+J; 
END;          
              
FUNCTION SEARCH(VAR S,T:STRING; START:INTEGER):INTEGER; 
VAR     I,J: 0..STRINGMAX;
        UNEQ: BOOLEAN;
BEGIN         
        IF START<1 THEN START:=1; 
        IF (START+T.LEN>S.LEN+1) OR (T.LEN=0) 
           THEN SEARCH:=0 
           ELSE BEGIN 
              I:=START-1; 
              REPEAT
                 I:=I+1; J:=0;
                 REPEAT 
                    J:=J+1; 
                    UNEQ:=T.CH[J]<>S.CH[I+J-1]; 
                 UNTIL UNEQ OR (J=T.LEN); 
              UNTIL (NOT UNEQ) OR (I=S.LEN-T.LEN+1);
              IF UNEQ 
                 THEN SEARCH:=0 
                 ELSE SEARCH:=I;
              END;
END;          
              
PROCEDURE READSTRING(VAR F:TEXT; VAR S:STRING); 
BEGIN         
        CLEAR(S); 
        WITH S DO 
           WHILE (NOT EOLN(F)) AND (LEN<STRINGMAX) DO BEGIN 
              LEN:=LEN+1; 
              READ(F,CH[LEN]);
              END;
        READLN(F);
END;          
              
PROCEDURE WRITESTRING(VAR F:TEXT; VAR S:STRING);
BEGIN   WRITE(F,S.CH:S.LEN) 
END;          
              
PROCEDURE SUBSTRING(VAR T:STRING; VAR S:STRING; START,SPAN:INTEGER);
VAR     I: INTEGER; 
BEGIN         
        IF SPAN<0 THEN BEGIN SPAN:= -SPAN; START:=START-SPAN END; 
        IF START<1 THEN BEGIN SPAN:=SPAN+START-1; START:=1 END; 
        IF START+SPAN>S.LEN+1 THEN SPAN:=S.LEN-START+1; 
        IF SPAN<=0
           THEN CLEAR(T)
           ELSE BEGIN 
              FOR I:=1 TO SPAN DO T.CH[I]:=S.CH[START+I-1]; 
              FOR I:=SPAN+1 TO STRINGMAX DO T.CH[I]:=' '; 
              T.LEN:=SPAN;
              END;
END;          
              
PROCEDURE DELETE(VAR S:STRING; START,SPAN:INTEGER); 
VAR     I,LIMIT: INTEGER; 
BEGIN         
        IF SPAN<0 THEN BEGIN SPAN:=-SPAN; START:=START-SPAN END;
        LIMIT:=START+SPAN;
        IF START<1 THEN START:=1; 
        IF LIMIT>S.LEN+1 THEN LIMIT:=S.LEN+1; 
        SPAN:=LIMIT-START;
        IF SPAN>0 THEN BEGIN
           FOR I:=0 TO S.LEN-LIMIT DO S.CH[START+I]:=S.CH[LIMIT+I]; 
           FOR I:=S.LEN-SPAN+1 TO S.LEN DO S.CH[I]:=' ';
           S.LEN:=S.LEN-SPAN; 
           END; 
END;          
              
PROCEDURE INSERT(VAR S:STRING;VAR T:STRING; P:INTEGER); 
VAR     I,J: INTEGER; 
BEGIN         
        IF T.LEN>0 THEN 
           IF (P>0) AND (P<=S.LEN+1)
              THEN BEGIN
                 IF S.LEN+T.LEN<=STRINGMAX
                    THEN S.LEN:=S.LEN+T.LEN 
                    ELSE S.LEN:=STRINGMAX (* OVERFLOW *) ;
                 FOR I:=S.LEN DOWNTO P+T.LEN DO S.CH[I]:=S.CH[I-T.LEN]; 
                 IF S.LEN<P+T.LEN 
                    THEN J:=S.LEN 
                    ELSE J:=P+T.LEN-1;
                 FOR I:=P TO J DO S.CH[I]:=T.CH[I-P+1]; 
                 END
              ELSE (* ERROR: NON-CONTIGUOUS STRING *) 
END;          
