  (*$E+
   PASCAL PROFILER
   *)

  (*$X+ EXTENDED PRECISION FOR ALL DEBUGGER MODULES *)
  (*$A- NO ARRAY BOUNDS CHECKING *)
CONST
  MAXDEPTH=40;                    (* MAX PROCEDURE NESTING TO REMEMBER *)
  STMTMAX=100;                    (* MAX STATEMENTS PER PROCEDURE *)
  PROCMAX=40;                     (* MAX PROCEDURES PER PROGRAM *)
  IDMAPSIZE=30;
  FIRSTBLOCK=0;

TYPE
  NAME=ARRAY[0..30] OF CHAR;      (* SYMBOL NAME *)

  SYMBOLENTRY=RECORD
		TTYPE,TLINK,DATALEN,X1,X2: INTEGER;
		SNAME: NAME;
	      END;

  PROCIDENT= INTEGER;

  REFPTR=^REFRECORD;
  PROCRECORD=RECORD
	       PROCID: PROCIDENT;
	       REFS: REFPTR;
	     END;

  REFRECORD=RECORD
	      PROCREFS: 0..65535;
	      STMTREFS: ARRAY[1..STMTMAX] OF RECORD
					       LOW,HIGH: INTEGER;
					     END;
	      POINT: ARRAY[1..STMTMAX] OF 0..65535;
              (* YES - THIS SHOULD BE IN THE STMTREFS RECORD, BUT CAN YOU
	       IMAGINE WHAT A 6 BYTE RECORD DOES TO ARRAY ACCESSES? *)
	    END;

  ACTION=(INITIALIZE, ENTERPROCEDURE, EXITPROCEDURE, STATEMENT,
	  ODDADDRESS, BPTTRAP, MEMORYPROT, RESERVEDINST, BADEMT,
	  FLTEXCEPT, TERMINATION);        (* HOW WE WERE ENTERED *)
VAR
  CONTROLC,STOP:BOOLEAN;          (* SET TRUE TO STOP *)
  REGISTER:ARRAY[0..5] OF INTEGER;
  SP,PC:INTEGER;                  (* STACK POINTER AND PROGRAM COUNTER *)

  SYMBOLFILE: FILE OF INTEGER (* WELL ... NOT REALLY *);
  R: ^SYMBOLENTRY;
  IDMAP: ARRAY[FIRSTBLOCK..IDMAPSIZE] OF INTEGER;
  CURRENTID: INTEGER;

  (*THE PRECEDING VARIABLES **MUST** MATCH THE INITIAL VARIABLES
   IN DBGCMN.PAS (DEBUGGER GLOBAL VARIABLES) SO THAT THE DFINDID
   ROUTINE CAN BE USED WITHOUT CHANGE*)

  STATEMENTNUMBER: INTEGER;       (* CURRENT STATEMENT NUMBER *)
  PROCNUM,PROCCOUNT: PROCIDENT;
  PROCTABLE: ARRAY[0..PROCMAX] OF PROCRECORD;
  CURPROC: PROCIDENT;
  CURREFS: REFPTR;
  PROCEDUREDEPTH:INTEGER;         (* PROCEDURE NESTING LEVEL *)
  SEARCHING:BOOLEAN;              (* SEARCHING FOR A LINE *)
  TERMINATED:BOOLEAN;             (* PROGRAM HAS TERMINATED *)

  I,J,K,L:INTEGER;                (* TEMP *)
  NESTINDEX:INTEGER;              (* SCOPE OF VARIABLE *)
  NEST:ARRAY[0..MAXDEPTH] OF PROCIDENT; (* PROCEDURE NESTING STACK *)

  SOURCELINESPRESENT:BOOLEAN;     (* SOURCE LINE DESCRIPTORS PRESENT IN CODE *)
  SOURCEFILEPRESENT:BOOLEAN;	  (* SOURCE FILE NORMALLY GOES
					WITH LINES ... *)
  CH: CHAR;
  LINE: 0..65535;                 (* SOURCE LINE NUMBER *)
  FOUND: BOOLEAN;                 (* SOURCE LINE FOUND *)
  SOURCE: TEXT;
  OUTF: TEXT;
  FILENAME: NAME;

  PROCEDURE DFINDID(ID: INTEGER); EXTERNAL;
  PROCEDURE DEXIT; EXTERNAL;
  PROCEDURE INTERACTIVE;
   BEGIN (*NOTHING TO DO - JUST A GLOBAL PRESENCE*)
   END;

  PROCEDURE POD(WHATTODO:ACTION);

  VAR
    I:INTEGER;
    X: REAL; (* BOO HISS ... IN COMES 4K OF CODE *)

    PROCEDURE       WRITENAME(P: PROCIDENT);
    VAR
      I:INTEGER;
     BEGIN
       IF P=0
	THEN WRITE(OUTF,'MAIN')
	ELSE
	 BEGIN
	   DFINDID(P);
	   WITH R^ DO
	    BEGIN
	      I:=0;
	      WHILE SNAME[I] <> CHR(0) DO I:=I+1;
	      WRITE(OUTF,SNAME:I);
	    END;
	 END;
     END;

    PROCEDURE SWITCHPROCS(I,J: INTEGER);
    VAR
      T: PROCRECORD;
     BEGIN
       T:=PROCTABLE[I]; PROCTABLE[I]:=PROCTABLE[J]; PROCTABLE[J]:=T
     END;
   BEGIN   (* POD *)
     CASE WHATTODO OF
       INITIALIZE:
	BEGIN
          (*$C
           CLRB    SOURCELINESPRESENT(5)
           TST     @PC(5)
           BEQ     .+6
           COMB    SOURCELINESPRESENT(5)
	   *)
	  PC:=PC+2;
	  NEST[0]:= 0;                    (* MAIN PROGRAM IS PROCEDURE 0 *)
	  WITH PROCTABLE[0] DO
	   BEGIN
	     PROCID:= 0;
	     NEW(REFS);
	     REFS^.PROCREFS:=1;
	     FOR I:=1 TO STMTMAX DO
	      BEGIN
		WITH REFS^.STMTREFS[I] DO
		 BEGIN
		   LOW:=0;
		   HIGH:=0;
		 END;
		REFS^.POINT[I]:=0;
	      END;
	   END;
	  PROCEDUREDEPTH:=0;
	  PROCNUM:=0;
	  CURREFS:=PROCTABLE[0].REFS;
	  CONTROLC:=FALSE; STOP:=FALSE;
	  TERMINATED:=FALSE;

	  WRITE('PROGRAM NAME? '); READLN(FILENAME);
	  SOURCEFILEPRESENT:=FALSE; I:=-1;
	  IF SOURCELINESPRESENT THEN
	  REPEAT
	    IF FILENAME[0]=' ' THEN I:=1
	    ELSE BEGIN
	      RESET(SOURCE,FILENAME,'.LST/SEEK',I);
	      IF I=-1
	      THEN BEGIN
		WRITELN('CAN''T OPEN LISTING FILE: ',FILENAME);
		WRITE('LISTING FILENAME? '); READLN(FILENAME);
		END
	      ELSE SOURCEFILEPRESENT:=TRUE;
	      END;
	  UNTIL I<>-1;

	  I:=-1;
	  REPEAT
	    RESET(SYMBOLFILE,FILENAME,'.SYM/SEEK',I);
	    IF I=-1 THEN BEGIN
	      WRITELN('CAN''T OPEN SYMBOL FILE: ',FILENAME);
	      WRITE('SYMBOL FILENAME? '); READLN(FILENAME);
	      END;
	  UNTIL I<>-1;
	  FOR I:=FIRSTBLOCK TO IDMAPSIZE DO IDMAP[I]:=MAXINT;
	  IDMAP[FIRSTBLOCK]:=1;

	  WRITE('OUTPUT PROFILE TO: '); READLN(FILENAME);
	  IF FILENAME[0]=' '
	   THEN FILENAME:='KB:                            ';
	  REWRITE(OUTF,FILENAME,'.PRO');

	END;
       ODDADDRESS:
	BEGIN
	  WRITELN('ODD ADDRESS TRAP'); TERMINATED:=TRUE;
	END;

       BPTTRAP:
	BEGIN
	  WRITELN('BPT INSTRUCTION'); TERMINATED:=TRUE;
	END;

       MEMORYPROT:
	BEGIN
	  WRITELN('MEMORY PROTECT VIOLATION'); TERMINATED:=TRUE;
	END;

       RESERVEDINST:
	BEGIN
	  WRITELN('RESERVED INSTRUCTION TRAP'); TERMINATED:=TRUE;
	END;

       BADEMT:
	BEGIN
	  WRITELN('ILLEGAL EMT INSTRUCTION'); TERMINATED:=TRUE;
	END;

       FLTEXCEPT:
	BEGIN
	  WRITELN('FLOATING POINT EXCEPTION'); TERMINATED:=TRUE;
	END;

       TERMINATION:
	BEGIN
	  TERMINATED:=TRUE;
	END;
       ENTERPROCEDURE:
	BEGIN
	  IF PROCEDUREDEPTH=MAXDEPTH
	   THEN
	    BEGIN
	      WRITELN('** PROCEDURES TOO DEEP **');
	      FOR I:=1 TO MAXDEPTH-1 DO
	      NEST[I]:=NEST[I+1]
	    END
	   ELSE PROCEDUREDEPTH:=PROCEDUREDEPTH+1;
	  PC:=PC+4;
          (*$C
           MOV     @PC(5),CURPROC(5)
	   *)
	  PC:=PC+4;
	  PROCTABLE[PROCMAX].PROCID:=CURPROC;     (* ALWAYS FIND *)
	  PROCNUM:=1;
	  WHILE PROCTABLE[PROCNUM].PROCID<>CURPROC DO PROCNUM:=PROCNUM+1;

	  IF PROCNUM=PROCMAX
	   THEN
	    BEGIN           (* NEW PROCEDURE *)
	      IF PROCCOUNT<PROCMAX
	       THEN
		BEGIN         (* AND NOT TOO MANY *)
		  PROCCOUNT:=PROCCOUNT+1;
		  PROCNUM:=PROCCOUNT;
		  WITH PROCTABLE[PROCNUM] DO
		   BEGIN        (* INITIALIZE *)
		     PROCID:=CURPROC;
		     NEW(REFS);
		     FOR I:=1 TO STMTMAX DO
		      BEGIN
			WITH REFS^.STMTREFS[I] DO
			 BEGIN
			   LOW:=0;
			   HIGH:=0;
			 END;
			REFS^.POINT[I]:=0;
		      END;
		     REFS^.PROCREFS:=0;
		   END;
		END;
	    END;

	  WITH PROCTABLE[PROCNUM].REFS^ DO PROCREFS:=PROCREFS+1;
	  NEST[PROCEDUREDEPTH]:=PROCNUM;
	  CURREFS:= PROCTABLE[PROCNUM].REFS;
	END;

       EXITPROCEDURE:
	BEGIN
	  PROCEDUREDEPTH:=PROCEDUREDEPTH-1;
	  IF PROCEDUREDEPTH<0
	   THEN PROCEDUREDEPTH:=0;
	  PROCNUM:=NEST[PROCEDUREDEPTH];
	  CURREFS:= PROCTABLE[PROCNUM].REFS;
	END;
       STATEMENT:
	BEGIN
	  PC:=PC-2;
          (*$C
           CLR     STATEMENTNUMBER(5)
           MOVB    @PC(5),STATEMENTNUMBER(5)
           BNE     .+14
           ADD     #2,PC(5)
           MOV     @PC(5),STATEMENTNUMBER(5)
	   *)
	  PC:=PC+2;
	  IF SOURCELINESPRESENT
	   THEN
	    BEGIN
              (*$C
               MOV     @PC(5),LINE(5)
	       *)
	      PC:=PC+2;
	    END;
	  IF STATEMENTNUMBER<=STMTMAX
	   THEN
	    BEGIN
	      WITH CURREFS^.STMTREFS[STATEMENTNUMBER] DO
	       BEGIN
		 LOW:=LOW+1;
		 IF LOW=0
		  THEN HIGH:=HIGH+1;
	       END;
	      CURREFS^.POINT[STATEMENTNUMBER]:=LINE;
	    END;

	END;

      END;
     (* CASE *)
     IF TERMINATED OR CONTROLC
      THEN
       BEGIN
	 WRITELN;
	 IF PROCCOUNT>0
	  THEN
	   BEGIN
	     FOR I:=0 TO PROCCOUNT-1 DO FOR J:=I+1 TO PROCCOUNT DO
	     IF PROCTABLE[I].REFS^.POINT[1]>PROCTABLE[J].REFS^.POINT[1]
	      THEN SWITCHPROCS(I,J);
	     WRITELN(OUTF);
	     WRITELN(OUTF,'PROCEDURE REFERENCE PROFILE'); WRITELN(OUTF);
	     FOR I:=0 TO PROCCOUNT DO WITH PROCTABLE[I] DO
	      BEGIN
		WRITE(OUTF,REFS^.PROCREFS:8,'  ');
		WRITENAME(PROCID);
		WRITELN(OUTF);
	      END;
	     WRITELN(OUTF); WRITELN(OUTF);
	   END;

	 IF SOURCEFILEPRESENT
	  THEN
	   BEGIN
	     PROCNUM:=0; STATEMENTNUMBER:=1;   (* INITIALIZE SEARCH PARAMS *)
	     WHILE NOT EOF(SOURCE) DO
	      BEGIN
		(*LINE:=(BLOCK-1)*256+(@SOURCE^-@SOURCE.BUFFER) DIV 2 *)
                (*$C
                 MOV     SOURCE(5),%0
                 MOV     (%0),%1         ;SOURCE^
                 SUB     18(%0),%1       ;-BUFFER
                 ASR     %1
                 MOV     16(%0),%0       ;BLOCK
                 SWAB    %0
                 CLRB    %0
                 ADD     %0,%1
                 MOV     %1,LINE(5)
		 *)
		FOUND:=FALSE; SEARCHING:=TRUE;

		IF NOT EOLN(SOURCE)
		 THEN                (* IGNORE BLANK LINES *)
		 WHILE (SEARCHING) AND (PROCNUM<=PROCCOUNT) DO
		  BEGIN
		    WITH PROCTABLE[PROCNUM].REFS^ DO
		    WHILE (SEARCHING) AND (STATEMENTNUMBER<=STMTMAX) DO
		    IF POINT[STATEMENTNUMBER]>=LINE
		     THEN
		      BEGIN
			SEARCHING:=FALSE;
			FOUND:=(POINT[STATEMENTNUMBER]=LINE);
		      END
		     ELSE STATEMENTNUMBER:=STATEMENTNUMBER+1;
		    IF SEARCHING
		     THEN
		      BEGIN
			PROCNUM:=PROCNUM+1;
			STATEMENTNUMBER:=1;
		      END;
		  END;

		WITH PROCTABLE[PROCNUM].REFS^.STMTREFS[STATEMENTNUMBER] DO
		IF FOUND AND ((LOW OR HIGH)<>0)
		 THEN
		  BEGIN
		    X:=HIGH*65536.0+LOW;
		    IF LOW<0
		     THEN X:=X+65536.0;
		    WRITE(OUTF,X:6:0,'  ');
		  END
		 ELSE WRITE(OUTF,' ':8);

		WHILE NOT EOLN(SOURCE) DO
		 BEGIN
		   READ(SOURCE,CH); WRITE(OUTF,CH);
		 END;
		READLN(SOURCE); WRITELN(OUTF);
	      END;
	   END

	  ELSE
	   BEGIN

	     WRITELN(OUTF,'STATEMENT EXECUTION PROFILE'); WRITELN(OUTF);
	     FOR I:=0 TO PROCCOUNT DO WITH PROCTABLE[I] DO
	      BEGIN
		WRITENAME(PROCID);
		WRITELN(OUTF,' (',REFS^.PROCREFS:1,')');
		FOR J:=1 TO STMTMAX DO WITH REFS^.STMTREFS[J] DO
		IF (LOW OR HIGH)<>0
		 THEN
		  BEGIN
		    X:=HIGH*65536.0+LOW;
		    IF LOW<0
		     THEN X:=X+65536.0;
		    WRITELN(OUTF,J:8,'  ',X:1:0);
		  END;
		WRITELN(OUTF); WRITELN(OUTF);
	      END;
	   END;
	 CLOSE(OUTF);
	 IF CONTROLC THEN DEXIT;
       END;

   END;

 BEGIN
 END.
