  /*$A-,$T-*/

  /* PASCAL OPTIMIZER

   THE PROGRAM 'PASIMP' (IMPROVER) IS AN OPTIMIZER WHICH
   SCANS THE ASSEMBLER LANGUAGE TEXT PUT OUT BY THE COMPILER.
   WHEREVER POSSIBLE IT WILL REPLACE A JUMP INSTRUCTION WITH A
   BRANCH, SAVING ONE WORD, AND REPLACE A CONDITIONAL BRANCH AROUND A
   JUMP WITH A CONDITIONAL BRANCH OF THE OPPOSITE SENSE TO THE JUMP
   DESTINATION, SAVING TWO WORDS.
   EX.
   JMP   L50         BECOMES       BR   L50

   BGE   L50         BECOMES       BLT   L60
   JMP   L60
   L50:

   PASIMP MAY BE USED ON PARTS OF PROGRAMS, I.E. EXTERNAL PROCEDURES.
   THE AMOUNT AND PERCENT OF REDUCTION WILL BE SHOWN.  PASIMP ASSUMES A SIMPLE
   FORMAT FOR THE ASSEMBLER CODE.  NO MACROS ARE ALLOWED, REGISTERS
   MUST BE IDENTIFIED AS %1 .. %7 ONLY.  COMMENTS ARE ALLOWED.
   BE CAREFUL WHEN INSERTING ASSEMBLER LANGUAGE CODE IN LINE.
   PASIMP DOES NOT CHANGE THE OPERATION OF THE PROGRAM, AND IT IS
   NOT FAST.  THEREFORE IT IS BEST USED LIKE PARSLEY TO GARNISH
   ONLY A FINAL OR NEAR-FINAL VERSION.
   REDUCTION IN SIZE OF 5 TO 8 PERCENT IS TYPICAL.
   */
CONST
  LINELENG=65;
  NINST=105;
  VERSION='PASIMP V1.2';

TYPE
  ALFA=ARRAY[1..14] OF CHAR;
  LINK=^OPNODE;
  ELINK=^ENODE;
  NAME=ARRAY[1..6] OF CHAR;
  OPNODE= RECORD
	    LOCATION:INTEGER;
	    BRDESTIN:INTEGER;
	    JMPDESTIN:INTEGER;
	    EFFECT:ELINK;
	    OPTYPE:(BRJMP,JMP);
	    OKTOOP:BOOLEAN;
	    NEXT:LINK
	  END;

  TAGNODE=RECORD
	    NAM:INTEGER;
	    LOCATION:INTEGER;
	    PTBJUMP,PTBBRANCH:^PTBNODE;
	    NEXT:^TAGNODE;
	  END;

  PTBNODE=RECORD
	    P:LINK;
	    NEXT:^PTBNODE
	  END;

  ENODE=RECORD
	  P:LINK;
	  NEXT:ELINK
	END;

  MODE=(RELATIVE,INDEXED,REGISTER,IMMEDIATE,REGDEFER,AUTODEC,DEFER);
  ARGTYP=(ARITH,TAG);

  ARGUMENT=RECORD
	     M:MODE;
	     SIZ:INTEGER;
	     CASE TYP:ARGTYP OF
		  ARITH:(K:INTEGER);TAG:(N:INTEGER)
	   END;

  INSTYP=(NONE,JUMP,CBR /*CONDITIONAL BRANCH*/,
	  SINGLE /*SINGLE ARG*/, REGSINGLE /*REG + ARG*/,
	  DOUBLE /*DOUBLE ARG*/, FLOAT45 /*FPP INSTRUCT*/,
	  SIMPLETON /*NO ADDITIONAL WORDS*/);
VAR
  OPHEAD,OPPTR,O,CURROP:^OPNODE;
  TAGHEAD,TAGPTR,L:^TAGNODE;
  PTBPTR,PT:^PTBNODE;
  E:ELINK;
  ARG,TARG:ARGUMENT;
  TINSTR,INSTR:INSTYP;
  X, J, K,PASS, LINENUMBER, TPC,I,PC,SIZE:INTEGER;
  Y:REAL;
  INST:ARRAY[1..NINST] OF RECORD
			    NAM:NAME;TYP:INSTYP
			  END;
  F,G:TEXT;
  CH:CHAR;
  FOUND:BOOLEAN;
  LINE:ARRAY[1..LINELENG] OF CHAR;
  TOKEN:NAME;
  BRVALID,GOODLABEL:BOOLEAN;
  LABELVALUE:INTEGER;
  LASTNONBLANK:INTEGER;

  PROCEDURE INIT;    /*OVERLAY - INIT CODE IS ONE SEGMENT*/

  VAR
    STR		: TSTRING;
    CDATA	: CSIDATA;
    OKEY	: BOOLEAN;

   FUNCTION GTLINE	( VAR S : TSTRING)	: BOOLEAN;
   BEGIN
     (*$C	.MCALL	.GTLIN
		MOV	S(%6), %1		;
		MOV	(7)+, -(6)		;
		.BYTE	'*, ^O200		;
		MOV	%6, %2			;
		.GLOBL	LOWSTK,	HISTK		;
		CALL	LOWSTK			;
		MOV	#^O1000, @#^O46		;
		.GTLIN	%1, %2			;
		CLR	@#^O46			;
		CALL	HISTK			;
		TST	(6)+			;
     *)
	GTLINE := S[1]=CHR(0)
   END;

   BEGIN
     LINENUMBER:=0;  PC:=0;SIZE:=0;
     TAGHEAD:=NIL;OPHEAD:=NIL;CURROP:=NIL;CH:=' ';
     INST[1].NAM:='BNE   ';INST[1].TYP:=CBR;
     INST[2].NAM:='BEQ   ';INST[2].TYP:=CBR;
     INST[3].NAM:='BPL   ';INST[3].TYP:=CBR;
     INST[4].NAM:='BMI   ';INST[4].TYP:=CBR;
     INST[5].NAM:='BVC   ';INST[5].TYP:=CBR;
     INST[6].NAM:='BVS   ';INST[6].TYP:=CBR;
     INST[7].NAM:='BCC   ';INST[7].TYP:=CBR;
     INST[8].NAM:='BCS   ';INST[8].TYP:=CBR;
     INST[9].NAM:='BGE   ';INST[9].TYP:=CBR;
     INST[10].NAM:='BLT   ';INST[10].TYP:=CBR;
     INST[11].NAM:='BGT   ';INST[11].TYP:=CBR;
     INST[12].NAM:='BLE   ';INST[12].TYP:=CBR;
     INST[13].NAM:='BHI   ';INST[13].TYP:=CBR;
     INST[14].NAM:='BLOS  ';INST[14].TYP:=CBR;
     INST[15].NAM:='BHIS  ';INST[15].TYP:=CBR;
     INST[16].NAM:='BLO   ';INST[16].TYP:=CBR;
     INST[17].NAM:='ABSF  ';INST[17].TYP:=SINGLE   ;
     INST[18].NAM:='ADC   ';INST[18].TYP:=SINGLE   ;
     INST[19].NAM:='ADCB  ';INST[19].TYP:=SINGLE   ;
     INST[20].NAM:='ADD   ';INST[20].TYP:=DOUBLE   ;
     INST[21].NAM:='ADDF  ';INST[21].TYP:=REGSINGLE;
     INST[22].NAM:='ASH   ';INST[22].TYP:=REGSINGLE;
     INST[23].NAM:='ASHC  ';INST[23].TYP:=REGSINGLE;
     INST[24].NAM:='ASL   ';INST[24].TYP:=SINGLE   ;
     INST[25].NAM:='ASLB  ';INST[25].TYP:=SINGLE   ;
     INST[26].NAM:='ASR   ';INST[26].TYP:=SINGLE   ;
     INST[27].NAM:='ASRB  ';INST[27].TYP:=SINGLE   ;
     INST[28].NAM:='BIC   ';INST[28].TYP:=DOUBLE   ;
     INST[29].NAM:='BICB  ';INST[29].TYP:=DOUBLE   ;
     INST[30].NAM:='BIS   ';INST[30].TYP:=DOUBLE   ;
     INST[31].NAM:='BISB  ';INST[31].TYP:=DOUBLE   ;
     INST[32].NAM:='BIT   ';INST[32].TYP:=DOUBLE   ;
     INST[33].NAM:='BITB  ';INST[33].TYP:=DOUBLE   ;
     INST[34].NAM:='BPT   ';INST[34].TYP:=SIMPLETON;
     INST[35].NAM:='BR    ';INST[35].TYP:=SIMPLETON;
     INST[36].NAM:='CCC   ';INST[36].TYP:=SIMPLETON;
     INST[37].NAM:='CFCC  ';INST[37].TYP:=SIMPLETON;
     INST[38].NAM:='CLC   ';INST[38].TYP:=SIMPLETON;
     INST[39].NAM:='CLN   ';INST[39].TYP:=SIMPLETON;
     INST[40].NAM:='CLR   ';INST[40].TYP:=SINGLE   ;
     INST[41].NAM:='CLRB  ';INST[41].TYP:=SINGLE   ;
     INST[42].NAM:='CLRF  ';INST[42].TYP:=SINGLE   ;
     INST[43].NAM:='CLV   ';INST[43].TYP:=SIMPLETON;
     INST[44].NAM:='CLZ   ';INST[44].TYP:=SIMPLETON;
     INST[45].NAM:='CMP   ';INST[45].TYP:=DOUBLE   ;
     INST[46].NAM:='CMPB  ';INST[46].TYP:=DOUBLE   ;
     INST[47].NAM:='CMPF  ';INST[47].TYP:=REGSINGLE;
     INST[48].NAM:='COM   ';INST[48].TYP:=SINGLE   ;
     INST[49].NAM:='COMB  ';INST[49].TYP:=SINGLE   ;
     INST[50].NAM:='DEC   ';INST[50].TYP:=SINGLE   ;
     INST[51].NAM:='DECB  ';INST[51].TYP:=SINGLE   ;
     INST[52].NAM:='DIV   ';INST[52].TYP:=REGSINGLE;
     INST[53].NAM:='DIVF  ';INST[53].TYP:=REGSINGLE;
     INST[54].NAM:='EMT   ';INST[54].TYP:=SIMPLETON;
     INST[55].NAM:='FADD  ';INST[55].TYP:=SIMPLETON;
     INST[56].NAM:='FDIV  ';INST[56].TYP:=SIMPLETON;
     INST[57].NAM:='FMUL  ';INST[57].TYP:=SIMPLETON;
     INST[58].NAM:='FSUB  ';INST[58].TYP:=SIMPLETON;
     INST[59].NAM:='HALT  ';INST[59].TYP:=SIMPLETON;
     INST[60].NAM:='INC   ';INST[60].TYP:=SINGLE   ;
     INST[61].NAM:='INCB  ';INST[61].TYP:=SINGLE   ;
     INST[62].NAM:='IOT   ';INST[62].TYP:=SIMPLETON;
     INST[63].NAM:='JMP   ';INST[63].TYP:=JUMP     ;
     INST[64].NAM:='JSR   ';INST[64].TYP:=REGSINGLE;
     INST[65].NAM:='LDCIF ';INST[65].TYP:=REGSINGLE;
     INST[66].NAM:='LDF   ';INST[66].TYP:=REGSINGLE;
     INST[67].NAM:='MODF  ';INST[67].TYP:=REGSINGLE;
     INST[68].NAM:='MOV   ';INST[68].TYP:=DOUBLE   ;
     INST[69].NAM:='MOVB  ';INST[69].TYP:=DOUBLE   ;
     INST[70].NAM:='MUL   ';INST[70].TYP:=REGSINGLE;
     INST[71].NAM:='MULF  ';INST[71].TYP:=REGSINGLE;
     INST[72].NAM:='NEG   ';INST[72].TYP:=SINGLE   ;
     INST[73].NAM:='NEGB  ';INST[73].TYP:=SINGLE   ;
     INST[74].NAM:='NEGF  ';INST[74].TYP:=SINGLE   ;
     INST[75].NAM:='NOP   ';INST[75].TYP:=SIMPLETON;
     INST[76].NAM:='RESET ';INST[76].TYP:=SIMPLETON;
     INST[77].NAM:='ROL   ';INST[77].TYP:=SINGLE   ;
     INST[78].NAM:='ROLB  ';INST[78].TYP:=SINGLE   ;
     INST[79].NAM:='ROR   ';INST[79].TYP:=SINGLE   ;
     INST[80].NAM:='RORB  ';INST[80].TYP:=SINGLE   ;
     INST[81].NAM:='RTI   ';INST[81].TYP:=SIMPLETON;
     INST[82].NAM:='RTS   ';INST[82].TYP:=SIMPLETON;
     INST[83].NAM:='RTT   ';INST[83].TYP:=SIMPLETON;
     INST[84].NAM:='SBC   ';INST[84].TYP:=SINGLE   ;
     INST[85].NAM:='SBCB  ';INST[85].TYP:=SINGLE   ;
     INST[86].NAM:='SCC   ';INST[86].TYP:=SIMPLETON;
     INST[87].NAM:='SEC   ';INST[87].TYP:=SIMPLETON;
     INST[88].NAM:='SEN   ';INST[88].TYP:=SIMPLETON;
     INST[89].NAM:='SETF  ';INST[89].TYP:=SIMPLETON;
     INST[90].NAM:='SEV   ';INST[90].TYP:=SIMPLETON;
     INST[91].NAM:='SEZ   ';INST[91].TYP:=SIMPLETON;
     INST[92].NAM:='SOB   ';INST[92].TYP:=SIMPLETON;
     INST[93].NAM:='SPL   ';INST[93].TYP:=SIMPLETON;
     INST[94].NAM:='STCFI ';INST[94].TYP:=REGSINGLE;
     INST[95].NAM:='STF   ';INST[95].TYP:=REGSINGLE;
     INST[96].NAM:='SUB   ';INST[96].TYP:=DOUBLE   ;
     INST[97].NAM:='SUBF  ';INST[97].TYP:=REGSINGLE;
     INST[98].NAM:='SWAB  ';INST[98].TYP:=SINGLE   ;
     INST[99].NAM:='SXT   ';INST[99].TYP:=SINGLE   ;
     INST[100].NAM:='TRAP  ';INST[100].TYP:=SIMPLETON;
     INST[101].NAM:='TST   ';INST[101].TYP:=SINGLE   ;
     INST[102].NAM:='TSTB  ';INST[102].TYP:=SINGLE   ;
     INST[103].NAM:='TSTF  ';INST[103].TYP:=SINGLE   ;
     INST[104].NAM:='WAIT  ';INST[104].TYP:=SIMPLETON;
     INST[105].NAM:='XOR   ';INST[105].TYP:=REGSINGLE;
      REPEAT
	OKEY := FALSE;
	IF GTLINE (STR)
	   THEN WRITELN (VERSION)
	   ELSE
	    BEGIN
		OKEY := CSI (STR, 'MACMAC      ', CDATA);
		IF OKEY THEN WITH CDATA DO
			OKEY := OFLAG1 AND IFLAG[1] AND (SWITCHCOUNT=0);
		IF NOT OKEY THEN WRITELN ('ILLEGAL COMAND')
	    END
      UNTIL OKEY;
      G := CDATA.O1;
      F := CDATA.INN[1]
   END;

  /*OVERLAY - ALL OTHER PROCS ARE THE REST OF THE SEGMENT*/
  PROCEDURE LOOKUP(N:INTEGER);
    /*FIND TOKEN NODE OR CREATE ONE*/
   BEGIN
     TAGPTR:=TAGHEAD;
     FOUND:=FALSE;
     WHILE (TAGPTR<>NIL) AND (NOT FOUND) DO
      BEGIN
	FOUND:=N=TAGPTR^.NAM;
	L:=TAGPTR;
	TAGPTR:=TAGPTR^.NEXT
      END;
     IF NOT FOUND
      THEN
       BEGIN
	 NEW(L);
	 WITH L^ DO
	  BEGIN
	    NAM:=N;LOCATION:=-1;
	    PTBBRANCH:=NIL;
	    PTBJUMP:=NIL;
	    NEXT:=TAGHEAD
	  END;
	 TAGHEAD:=L
       END
   END;

  PROCEDURE WRITELABEL(N:INTEGER);
  VAR
    DIGITS:ARRAY[1..10] OF INTEGER;
    I:INTEGER;
   BEGIN
     WRITE(G,'L'); I:=6;
      REPEAT
       I:=I-1;
       DIGITS[I]:=N MOD 10;
       N:=N DIV 10;
      UNTIL (I=1) OR (N=0);
     FOR I:=I TO 5 DO WRITE(G,CHR(ORD('0')+DIGITS[I]))
   END   /*WRITELABEL*/;

  PROCEDURE BUILDJUMPNODES;
    PROCEDURE FILLIN;
     BEGIN
       WITH OPPTR^ DO
	BEGIN
	  LOCATION:=PC;
	  BRDESTIN:=-1;
	  JMPDESTIN:=-1;
	  EFFECT:=NIL;
	  OPTYPE:=JMP;
	  OKTOOP:=FALSE;
	  NEXT:=NIL
	END;
       LOOKUP(ARG.N);
       NEW(PT);
       PT^.P:=OPPTR;
       PT^.NEXT:=L^.PTBJUMP;
       L^.PTBJUMP:=PT
     END;
   BEGIN
     NEW(OPPTR);
     IF OPHEAD=NIL
      THEN
      OPHEAD:=OPPTR
      ELSE
      CURROP^.NEXT:=OPPTR;
     CURROP:=OPPTR;
     FILLIN;
   END;

  PROCEDURE BUILDBRNODES;
   BEGIN
     BUILDJUMPNODES;
     WITH OPPTR^ DO
      BEGIN
	LOCATION :=TPC;
	OPTYPE:=BRJMP;
      END;
     IF TARG.TYP=ARITH
      THEN
      OPPTR^.BRDESTIN:=TPC+TARG.K
      ELSE
       BEGIN
	 LOOKUP(TARG.N);
	 NEW(PT);
	 PT^.P:=OPPTR;
	 PT^.NEXT:=L^.PTBBRANCH;
	 L^.PTBBRANCH:=PT;
       END;
   END;
  PROCEDURE GETLINE;
  VAR
    T:INTEGER;
   BEGIN
     I:=1;
      REPEAT
       READ(F,LINE[I]);
       I:=I+1;
      UNTIL EOF(F) OR EOLN(F) OR (I>LINELENG);
     READLN(F);
     FOR T:=I TO LASTNONBLANK DO LINE[T]:=' ';
     LASTNONBLANK:=I-1;
     I:=1;
   END;

  PROCEDURE PUTLINE;
  VAR
    I:INTEGER;
   BEGIN
     FOR I:=1 TO LASTNONBLANK DO WRITE(G,LINE[I]);
     WRITELN(G);
   END;
  PROCEDURE SCANLINE;   /*SET PC,TAG,INSTR,ARG*/
    PROCEDURE ADVANCE(CH:CHAR);
     BEGIN
       WHILE (I<=LINELENG) AND (LINE[I]<>CH) DO
       I:=I+1;
       I:=I+1
     END;

    PROCEDURE SKIPSPACES;
     BEGIN
       WHILE (I<=LINELENG) AND (ORD(LINE[I])<=40B) DO
       I:=I+1
     END;

    PROCEDURE TAGDEF;
     BEGIN
       LOOKUP(LABELVALUE);
       /*   IF (L^.LOCATION<>-1) AND (PASS=1)
        THEN
        BEGIN
        WRITELN('TRYING TO DEFINE ',TOKEN,' TWICE AT LINE',LINENUMBER);
        WRITELN(LINE);
        END
        ELSE
	*/ L^.LOCATION:=PC
     END;

    PROCEDURE  GETNUM(VAR N:INTEGER);
    VAR
      J,K:INTEGER;
     BEGIN
       J:=I;
       WHILE (J<=LINELENG) AND NOT(LINE[J] IN ['0'..'9']) DO
       J:=J+1;
       IF J>LINELENG
	THEN
	 BEGIN
	   WRITELN('NO <> IN LINE');
	   WRITELN(LINENUMBER,'  ',LINE);
	 END
	ELSE
	 BEGIN
	   K:=0;
	   WHILE LINE[J] IN ['0'..'9'] DO
	    BEGIN
	      K:=K*10+ORD(LINE[J])-60B;
	      J:=J+1
	    END;
	   N:=K
	 END
     END;

    PROCEDURE GETTOKEN;
    VAR
      J:INTEGER;
     BEGIN
       J:=1;
       SKIPSPACES;
       GOODLABEL:=(LINE[I]='L') AND (LINE[I+1] IN ['0'..'9']);
       IF GOODLABEL
	THEN GETNUM(LABELVALUE);
       WHILE (J<=6) AND (I<=LINELENG)
       AND (LINE[I] IN ['A'..'Z','0'..'9','.','$'])
       /*TOKENS ARE MADE OF THIS*/
       DO
	BEGIN
	  TOKEN[J]:=LINE[I];
	  I:=I+1;
	  J:=J+1
	END;
       SKIPSPACES;
       WHILE J<=6 DO
	BEGIN
	  /*FILL TOKEN WITH BLANKS*/
	  TOKEN[J]:=' ';
	  J:=J+1
	END
     END;
    PROCEDURE BRARGS;  /*ARGUMENT FOR A BRANCH*/
     BEGIN
       IF LINE[I]='.'
	THEN
	 BEGIN
	   BRVALID:=TRUE;
	   ARG.TYP:=ARITH;
	   I:=I+1;
	   SKIPSPACES;
	   IF I<=LINELENG
	    THEN
	     BEGIN
	       GETNUM(ARG.K);
	       ARG.K:=ARG.K DIV 2;
	       IF LINE[I]='-'
		THEN ARG.K:=-ARG.K
                /*       ELSE
                 IF LINE[I]<>'+'
                 THEN
                 BEGIN
                 WRITELN('FUNNY BRANCH ARG ');
                 WRITELN(LINENUMBER,'  ',LINE);
		 END;  */
	     END
	 END
	ELSE
	 BEGIN
	   GETTOKEN;
	   BRVALID:=GOODLABEL;
	   ARG.TYP:=TAG;
	   ARG.N:=LABELVALUE
	 END
     END;

    FUNCTION TOKENISINSTR:BOOLEAN;
    VAR
      I,J:INTEGER;FOUND:BOOLEAN;
     BEGIN
       I:=17; J:=NINST;
       FOUND:=FALSE;
	REPEAT
	 K:=(I+J)DIV 2;    /*BINARY SEARCH FOR INST CODES EXCEPT BRANCHES*/
	 IF INST[K].NAM<=TOKEN
	  THEN I:=K+1;
	 IF INST[K].NAM>=TOKEN
	  THEN J:=K-1;
	UNTIL I>J;
       IF I-J=2
	THEN FOUND:=TRUE;
       IF NOT FOUND
	THEN
	 BEGIN
	   K:=0;     /*LOOK FOR THE BRANCHES*/
	    REPEAT
	     K:=K+1
	    UNTIL (INST[K].NAM=TOKEN) OR (K=17);
	   IF K<>17
	    THEN FOUND:=TRUE
	 END;
       IF FOUND
	THEN INSTR:=INST[K].TYP
	ELSE INSTR:=NONE;
       TOKENISINSTR:=FOUND;
     END;

    PROCEDURE WORDS;
     BEGIN
       WHILE I<=LINELENG DO
	BEGIN
	  SIZE:=SIZE+1;
	  ADVANCE(',');
	END
     END;

    PROCEDURE BYTES;
    VAR
      J:INTEGER;
     BEGIN
       J:=0;
       WHILE I<=LINELENG DO
	BEGIN
	  J:=J+1;
	  ADVANCE(',')
	END;
       SIZE:=J DIV 2
     END;
    PROCEDURE TESTARG;
    VAR
      CH:CHAR;
     BEGIN
       ARG.TYP:=TAG;
       CH:=LINE[I];
       CASE CH OF
	 '@':
	  BEGIN
	    I:=I+1;
	    ARG.M:=DEFER;
	    IF (LINE[I]<>'%') AND( LINE[I]<>'-')
	     THEN
	     IF LINE[I]='('
	      THEN
	       BEGIN
		 ADVANCE(')');
		 IF LINE[I]<>'+'
		  THEN SIZE:=SIZE+1
	       END
	      ELSE SIZE:=SIZE+1;
	  END;
	 '^':
	  BEGIN
	    ARG.M:=INDEXED;SIZE:=SIZE+1
	  END;
	 '-': ARG.M:=AUTODEC;
	 '(': ARG.M:=REGDEFER;
	 '#':
	  BEGIN
	    ARG.M:=IMMEDIATE;
	    SIZE:=SIZE+1;
	  END;
	 '%': ARG.M:=REGISTER;
	 '0','1','2','3','4','5','6','7','8','9':
	  BEGIN
	    ARG.M:=INDEXED;
	    SIZE:=SIZE+1;
	  END;
	 'A','B','C','D','E','F','G','H','I','J','K','L','M','N',
	 'O','P','Q','R','S','T','U','V','W','X','Y','Z',
	 ',','$':
	  BEGIN
	    ARG.M:=RELATIVE;
	    SIZE:=SIZE+1;
	    GETTOKEN;
	    IF NOT GOODLABEL
	     THEN ARG.M:=INDEXED;
	    ARG.N:=LABELVALUE
	  END;
	END
     END;
   BEGIN
     /*SET PC,INSTR,ARG,SIZE,LINENUMBER,
      DO TOKEN LOOKUPS*/
     PC:=PC+SIZE;
     L:=NIL;
     SIZE:=0;
     LINENUMBER:=LINENUMBER+1;
     INSTR:=NONE;
     GETLINE;
     GETTOKEN;
     WHILE LINE[I]=':'
     DO
      BEGIN
	IF GOODLABEL
	THEN TAGDEF;I:=I+1;GETTOKEN
      END;
     IF (TOKEN<>'      ') AND (LINE[I]<>'=')
      THEN
       BEGIN
	 IF TOKEN='.WORD '
	  THEN WORDS
	  ELSE
	  IF TOKEN='.BYTE '
	   THEN BYTES
	   ELSE
	   IF TOKEN='.BLKW '
	    THEN GETNUM(SIZE)
	    ELSE
	    IF TOKENISINSTR
	     THEN
	      BEGIN
		SIZE:=1;
		CASE INSTR OF
		  CBR:
		  BRARGS;
		  JUMP, SINGLE:
		  TESTARG;
		  REGSINGLE:
		   BEGIN
		     ADVANCE(',');
		     TESTARG
		   END;
		  DOUBLE:
		   BEGIN
		     TESTARG;ADVANCE(',');TESTARG
		   END;
		  FLOAT45:
		  /*NO ACTION TAKEN, SUBSUMED UNDER OTHER TYPES - WE HOPE*/;
		  SIMPLETON:
		  /*NOTHING*/;
		 END
	      END
	     ELSE
	     IF TOKEN[1]<>'.'
	      THEN SIZE:=1;
       END
   END;

  PROCEDURE SAVEINFO;
   BEGIN
     TPC:=PC;
     TINSTR:=INSTR;
     TARG:=ARG
   END;
  PROCEDURE OPTIMIZE;
    PROCEDURE EFFECTS(E:ELINK;I:INTEGER);
     BEGIN
       WHILE E<>NIL DO
	BEGIN
	  WITH E^.P^ DO
	  IF (JMPDESTIN<LOCATION)
	   AND (JMPDESTIN>=0)
	   THEN JMPDESTIN:=JMPDESTIN+I
	   ELSE JMPDESTIN:=JMPDESTIN-I;
	  E:=E^.NEXT
	END
     END;
    PROCEDURE OPTIM(O:LINK);
    VAR
      E:ELINK;
     BEGIN
       WITH O^ DO
       IF NOT OKTOOP   /*IF NOT ALREADY DONE*/
	THEN
	 BEGIN
	   IF (OPTYPE=BRJMP)
	    THEN
	    IF (BRDESTIN=LOCATION+3) AND (ABS(JMPDESTIN-LOCATION)<=127)
	     AND (JMPDESTIN>=0)
	     THEN
	      BEGIN
		OKTOOP:=TRUE;J:=J+2;
		EFFECTS(EFFECT,2);
		E:=EFFECT;
		WHILE E<>NIL DO
		 BEGIN
		   OPTIM(E^.P);
		   E:=E^.NEXT
		 END
	      END;
	   IF (OPTYPE=JMP) AND (ABS(JMPDESTIN-LOCATION)<=127)
	    AND (JMPDESTIN>=0)
	    THEN
	     BEGIN
	       OKTOOP:=TRUE;J:=J+1;
	       EFFECTS(EFFECT,1);
	       E:=EFFECT;
	       WHILE E<>NIL DO
		BEGIN
		  OPTIM(E^.P);
		  E:=E^.NEXT
		END
	     END
	 END
     END;
   BEGIN
     /*FIRST PHASE  GO DOWN TAG CHAIN,
      FILL IN PTB NODES WITH DESTINATION INFO*/
     TAGPTR:=TAGHEAD;
     WHILE TAGPTR<>NIL DO
      BEGIN
        /*    IF TAGPTR^.LOCATION=-1
	 THEN WRITELN('UNDEF TAG ',TAGPTR^.NAM);  */
	PTBPTR:=TAGPTR^.PTBBRANCH;;
	WHILE PTBPTR<>NIL DO
	 BEGIN
	   PTBPTR^.P^.BRDESTIN:=TAGPTR^.LOCATION;
	   PTBPTR:=PTBPTR^.NEXT
	 END;
	PTBPTR:=TAGPTR^.PTBJUMP;
	WHILE PTBPTR<>NIL DO
	 BEGIN
	   PTBPTR^.P^.JMPDESTIN:=TAGPTR^.LOCATION;
	   PTBPTR:=PTBPTR^.NEXT
	 END;
	TAGPTR:=TAGPTR^.NEXT
      END;
     /*SECOND PHASE - BUILD EFFECT CHAINS*/
     OPPTR:=OPHEAD;
     WHILE OPPTR<>NIL DO
      BEGIN
	IF ABS(OPPTR^.JMPDESTIN-OPPTR^.LOCATION)<300
	 THEN
	  BEGIN
	    /*ANYTHING LARGER PROBABLY CANNOT EVER BE OPTIMIZED*/
	    O:=OPHEAD;
	    IF (OPPTR^.LOCATION <OPPTR^.JMPDESTIN)
	     THEN
	      BEGIN
		/*FORWARD JUMP SPANNING O^*/
		WHILE (O<>NIL) AND(O^.LOCATION<=OPPTR^.LOCATION) DO
		O:=O^.NEXT;
		WHILE (O<>NIL) AND (O^.LOCATION<OPPTR^.JMPDESTIN) DO
		 BEGIN
		   NEW(E); E^.P:=OPPTR;
		   E^.NEXT:=O^.EFFECT;
		   O^.EFFECT:=E;
		   O:=O^.NEXT
		 END
	      END
	     ELSE
	     /*BACKWARD JUMP*/
	      BEGIN
		WHILE (O<>NIL) AND (O^.LOCATION<OPPTR^.JMPDESTIN) DO
		O:=O^.NEXT;
		WHILE (O<>NIL) AND (O^.LOCATION <OPPTR^.LOCATION) DO
		 BEGIN
		   NEW(E); E^.P:=OPPTR;
		   E^.NEXT:=O^.EFFECT;
		   O^.EFFECT:=E;
		   O:=O^.NEXT
		 END
	      END
	  END;
	OPPTR:=OPPTR^.NEXT
      END;

     /*PHASE THREE - FIGURE THE OPTIMIZATION*/
     J:=0;
     OPPTR:=OPHEAD;
     WHILE OPPTR<>NIL DO
      BEGIN
	OPTIM(OPPTR);
	OPPTR:=OPPTR^.NEXT
      END;
     X:=J;Y:=100.0*J/PC;
   END;
  PROCEDURE  REPLACE;
   BEGIN
     CASE OPPTR^.OPTYPE OF
       BRJMP:
	BEGIN
	  IF L<>NIL
	   THEN
	    BEGIN
	      WRITELABEL(L^.NAM); WRITELN(G,':')
	    END;
	  IF ODD(K)
	   THEN K:=K+1
	   ELSE K:=K-1;
	  WRITE(G,'   ',INST[K].NAM);
	  SCANLINE;
	  WHILE INSTR=NONE DO
	   BEGIN
	     PUTLINE;SCANLINE
	   END;
	  IF INSTR<>JUMP
	   THEN WRITELN('ERROR AT BRJMP NODE',LINENUMBER);
	  WRITELABEL(ARG.N);WRITELN(G)
	END;
       JMP:
	BEGIN
	  IF INSTR<>JUMP
	   THEN WRITELN('ERROR AT JMP NODE ',LINENUMBER);
	  IF L<>NIL
	   THEN
	    BEGIN
	      WRITELABEL(L^.NAM); WRITELN(G,':')
	    END;
	  WRITE(G,'   BR    ');
	  WRITELABEL(ARG.N);WRITELN(G)
	END;
      END;
   END;
  /*OVERLAY SCRATCH THIS LINE
   PROCEDURE INIT;EXTERNAL;
   PROCEDURE SCANLINE;EXTERNAL;
   PROCEDURE SAVEINFO;EXTERNAL;
   PROCEDURE BUILDBRNODES;EXTERNAL;
   PROCEDURE BUILDJUMPNODES;EXTERNAL;
   PROCEDURE OPTIMIZE;EXTERNAL;
   PROCEDURE PUTLINE;EXTERNAL;
   PROCEDURE REPLACE;EXTERNAL;
   */
 BEGIN
   /*MAIN*/
   LASTNONBLANK:=LINELENG;
   INIT;PASS:=1;
    REPEAT
      REPEAT
       SCANLINE;
      UNTIL (EOF(F)) OR (BRVALID AND (INSTR=CBR))
			 OR ((INSTR=JUMP) AND (ARG.M=RELATIVE));
     IF NOT EOF(F)
      THEN
      IF (INSTR=CBR) AND BRVALID
       THEN
	BEGIN
	  WHILE BRVALID AND (INSTR=CBR) AND NOT EOF(F) DO
	   BEGIN
	     SAVEINFO;
	     SCANLINE;
	   END;
	  IF (INSTR=JUMP) AND (ARG.M=RELATIVE)
	   THEN
	   BUILDBRNODES;
	END
       ELSE BUILDJUMPNODES
    UNTIL EOF(F);
   RESET(F);
   OPTIMIZE;
   PASS:=2;
   LINENUMBER:=0;
   PC:=0;OPPTR:=OPHEAD;
   WHILE OPPTR<>NIL DO
    BEGIN
      SCANLINE;
      WHILE (PC<OPPTR^.LOCATION) OR (INSTR=NONE) DO
       BEGIN
	 PUTLINE;SCANLINE
       END;
      IF OPPTR^.OKTOOP
       THEN REPLACE
       ELSE PUTLINE;
      OPPTR:=OPPTR^.NEXT
    END;
   WHILE NOT EOF(F) DO
    BEGIN
      SCANLINE;PUTLINE
    END;
   CLOSE(G);
   WRITELN('IMPROVEMENT',X:6,' WORDS',Y:6:1,'%');
 END.
