(*	INTRPT V1.2  ---  INTERRUPT INITIALIZATION *)

(*$T-	STACK CHECK MUST BE DISABLED FOR ASYNC INTERRUPTS *)

(*$C	.MCALL	.PROTEC			*)
(*$C	.GLOBL	RTAREA, $USRPC, $RESR5	*)

PROCEDURE SETINTERRUPT(VECTOR: INTEGER; PROCEDURE ROUTINE; PS: INTEGER);
VAR
  PROTFAIL: BOOLEAN;

BEGIN (*SETINTERRUPT*)
  PROTFAIL:= FALSE;
(*$C
	.PROTEC #RTAREA,VECTOR(6)	;GET THE VECTOR
	ROLB	PROTFAIL(6)		;PUT CARRY INTO BYTE
*)
  IF PROTFAIL THEN WRITELN('VECTOR AT ',VECTOR:-1,' NOT AVAILABLE')
  ELSE BEGIN
(*$C
	MOV	VECTOR(6),%0		;GET VECTOR ADDRESS
	MOV	VECTOR-4(6),(0)+	;SET INTERRUPT PC
	MOV	PS(6),(0)+		;AND PS
*)
    END;
END (*SETINTERRUPT*);

PROCEDURE SAVREG;
BEGIN
(*$C	MOV	%5,-(6)
	MOV	%4,-(6)
	MOV	%3,-(6)
	MOV	%2,-(6)
	MOV	%1,-(6)
	MOV	%0,-(6)
	MOVB	@#^O56,-(6)
	MOV	$USRPC,-(6)
	MOV	$RESR5,%5
	JMP	@16(6)
*)
END;

PROCEDURE RESREG;
BEGIN
(*$C	TST	(6)+
	MOV	(6)+,$USRPC
	MOVB	(6)+,@#^O56
	MOV	(6)+,%0
	MOV	(6)+,%1
	MOV	(6)+,%2
	MOV	(6)+,%3
	MOV	(6)+,%4
	MOV	(6)+,%5
	TST	(6)+
	RTI
*)
END;
