
	(*		programma wwoda i kontrolq			*)
	(*	opisaniq shemy elektri~eskoj principialxnoj  'KODR'	*)
	(*   	prednazna~ena dlq wwoda i kontrolq ishodnoj informacii	*)
	(*	ob elektri~eskoj principialxnoj sheme.			*)
	(*		oblastx` primeneniq programmy qwlq`tsq		*)
	(*	awtomatizirowannye sistemy konstruktorskogo proektiro-	*)
	(*	waniq pe~atnyh plat i drugie sistemy, trebu`{ie dlq	*)
	(*	swoego funkcionirowaniq informaci` ob elektri~eskoj	*)
	(*	principialxnoj sheme.					*)
	(*		whodnymi dannymi programmy 'KODR' qwlqetsq	*)
	(*	shema elektri~eskaq principialxnaq i pere~enx ee	*)
	(*	elementow.						*)
	(*		ograni~eniq, nakladywaemye programmoj 		*)
	(*		'KODR'	na whodnye dannye:			*)
	(*	-~islo q~eek kodirowo~nogo blanka ne bolee ~em 177*177;	*)
	(*	-ne dopuskaet gruppowyh elementow na dannom etape	*)
	(*	realizacii.						*)
	(*	wse ostalxnye parametry shemy( ~islo elementow shemy,	*)
	(*	~islo tipow elementow, ~islo cepej i pr.) movno s~itatx *)
	(*	realxno neograni~ennymi.				*)
	(*		wyhodnymi dannymi programmy 'KODR' qwlqetsq	*)
	(*	ottranslirowannoe opisanie zakodirowannoj shemy 	*)
	(*	elektri~eskoj principialxnoj, predstawlennoe w wide	*)
	(*	posledowatelxnosti simwolow prostranstwenno-dekompozi-	*)
	(*	cionnogo qzyka wo wnutrennie struktury sapr		*)	
	(*		programma 'KODR' wypolnqet sledu`{ie operacii:	*)
	(*	-sintaksi~eskij i semanti~eskij kontrolx ishodnogo	*)
	(*	opisaniq shemy elektri~eskoj principialxnoj;		*)
	(*	-prowerku nali~iq opisaniq elektroradioelementow w	*)
	(*	baze dannyh (ne realizowanno);				*)
	(*	-preobrazowanie ishodnogo opisaniq wo wnutrennie	*)
	(*	struktury sapr;						*)
	(*	-zapisx polu~ennyh informacionnyh struktur na wne{nie	*)
	(*	zapomina`{ie ustrojstwa.				*)
	(*		struktura programmy 'KODR'			*)
	(*	struktura programmy sostoit iz treh posledowatelxno	*)
	(*	wypolnqemyh ~astej:					*)
	(*								*)
	(*	INIZDATE - iniciaciq wnutrennih struktur dannyh		*)
	(*		programmy,otkrywaet whodnye i wyhodnye fajly.	*)
	(*	GROSS	-  semanti~eskij i sintaksi~eskij razbor	*)	
	(*		zakodirowannogo opisaniq shemy elektri~eskoj 	*)
	(*		principialxnoj.					*)
	(*	tretxq ~astx sostoit iz kompleksa programm, wyda`{ih	*)
	(*	raznoobraznu` informaci` o sheme elektri~eskoj princi-  *)
	(*	pialxnoj.						*)
LABEL 99;
CONST
	MAXNUMBPINS	=    146   ;
	LONGNAME	=    6     ;
	LONGMARKER	=    10    ;
	MAXLONGSTRING	=    80	   ;
	MAXXX           =    177   ;
	MAXYY           =    177   ;
	MAXNUMBERERROR    =    30  ;
	MAXCOUNTERROR	=	30;
TYPE
	TYTREE		=	(FLAGTREE,FLAGJGUT,FLAGDUMB);
	TYPETREE	=	FLAGTREE..FLAGDUMB;
	TYNAME		= ARRAY [ 1..LONGNAME ] OF CHAR ;
	TYXX		= 1..MAXXX ;
	TYYY		= 1..MAXYY ;
	TYPINS		= 0..MAXNUMBPINS;
	TYMASPUANT	= ARRAY [CHAR ] OF INTEGER;
	TYMARKER	= ARRAY [ 1..LONGMARKER ] OF CHAR;
	TYSTRING	= ARRAY [ 1..MAXLONGSTRING ] OF CHAR;
	TYPOSITION	= 1..MAXLONGSTRING;
	PTRTREE		= ^TREE	   ;
	TREE		= RECORD
		TREENUMB : INTEGER   ;
		TREEFLAG : TYPETREE  ;
		TREENEXT : PTRTREE   ;
	END;
	PTRJGUT		= ^JGUT;
	JGUT		= RECORD
		JGUTNUMB    : INTEGER;
		JGUTTREE    : PTRTREE;
		JGUTJGUT    : PTRTREE;
		JGUTNEXT    : PTRJGUT;
	END;
	PTRPINS		= ^PINS	  ;
	PINS		= RECORD
		PINSNUMB    : INTEGER;
		PINSTREE    : PTRTREE;
		PINSNEXT    : PTRPINS;
	END;
	PTRMARKER	= ^MARKER    ;
	MARKER		= RECORD
		MARKERNAME:TYMARKER  ;
		MARKERTREE: PTRTREE  ;
		MARKERNEXT: PTRMARKER;
	END;
	PTRELEM		= ^ELEM      ;
	ELEM		= RECORD
		ELEMNAME : TYNAME    ;
		ELEMPINS : PTRPINS   ;
		ELEMNEXT : PTRELEM   ;
	END;
	PTRSEGM		= ^SEGM      ;
	SEGM		= RECORD     
		SEGMTREE : ARRAY[1..17] OF PTRTREE   ;
		SEGMRIGHT: PTRSEGM   ;
	END;
			
VAR
	ERR	: ARRAY [ 1..MAXNUMBERERROR ] OF INTEGER ;
				(*	massiw registracii o{ibok	*)
	OUT	: TEXT	;	(*	fajl soob{enij			*)
	INFILE  : TEXT  ;	(*	whodnoj fajl s opisaniem shemy	*)
				(*	elektri~eskoj principialxnoj	*)
	SHEF	: TEXT	;	(*	fajl wyhodnyh dannyh		*)
	XX	: TYXX  ;	(*	razmer kodirowo~nogo blanka po X*)
	YY	: TYYY  ;	(* 	razmer kodirowo~nogo blanka po Y*)
	XVAR	: TYXX	;	(*	teku{aq koordinata obrabatywae-	*)
				(*	moj q~ejki po X			*)
	YVAR	: TYYY	;	(*	teku{aq koordinata obrabatywae- *)
				(*	moj q~ejki po Y			*)
	NUMBTREE: INTEGER;	(*	teku{ij nomer obrabatywaemoj	*)
				(*	cepi				*)
	STRING	     : TYSTRING;(*	teku{aq stroka opisaniq shemy	*)
				(*	elektri~eskoj principialxnoj	*)
	SYMBOL       : CHAR;	(*	teku{ij obrabatywaemyj simwol	*)
	ROOTELEM     : PTRELEM;	(*	ukazatelx na na~alo spiska	*)
				(*	elementow			*)
	ROOTMARKER   : PTRMARKER;(*	ukazatelx na na~alo spiska	*)
				(*	markerow			*)
	ROOTJGUT     : PTRJGUT;	(*	ukazatelx na na~alo spiska	*)
				(*	prowodow vgutow			*)
	LOWERSEGM    : PTRSEGM;	(*	ukazatelx na na~alo Cpiska	*)
				(*	werhnej stroki q~eek		*)
	UPPERSEGM    : PTRSEGM;	(*	ukazatelx na na~alo Cpiska	*)
				(*	teku{ej stroki q~eek		*)
	ROOTTREE     : PTRTREE;	(*	ukazatelx na na~alo spiska	*)
				(*	cepej				*)
	MASPUANT     : TYMASPUANT;(*	massiw puant			*)
	POSITION     : TYPOSITION;(*	poziciq teku{ego simwola	*)
	COUNTERROR   : INTEGER;	(*	s~et~ik wstre~ennyh o{ibok	*)
	LONGSTRING   : INTEGER ;(*	dlina teku{ej stroki		*)

PROCEDURE ERROR(I:INTEGER);
FORWARD;

PROCEDURE READSYMBOL;
	(* procedura READSYMBOL prednazna~ena dlq s~itywaniq simwolow.	*)
	(* procedura wydaet sledu`{ij simwol iz whodnogo potoka;	*)
	(* pri etom wse probely ignoriru`tsq. esli simwol prinadlevit	*)
	(* teku{ej stroke, to wybiraem etot simwol.ina~e s~itywaet	*)
	(* sledu`{u` stroku iz whodnogo potoka i poziciq ukazywaet na	*)
	(* perwyj simwol w etoj stroke. pri wozniknowenii situacii	*)
	(* konca fajla wydaetsq soob{enie ob o{ibke.			*)	
BEGIN
	REPEAT
		IF POSITION>LONGSTRING
		THEN	BEGIN
			WRITE(OUT,' ');
			IF EOF (INFILE)
			THEN 	ERROR (1)
			ELSE	BEGIN
				REPEAT
					POSITION:=1;
					WHILE NOT EOLN (INFILE) DO
					BEGIN
						READ (INFILE,SYMBOL);
						WRITE(OUT,SYMBOL);
						STRING[POSITION]:=SYMBOL;
						POSITION:=POSITION+1;
					END;
	
					READLN(INFILE);
					WRITELN(OUT);
				UNTIL POSITION <> 1;	
			       	LONGSTRING:=POSITION-1;
				POSITION:=1;
			END;
		END;
		SYMBOL:=STRING[POSITION];

		POSITION:=POSITION+1;
	UNTIL	SYMBOL#' ';
END;

PROCEDURE ERROR;
	(* procedura ERROR prednazna~ena dlq registracii wstre~ennyh	*)
	(* o{ibok. procedura wydaet pod simwolom, pri s~itywanii	*)
	(* kotorogo woznikla o{ibka, nomer o{ibki. pri wozniknowenii	*)
	(* nekotoryh o{ibok procedura propuskaet simwoly do perwogo	*)
	(* simwola-razdelitelq ('*',';',',').				*)
BEGIN
	WRITELN(OUT,'^':POSITION,I:1);
	ERR[I]:=ERR[I]+1;
	CASE I OF
		2,3,5,8,9,11  :	REPEAT
					READSYMBOL;
				UNTIL	(SYMBOL=';')
				      OR(SYMBOL='*')
				      OR(SYMBOL=',');
		1: GOTO 99;
		ELSE
	END;			
	COUNTERROR:=COUNTERROR +1;
	IF COUNTERROR > MAXCOUNTERROR 
	THEN	BEGIN
		ERR[18]:=1;
		GOTO 99;
	END;
END;

PROCEDURE READSEGMTREE(X,Y,NUMBPUANT : INTEGER ;
			VAR CURRTREE : PTRTREE);
	(* procedura READSEGMTREE prednazna~ena dlq s~itywaniq cepej	*)
	(* w dannoj q~ejke.						*)
	(* procedura wydaet ukazatelx na cepx, podsoedinennu` k dannoj	*)
	(* puante dannoj q~ejki s koordinatami XX,YY . esli cepx ne 	*)
	(* podsoedinena, to wydaetsq ssylka NIL.			*)
VAR
	IX	:	TYXX;
	IY	:	TYYY;
	CURRSEGM:    PTRSEGM;
BEGIN
	CURRTREE:=NIL;
	IF ( X>0 ) AND ( X<=XX ) AND ( Y>0 ) AND ( Y<=YY )
	THEN	BEGIN
		IF Y =YVAR
		THEN	CURRSEGM:=UPPERSEGM
		ELSE	CURRSEGM:=LOWERSEGM;
		FOR IX:=1 TO ( X-1 ) DO
		CURRSEGM:=CURRSEGM^.SEGMRIGHT;
		CURRTREE:=CURRSEGM^.SEGMTREE [ NUMBPUANT ] ;
	END;
END;


PROCEDURE WRITESEGMTREE(X,Y,NUMBPUANT : INTEGER;
			    CURRTREE  : PTRTREE);
	(* procedura WRITESEGMTREE prednazna~ena dlq pe~ati cepej,	*)
	(* nahodq{ihsq w dannoj q~ejke.					*)
	(* procerura wydaet ssylku na cepx, podsoedinennu` k dannoj	*)
	(* puante dannoj q~ejki s koordinatami XX,YY . esli cepx ne	*)
	(* podsoedinena, to wydaetsq ssylka NIL.			*)
VAR
	IX	:	TYXX;
	IY	:	TYYY;
	CURRSEGM:    PTRSEGM;
BEGIN
	IF ( X>0 ) AND ( X<=XX ) AND ( Y>0 ) AND ( Y<=YY )
	THEN	BEGIN
		IF Y = YVAR
		THEN	CURRSEGM:=UPPERSEGM
		ELSE	CURRSEGM:=LOWERSEGM;
		FOR IX:=1 TO ( X-1 ) DO
		CURRSEGM:=CURRSEGM^.SEGMRIGHT;
		CURRSEGM^.SEGMTREE [ NUMBPUANT ]:=CURRTREE ;
	END;
END;

PROCEDURE SETTREETYPE(CURRTREE	:	PTRTREE;
		      FLAG	:	TYPETREE);
	(* procedura SETTREETYPE prednazna~ena dlq opredeleniq tipa cepi*)
	(* procedura priswaiwaet cepi opredelennyj tip w zawisimosti ot	*)
	(* nazna~eniq cepi : prowodnik-TREE, vgut- JGUT, libo, esli	*)
	(* nazna~enie cepi neizwestno-DUMB.				*)
VAR
	PROTREE	:	PTRTREE;
BEGIN
	PROTREE:=ROOTTREE;
	WHILE PROTREE <> NIL DO
	BEGIN
		IF PROTREE^.TREENUMB = CURRTREE^.TREENUMB
		THEN
			IF PROTREE^.TREEFLAG <> FLAG
			THEN	IF PROTREE^.TREEFLAG = FLAGDUMB
				THEN	PROTREE^.TREEFLAG:=FLAG
			ELSE	ERROR(23);
		PROTREE:=PROTREE^.TREENEXT;
	END;
END;

PROCEDURE TREEEQ(CURRTREE	:	PTRTREE;
		 NEXTTREE	:	PTRTREE);
	(* procedura tREEEQ prednazna~ena dlq obxedineniq ekwiwalentnyh	*)
	(* cepej.							*)
	(* procedura nahodit ekwiwalentnye cepi i priswaiwaet im 	*)
	(* odinakowyj nomer.						*)
VAR
	PROTREE	:	PTRTREE;
BEGIN
	IF (CURRTREE^.TREEFLAG = NEXTTREE^.TREEFLAG)
	OR (CURRTREE^.TREEFLAG = FLAGDUMB)
	OR (NEXTTREE^.TREEFLAG = FLAGDUMB)
	THEN	BEGIN
		IF NEXTTREE^.TREEFLAG = FLAGDUMB
		THEN	BEGIN
			PROTREE:= NEXTTREE;
			NEXTTREE:= CURRTREE;
			CURRTREE:= PROTREE;
		END;
		IF CURRTREE^.TREENUMB <> NEXTTREE^.TREENUMB
		THEN	BEGIN
			PROTREE:=ROOTTREE;
			WHILE PROTREE <> NIL DO
			BEGIN
				IF PROTREE^.TREENUMB = CURRTREE^.TREENUMB
				THEN
					IF PROTREE <> CURRTREE
					THEN	BEGIN
						PROTREE^.TREENUMB:=NEXTTREE^.TREENUMB;
						PROTREE^.TREEFLAG:=NEXTTREE^.TREEFLAG;
					END;
				PROTREE:=PROTREE^.TREENEXT;
			END;
			CURRTREE^.TREENUMB:=NEXTTREE^.TREENUMB;
			CURRTREE^.TREEFLAG:=NEXTTREE^.TREEFLAG;
		END;
	END
	ELSE	ERROR(23);
END;

PROCEDURE NEWTREE(VAR	CURRTREE	:	PTRTREE;
		        FLAG		:	TYPETREE);
	(* procedura NEWTREE rezerwiruet mesto w pamqti dlq nowoj cepi	*)
	(* i zanosit ee, a takve wydaet na etu cepx ssylku.		*)
BEGIN
	NEW(CURRTREE);
	CURRTREE^.TREENEXT:=ROOTTREE;
	ROOTTREE:=CURRTREE;
	NUMBTREE:=NUMBTREE +1;
	CURRTREE^.TREENUMB:=NUMBTREE;
	CURRTREE^.TREEFLAG:=FLAG;
END;

PROCEDURE SETTREEMARKER(VAR CURRTREE	:	PTRTREE;
			CURRNAMEMARKER	:	TYMARKER);
	(*    procedura SETTREEMARKER priswaiwaet cepi imq markera;	*)
	(*  osu{estwlqet prowerku zanesen marker w spisok ili net.	*)
	(*  esli markera w spiske net, to otwodit mesto w pamqti pod	*)
	(*  etot marker i wydaet na nego ssylku. w slu~ae esli na cepx	*)
	(*  ssyla`tsq dwa markera, to wydaetsq soob{enie ob o{ibke.	*)
VAR
	CURRMARKER : PTRMARKER ;
BEGIN
	CURRMARKER:=ROOTMARKER;
	WHILE (CURRMARKER#NIL) AND (CURRMARKER^.MARKERNEXT#NIL)
		AND (CURRNAMEMARKER#CURRMARKER^.MARKERNAME) DO
	BEGIN
		IF ( CURRTREE <> NIL) AND
		 ( CURRTREE^.TREENUMB =CURRMARKER^.MARKERTREE^.TREENUMB)
		THEN
			ERROR(19);
		CURRMARKER:=CURRMARKER^.MARKERNEXT;
	END;
	IF (CURRMARKER=NIL) OR (CURRNAMEMARKER#CURRMARKER^.MARKERNAME)
	THEN	BEGIN
		CURRMARKER:=ROOTMARKER;
		NEW(ROOTMARKER);
		ROOTMARKER^.MARKERNEXT:=CURRMARKER;
		CURRMARKER:=ROOTMARKER;
		CURRMARKER^.MARKERNAME:=CURRNAMEMARKER;
		ROOTMARKER:=CURRMARKER;
		IF CURRTREE=NIL
		THEN	BEGIN
			NEWTREE(CURRMARKER^.MARKERTREE,FLAGTREE);
			CURRTREE:=CURRMARKER^.MARKERTREE;
		END
		ELSE	CURRMARKER^.MARKERTREE:=CURRTREE;
	END
	ELSE	IF CURRTREE=NIL
		THEN	CURRTREE:=CURRMARKER^.MARKERTREE
		ELSE	TREEEQ(CURRTREE,CURRMARKER^.MARKERTREE);
END;

PROCEDURE SETTREEPUANT(VAR CURRTREE	:	PTRTREE);
	(*  procedura SETTREEPUANT priswaiwaet cepi nomer puanty.	*)
	(*  procedura s~itywaet imq markera i w slu~ae esli imq ne	*)
	(*  sodervit simwolow ili prewoshodit dlinu markera, wydaetsq	*)
	(* soob{enie ob o{ibke.						*)
VAR
	NUMBPUANT : INTEGER;
	NEXTTREE  : PTRTREE;
	PROTREE   : PTRTREE;
	CURRLONGMARKER	:	INTEGER;
	CURRNAMEMARKER	:	TYMARKER;
BEGIN
	IF SYMBOL='('
	THEN	BEGIN
		READSYMBOL;
       		IF SYMBOL=')'
		THEN	ERROR (8)
		ELSE	BEGIN
			FOR CURRLONGMARKER:=1 TO LONGMARKER DO
			CURRNAMEMARKER [ CURRLONGMARKER ] := ' ' ;
			CURRLONGMARKER:=0;		
			REPEAT
				CURRLONGMARKER:=CURRLONGMARKER+1;
				CURRNAMEMARKER [CURRLONGMARKER]:=SYMBOL;
				READSYMBOL;
			UNTIL	(SYMBOL=')') OR (CURRLONGMARKER=LONGMARKER);
			IF (CURRLONGMARKER=LONGMARKER) AND
			NOT (SYMBOL=')')
			THEN	ERROR (9)
			ELSE	SETTREEMARKER(CURRTREE,CURRNAMEMARKER);	
		END;
	END
	ELSE	CASE SYMBOL OF
		'A','B','C','D','E','F','G','H','K','L','M','N','R','S','T','U','X':BEGIN
			NEXTTREE:=NIL;
			NUMBPUANT:=MASPUANT [SYMBOL];
			CASE NUMBPUANT OF
			1,2,3,4 :BEGIN
					READSEGMTREE(XVAR-1,YVAR,13-NUMBPUANT,NEXTTREE);
					IF NEXTTREE=NIL
					THEN	ERROR (12);
				END;
			5,6,7,8 :BEGIN
					READSEGMTREE(XVAR,YVAR-1,21-NUMBPUANT,NEXTTREE);
					IF NEXTTREE=NIL
					THEN	ERROR (12);
				END;
			9,10,11,12,13,14,15,16 :IF	(XVAR=XX) AND (NUMBPUANT<13)
				     OR	(YVAR=YY) AND (NUMBPUANT>12)
					THEN	ERROR (12)
					ELSE
						IF CURRTREE=NIL
						THEN	NEWTREE(NEXTTREE,FLAGDUMB)
						ELSE	NEXTTREE:=CURRTREE;
			17 :	BEGIN
					READSEGMTREE (XVAR,YVAR,NUMBPUANT,NEXTTREE);
					IF NEXTTREE=NIL
					THEN	IF CURRTREE = NIL
						THEN	NEWTREE(NEXTTREE,FLAGTREE)
						ELSE	NEXTTREE:=CURRTREE;
				END;
			END;	
			IF NUMBPUANT < 17
			THEN	BEGIN
				READSEGMTREE (XVAR,YVAR,NUMBPUANT,PROTREE);
				IF PROTREE=NIL
				THEN	BEGIN
					IF NEXTTREE=NIL
					THEN
					ELSE	IF CURRTREE=NIL
						THEN	CURRTREE:=NEXTTREE
						ELSE	TREEEQ(NEXTTREE,CURRTREE);
					WRITESEGMTREE(XVAR,YVAR,NUMBPUANT,CURRTREE);
				END
				ELSE	ERROR(13);
			END
			ELSE	BEGIN
				IF CURRTREE = NIL
				THEN	CURRTREE:=NEXTTREE
				ELSE	TREEEQ(NEXTTREE,CURRTREE);
				IF CURRTREE^.TREEFLAG <> FLAGTREE
				THEN	SETTREETYPE(CURRTREE,FLAGTREE);
			     	WRITESEGMTREE(XVAR,YVAR,NUMBPUANT,CURRTREE);
			END;
		END;
		ELSE	ERROR(11)
	END;
END;
									
PROCEDURE SETELEMTREE(CURRELEM	:	PTRELEM;
		       CURRNUMBPINS:    TYPINS);
	(*  procedura SETELEMTREE priswaiwaet kontaktam elementa nomer	*)
	(*  cepi. 							*)
VAR
	CURRLONGMARKER	:	INTEGER;
	CURRNAMEMARKER	:	TYMARKER;
	CURRTREE	:	PTRTREE;


PROCEDURE SETTREEPINS(CURRELEM	:	PTRELEM;
		      CURRTREE	:	PTRTREE;
		      CURRNUMBPINS:	TYPINS);
	(*  procedura SETTREEPINS priswaiwaet kontaktu nomer cepi.	*)
	(*  procedura osu{estwlqet prowerku zanesen kontakt w spisok	*)
	(*  ili net. esli kontakta w spiske net, to procedura rezerwi-	*)
	(*  ruet mesto w pamqti dlq nowogo kontakta i wydaet ssylku na	*)
	(*  etot kontakt. w slu~ae esli etot kontakt uve zadejstwowan,	*)
	(*  to wydaetsq soob{enie ob o{ibke.				*)
VAR
	CURRPINS	:	PTRPINS;
BEGIN
	CURRPINS:=CURRELEM^.ELEMPINS;
	WHILE (CURRPINS#NIL) AND (CURRPINS^.PINSNEXT#NIL)
		AND (CURRPINS^.PINSNUMB#CURRNUMBPINS) DO
	CURRPINS:=CURRPINS^.PINSNEXT;
	IF (CURRPINS=NIL) OR (CURRNUMBPINS#CURRPINS^.PINSNUMB)
	THEN	BEGIN
		IF CURRPINS=NIL
		THEN	BEGIN
			NEW(CURRPINS);
			CURRELEM^.ELEMPINS:=CURRPINS;
		END
		ELSE	BEGIN
			NEW(CURRPINS^.PINSNEXT);
			CURRPINS:=CURRPINS^.PINSNEXT;
		END;
		IF CURRTREE^.TREEFLAG =FLAGJGUT
		THEN	ERROR(25)
		ELSE	BEGIN
			SETTREETYPE(CURRTREE,FLAGTREE);
			CURRPINS^.PINSNEXT:=NIL;
			CURRPINS^.PINSTREE:=CURRTREE;
			CURRPINS^.PINSNUMB:=CURRNUMBPINS;
		END;
	END
	ELSE	ERROR(17);
END;


BEGIN
	IF SYMBOL='('
	THEN	BEGIN
		READSYMBOL;
       		IF SYMBOL=')'
		THEN	ERROR (8)
		ELSE	BEGIN
			FOR CURRLONGMARKER:=1 TO LONGMARKER DO
			CURRNAMEMARKER [ CURRLONGMARKER ] := ' ' ;
			CURRLONGMARKER:=0;		
			REPEAT
				CURRLONGMARKER:=CURRLONGMARKER+1;
				CURRNAMEMARKER [CURRLONGMARKER]:=SYMBOL;
				READSYMBOL;
			UNTIL	(SYMBOL=')') OR (CURRLONGMARKER=LONGMARKER);
			IF (CURRLONGMARKER=LONGMARKER) AND
			NOT (SYMBOL=')')
			THEN	ERROR (9)
			ELSE	BEGIN
				CURRTREE:=NIL;
				SETTREEMARKER(CURRTREE,CURRNAMEMARKER);
				SETTREEPINS(CURRELEM,CURRTREE,CURRNUMBPINS);
			END;
		END;
	END
	ELSE	CASE SYMBOL OF
		'A','B','C','D','E','F','G','H','K','L','M','N','R','S','T','U','X':BEGIN
				CURRTREE:=NIL;
				SETTREEPUANT(CURRTREE);
				SETTREEPINS(CURRELEM,CURRTREE,CURRNUMBPINS);
			END;
		ELSE	ERROR (11)
		END;
END;


PROCEDURE READELEM;

	(*  procedura READELEM prednazna~ena dlq s~itywaniq obozna~eniq	*)
	(*  elementa. procedura wydaet sledu`{ee obozna~enie elementa	*)
	(*  iz whodnogo potoka, Osu{estwlqet prowerku zanesen element w *)
	(*  spisok ili net. esli elementa w spiske net, to procedura	*)
	(*  rezerwiruet mesto w pamqti dlq zaneseniq etogo elementa i 	*)
	(*  wydaet na nego ssylku.					*)
VAR
	I	:		INTEGER;
	CURRLONGNAME:	    0..LONGNAME;
	CURRELEMNAME:		TYNAME;
	CURRNUMBPINS:		TYPINS;
	CURRELEM	:	PTRELEM;
BEGIN
	FOR I := 1 TO LONGNAME DO
		CURRELEMNAME [ I ] := ' ' ;
	READSYMBOL;
	IF SYMBOL='/'
	THEN	ERROR ( 2 ) 
	ELSE	BEGIN
		CURRLONGNAME := 0 ;
		REPEAT
		      CURRLONGNAME := CURRLONGNAME + 1 ;
		      CURRELEMNAME [CURRLONGNAME] :=SYMBOL ;
		      READSYMBOL ;
		UNTIL (SYMBOL = '/') OR (CURRLONGNAME > LONGNAME ) ;
		IF (CURRLONGNAME > LONGNAME) AND NOT (SYMBOL='/')
		THEN	ERROR ( 3 )	
		ELSE	BEGIN
			CURRELEM:=ROOTELEM;
			WHILE (CURRELEM#NIL) AND (CURRELEM^.ELEMNEXT#NIL)
			      AND (CURRELEM^.ELEMNAME#CURRELEMNAME) DO
			CURRELEM:=CURRELEM^.ELEMNEXT;
			IF (CURRELEM=NIL) OR (CURRELEMNAME#CURRELEM^.ELEMNAME)
			THEN	BEGIN
				IF CURRELEM=NIL
				THEN	BEGIN
					NEW(CURRELEM);
					ROOTELEM:=CURRELEM;
				END
				ELSE	BEGIN
					NEW(CURRELEM^.ELEMNEXT);
					CURRELEM:=CURRELEM^.ELEMNEXT;
				END;
				CURRELEM^.ELEMNEXT:=NIL;
				CURRELEM^.ELEMPINS:=NIL;
				CURRELEM^.ELEMNAME:=CURRELEMNAME;
			END;
			READSYMBOL;
			CASE SYMBOL OF
				'A','B','C','D','E','F','G','H','K','L','M','N',
				'R','S','T','U','X','(','+' :BEGIN
						CURRNUMBPINS := 0;
						REPEAT
							CURRNUMBPINS := CURRNUMBPINS + 1 ;
							IF SYMBOL#'+'
							THEN	SETELEMTREE(CURRELEM,CURRNUMBPINS);
							READSYMBOL;
						UNTIL   (SYMBOL='*') OR
	 					        (SYMBOL=',') OR
						        (SYMBOL=';');
				END;
				'1','2','3','4','5','6','7','8','9','0':BEGIN
						REPEAT
							CURRNUMBPINS := 0;
							WHILE (ORD(SYMBOL)>=ORD('0'))
							 AND
							(ORD(SYMBOL)<=ORD('9')) DO
			 				BEGIN
								CURRNUMBPINS:=CURRNUMBPINS*10+
								ORD(SYMBOL)-ORD('0');
								READSYMBOL;
							END;
							SETELEMTREE(CURRELEM,CURRNUMBPINS);
							READSYMBOL;
						UNTIL   (SYMBOL='*') OR
							(SYMBOL=',') OR
							(SYMBOL=';');
					END;
				ELSE	ERROR (11)
			END;
		END;
	END;
END;

PROCEDURE SETTREEJGUT(  CURRTREE	:	PTRTREE;
			CURRNUMBJGUT	:	INTEGER;
		    VAR	NEXTTREE	:	PTRTREE);
	(*  procedura SETTREEJGUT priswaiwaet cepi zna~enie JGUT.	*)
	(*  procedura osu{estwlqet prowerku zanesen vgut w spisok ili	*)
	(*  net. esli vgut w spisok ne byl zanesen, to procedura rezer-	*)
	(*  wiruet mesto w pamqti pod etot vgut i wydaet na nego ssylku.*)
VAR
	CURRJGUT : PTRJGUT ;
BEGIN
	CURRJGUT:=ROOTJGUT;
	WHILE (CURRJGUT#NIL) AND (CURRJGUT^.JGUTNEXT#NIL)
		AND (CURRNUMBJGUT#CURRJGUT^.JGUTNUMB)
		AND (CURRTREE^.TREENUMB#CURRJGUT^.JGUTJGUT^.TREENUMB) DO
	CURRJGUT:=CURRJGUT^.JGUTNEXT;
	IF (CURRJGUT=NIL) OR (CURRNUMBJGUT#CURRJGUT^.JGUTNUMB)
	   OR	(CURRTREE^.TREENUMB # CURRJGUT^.JGUTJGUT^.TREENUMB)
	THEN	BEGIN
		CURRJGUT:=ROOTJGUT;
		NEW(ROOTJGUT);
		ROOTJGUT^.JGUTNEXT:=CURRJGUT;
		CURRJGUT:=ROOTJGUT;
		CURRJGUT^.JGUTNUMB:=CURRNUMBJGUT;
		CURRJGUT^.JGUTJGUT:=CURRTREE;
		NEWTREE(NEXTTREE,FLAGTREE);
		CURRJGUT^.JGUTTREE:=NEXTTREE;
	END
	ELSE	NEXTTREE:=CURRJGUT^.JGUTTREE;
END;

PROCEDURE READTREE;
	(*  procedura READTREE s~itywaet cepx i opredelqet ee tip	*)
VAR
	CURRTREE	:	PTRTREE;
	NEXTTREE	:	PTRTREE;
	I		:	INTEGER;
	CURRNUMBJGUT	:	INTEGER;
BEGIN
	CURRTREE:=NIL;
	REPEAT
		SETTREEPUANT(CURRTREE);
		READSYMBOL;
		IF (SYMBOL >= '0') AND (SYMBOL <= '9')
		THEN	BEGIN
			SETTREETYPE(CURRTREE,FLAGJGUT);
			REPEAT
				CURRNUMBJGUT :=0;
				REPEAT
					CURRNUMBJGUT:=CURRNUMBJGUT*10 +
							ORD(SYMBOL) - ORD('0');
					READSYMBOL;
				UNTIL	NOT ((SYMBOL>='0') AND (SYMBOL<='9'));
				NEXTTREE:=NIL;
				SETTREEJGUT(CURRTREE,CURRNUMBJGUT,NEXTTREE);
				SETTREEPUANT(NEXTTREE);
				READSYMBOL;
			UNTIL	( SYMBOL ='*' )
				OR ( SYMBOL =';' )
			     	OR ( SYMBOL =',' );
		END;
	UNTIL	( SYMBOL ='*' )
	     OR ( SYMBOL =';' )
	     OR ( SYMBOL =',' );
END;

PROCEDURE TESTSEGM;
	(*  procedura TESTSEGM osu{estwlqet prowerku swqznosti cepej s	*)
	(*  predydu{imi q~ejkami.					*)
VAR
	CURRTREE	:	PTRTREE;
	NEXTTREE	:	PTRTREE;
	I		:	INTEGER;

BEGIN
	IF XVAR <> 1
	THEN	BEGIN
		FOR I:=1 TO 4 DO
		BEGIN
			READSEGMTREE (XVAR-1,YVAR,13-I,CURRTREE);
			IF CURRTREE <> NIL
			THEN	BEGIN
				READSEGMTREE (XVAR,YVAR,I,NEXTTREE);
				IF NEXTTREE = NIL
				THEN	BEGIN
					ERROR(22);
					WRITELN(OUT,' *KODR22S X=',XVAR,' Y=',YVAR,'  NUMBPUANT=',I);
				END;
			END;
		END;
	END;
	IF YVAR <> 1
	THEN	BEGIN
		FOR I:= 5 TO 8 DO
		BEGIN
			READSEGMTREE (XVAR,YVAR-1,21-I,CURRTREE);
			IF CURRTREE = NIL
			THEN	BEGIN
				READSEGMTREE (XVAR,YVAR,I,NEXTTREE);
				IF NEXTTREE <> NIL
				THEN	BEGIN
					ERROR(22);
					WRITELN(OUT,' *KODR22S X=',XVAR,' Y=',YVAR,' NUMBPUANT=',I);
				END;
			END;
		END;
	END;
END;

PROCEDURE CLEARSEGM;
	(*  procedura CLEARSEGM podgotawliwaet modelx kodirowo~nogo	*)
	(*  blanka pri perehode na nowu` stroku.			*)	
VAR
	I		:	INTEGER;
	XVAR		:	INTEGER;
	CURRSEGM	:	PTRSEGM;
BEGIN
	CURRSEGM:=LOWERSEGM;
	LOWERSEGM:=UPPERSEGM;
	UPPERSEGM:=CURRSEGM;
	FOR XVAR:=1 TO XX DO
	BEGIN
		FOR I:=1 TO 17 DO
			CURRSEGM^.SEGMTREE[I]:=NIL;
		CURRSEGM:=CURRSEGM^.SEGMRIGHT;
	END;
END;

PROCEDURE INIZDATE;
	(*  procedura INIZDATE osu{estwlqet iniciaci` wnutrennih struktur*)
	(*  dannyh programmy, a takve otkrywaet whodnye i wyhodnye fajly.*)
VAR
	I	:	INTEGER	;
	CURRSEGM:	PTRSEGM ;
	NAMEOUT	: ARRAY [1..20] OF CHAR ;
	NAMESHEF: ARRAY [1..20] OF CHAR ;
	NAMEINFILE:ARRAY[1..20] OF CHAR ;
BEGIN

	WRITE(' **KODR wwedite imq fajla s opisaniem shemy :');
	READLN(NAMEINFILE);
	RESET(INFILE,NAMEINFILE);

	WRITE(' **KODR wwedite imq fajla soob{enij programmy :');
	READLN(NAMEOUT);
	REWRITE(OUT,NAMEOUT);

	WRITE(' **KODR wwedite imq wyhodnogo fajla :');
	READLN(NAMESHEF);
	REWRITE(SHEF,NAMESHEF);
						
	READLN(INFILE,XX,YY);

	WRITELN(OUT,' XX=',XX,' YY=',YY);
					(*	rezerwiruem mesto pod	*)
					(*	 ukazatelx na perwu` 	*)
					(*	stroku kodirowo~nogo	*)
					(*	blanka			*)
	NEW(UPPERSEGM);
	CURRSEGM:=UPPERSEGM;
	FOR I:=1 TO 17 DO
	CURRSEGM^.SEGMTREE [I]:=NIL;
	FOR XVAR:=2 TO XX DO
	BEGIN
		NEW(CURRSEGM^.SEGMRIGHT);
		CURRSEGM:=CURRSEGM^.SEGMRIGHT;
		FOR I:=1 TO 17 DO
			CURRSEGM^.SEGMTREE[I]:=NIL;

	END;
	CURRSEGM^.SEGMRIGHT:=NIL;

	NEW(LOWERSEGM);
	CURRSEGM:=LOWERSEGM;
	FOR I:=1 TO 17 DO
	CURRSEGM^.SEGMTREE [I]:=NIL;
	FOR XVAR:=2 TO XX DO
	BEGIN
		NEW(CURRSEGM^.SEGMRIGHT);
		CURRSEGM:=CURRSEGM^.SEGMRIGHT;
		FOR I:=1 TO 17 DO
			CURRSEGM^.SEGMTREE[I]:=NIL;

	END;
	CURRSEGM^.SEGMRIGHT:=NIL;

	XVAR:=1;
	YVAR:=1;
	FOR I:=1 TO MAXNUMBERERROR DO
	ERR [I]:= 0;
	NUMBTREE:=0;
	COUNTERROR:=0;
	POSITION:=1;
	LONGSTRING:=0;
	ROOTELEM:=NIL;
	ROOTJGUT:=NIL;
	ROOTMARKER:=NIL;
	ROOTTREE:=NIL;
	MASPUANT ['A'] := 1;
	MASPUANT ['B'] := 2;
	MASPUANT ['C'] := 3;
	MASPUANT ['D'] := 4;
	MASPUANT ['E'] := 5;
	MASPUANT ['F'] := 6;
	MASPUANT ['G'] := 7;
	MASPUANT ['H'] := 8;
	MASPUANT ['K'] := 9;
	MASPUANT ['L'] :=10;
	MASPUANT ['M'] :=11;
	MASPUANT ['N'] :=12;
	MASPUANT ['R'] :=13;
	MASPUANT ['S'] :=14;
	MASPUANT ['T'] :=15;
	MASPUANT ['U'] :=16;
	MASPUANT ['X'] :=17;
END;

PROCEDURE GROSS;
	(*  procedura GROSS osu{estwlqet sintaksi~eskij i semanti~eskij	*)
	(*  razbor zakodirowannogo opisaniq shemy elektri~eskoj 	*)
	(*  principialxnoj.						*)
BEGIN
	READSYMBOL;
	REPEAT
		CASE SYMBOL OF 
		'/' : 	READELEM;
		'*' :	BEGIN
				TESTSEGM;
				READSYMBOL;
				IF XVAR<XX
			THEN	XVAR:=XVAR+1
			ELSE	IF (XVAR=XX) AND (SYMBOL=';')
				THEN
				ELSE	ERROR (14);
		END;
		';' :	BEGIN
				IF YVAR<=YY
				THEN	BEGIN
					WRITELN(OUT , 'stroka ', YVAR+1);
					IF YVAR < YY
						THEN	READSYMBOL;
					IF XVAR<XX
					THEN	ERROR (16);
					YVAR:=YVAR+1;
					XVAR:=1;
					CLEARSEGM;
					
				END;
			END;
		',' :	READSYMBOL;
		'A','B','C','D','E','F','G','H','K','L','M','N','R','S','T','U','X','(' :READTREE;
		ELSE	ERROR(11)
		END;
	UNTIL  YVAR > YY;
END;



PROCEDURE PUTTREE;
	(*  procedura PUTTREE pe~ataet spisok cepej i podkl`~ennye k 	*)
	(* nim kontakty elementow.					*)		
VAR
	CURRTREE	:	PTRTREE;
	CURRMARKER	:	PTRMARKER;
	CURRELEM	:	PTRELEM;
	CURRPINS	:	PTRPINS;
	II		:	INTEGER;
	I		:	INTEGER;
BEGIN
	FOR I:=1 TO NUMBTREE DO
	BEGIN
		CURRTREE:=ROOTTREE;
		WHILE (CURRTREE <> NIL) AND (CURRTREE^.TREENUMB <> I) DO
			CURRTREE:=CURRTREE^.TREENEXT;
		IF CURRTREE <> NIL
		THEN	BEGIN
			CASE CURRTREE^.TREEFLAG OF
				FLAGTREE  :	WRITELN(SHEF,'TREE');
				FLAGJGUT  :	WRITELN(SHEF,'JGUT');
				FLAGDUMB  :	WRITELN(SHEF,'DUMB');
				ELSE WRITELN(SHEF,'ERROR')
			END;
			WRITE(SHEF,I:3);
			CURRMARKER:=ROOTMARKER;
			WHILE (CURRMARKER <> NIL) AND (CURRMARKER^.MARKERTREE^.TREENUMB <> I) DO
				CURRMARKER:=CURRMARKER^.MARKERNEXT;
			IF CURRMARKER <> NIL
			THEN	WRITE(SHEF,'  ',CURRMARKER^.MARKERNAME:LONGMARKER)
			ELSE    WRITE(SHEF,' ':LONGMARKER+2);
			CURRELEM:=ROOTELEM;
			II:=0;
			WHILE CURRELEM <> NIL DO
			BEGIN
				CURRPINS:=CURRELEM^.ELEMPINS;
				WHILE CURRPINS <> NIL DO
				BEGIN
					IF (CURRPINS^.PINSTREE =NIL)
					THEN	WRITELN('TREE NIL')
					ELSE IF (CURRPINS^.PINSTREE^.TREENUMB = I)
					THEN	BEGIN
						WRITE(SHEF,CURRELEM^.ELEMNAME:LONGNAME,
							':',CURRPINS^.PINSNUMB:3,'      ');
						II:=II+1;
						IF II MOD 4 = 0
						THEN	BEGIN
							WRITELN(SHEF);
							WRITE(SHEF,' ':2+3+LONGMARKER);
						END;
					END;
					CURRPINS:=CURRPINS^.PINSNEXT;
				END;
				CURRELEM:=CURRELEM^.ELEMNEXT;
			END;
			WRITELN(SHEF);
			IF II <=1
			THEN	BEGIN
				IF II=0
				THEN	WRITELN(SHEF,' *KODR26S  cepx nigde ne zadejstwowana ')
				ELSE	WRITELN(SHEF,' *KODR26S  cepx podkl`~ena tolxko k odnomu kontaktu');
				ERR[26]:=ERR[26] + 1;
			END;
		END;
	END;
END;

PROCEDURE STAT;
	(*	procedura STAT prednazna~ena dlq polu~eniq statisti-	*)
	(*	~eskoj informacii o sheme elektri~eskoj principialxnoj	*)

PROCEDURE TREE;
	(*	procedura TREE osu{estwlqet pods~et koli~estwa cepej,	*)
	(* 	vgutow i neizwestnyh po nazna~eni` cepej, kotorye 	*)
	(*	wstretilisx wo wremq wypolneniq programmy.		*)
VAR 
	COUNTTREE:  	INTEGER;
	COUNTJGUT:	INTEGER;
	COUNTDUMB:	INTEGER;
	CURRTREE:	PTRTREE;
BEGIN
	WRITELN( OUT );
	CURRTREE:=ROOTTREE;
	COUNTTREE:=0;
	COUNTJGUT:=0;
	COUNTDUMB:=0;
	WHILE CURRTREE <> NIL DO
	BEGIN
		CASE CURRTREE^.TREEFLAG OF
		FLAGTREE  :  COUNTTREE:=COUNTTREE+1;
		FLAGJGUT  :  COUNTJGUT:=COUNTJGUT+1;
		FLAGDUMB  :  COUNTDUMB:=COUNTDUMB+1;
		ELSE
		END;
		CURRTREE:=CURRTREE^.TREENEXT;
	END;
	WRITELN(OUT);
	WRITELN(OUT,' *KODR90I summarnoe koli~estwo cepej rawno ',COUNTTREE:7);
	WRITELN(OUT,' *KODR91I summarnoe koli~estwo vgutow rawno',COUNTJGUT:7);
	WRITELN(OUT,' *KODR92I summarnoe koli~estwo neizwestnyh cepej rawno',COUNTDUMB:7);
END;

PROCEDURE ELEM;
	(*	procedura ELEM osu{estwlqet pods~et elementow i kontak- *)
	(*	tow elementa.						*)
VAR
	CURRELEM:	PTRELEM;
	CURRPINS:	PTRPINS;
	COUNTELEM:	INTEGER;
	COUNTPINS:	INTEGER;
BEGIN
	CURRELEM:=ROOTELEM;
	COUNTELEM:=0;
	COUNTPINS:=0;
	WHILE CURRELEM#NIL DO
	BEGIN
		CURRPINS:=CURRELEM^.ELEMPINS;
		WHILE CURRPINS#NIL DO
		BEGIN
			IF CURRPINS^.PINSTREE#NIL
			THEN
			COUNTPINS:=COUNTPINS+1;
			CURRPINS:=CURRPINS^.PINSNEXT;
		END;
		COUNTELEM:=COUNTELEM+1;
		CURRELEM:=CURRELEM^.ELEMNEXT;
	END;
	WRITELN(OUT);
	WRITELN(OUT,' *KODR93I summarnoe koli~estwo elementow rawno',COUNTELEM:7);
	WRITELN(OUT,' *KODR94I summarnoe koli~estwo kontaktow rawno',COUNTPINS:7);
END;

PROCEDURE MARKER;
	(*	procedura MARKER osu{estwlqet pods~et markerow,		*)
	(* 	wstretiw{ihsq wo wremq wypolneniq programmy.		*)
VAR
	CURRMARKER:	PTRMARKER;
	COUNTMARKER:	INTEGER;
BEGIN
	CURRMARKER:=ROOTMARKER;
	COUNTMARKER:=0;
	WHILE CURRMARKER#NIL DO
	BEGIN
		COUNTMARKER:=COUNTMARKER+1;
		CURRMARKER:=CURRMARKER^.MARKERNEXT;
	END;
	WRITELN(OUT,' *KODR95I summarnoe koli~estwo markerow rawno', COUNTMARKER : 7);
END;

BEGIN
	TREE;
	ELEM;
	MARKER;
END;

PROCEDURE PUTELEMTREE;
	(*  procedura PUTELEMTREE pe~ataet element i podkl`~enie 	*)
	(*  kontaktow elementa k cepqm.					*)
VAR
	CURRELEM	:	PTRELEM;
	CURRPINS	:	PTRPINS;
BEGIN
	CURRELEM:=ROOTELEM;
	WHILE CURRELEM#NIL DO
	BEGIN
		WRITELN(OUT,' element   ' ,CURRELEM^.ELEMNAME);
		CURRPINS:=CURRELEM^.ELEMPINS;
		WHILE CURRPINS#NIL DO
		BEGIN
			WRITE(OUT ,' kontakt   ', CURRPINS^.PINSNUMB:4);
			IF CURRPINS^.PINSTREE#NIL
			THEN	WRITELN(OUT,' cepx  ',CURRPINS^.PINSTREE^.TREENUMB)
			ELSE	WRITELN(OUT,' cepx NIL  ');
			CURRPINS:=CURRPINS^.PINSNEXT;
		END;
		WRITELN(OUT);
		CURRELEM:=CURRELEM^.ELEMNEXT;
	END;
END;


PROCEDURE PUTMARKER;
	(*  procedura PUTMARKER pe~ataet imq markera, podkl`~ennogo k	*)
	(*  cepi.							*)
VAR
	CURRMARKER	:	PTRMARKER;
BEGIN
	CURRMARKER:=ROOTMARKER;
	WHILE CURRMARKER # NIL DO
	BEGIN
		WRITELN(OUT,' marker >',CURRMARKER^.MARKERNAME,
		CURRMARKER^.MARKERTREE^.TREENUMB);
		CURRMARKER:=CURRMARKER^.MARKERNEXT;
	END;
END;

PROCEDURE ERRORMESSAGE;
	(*  procedura ERRORMESSAGE klassificiruet wstre~ennye o{ibki	*)
	(*  i wydaet soob{eniq o wseh zame~ennyh o{ibkah kodirowo~nogo	*)
	(*  blanka.							*)
 VAR
	I            :      INTEGER;
	COUNTERERROR :      INTEGER;      
 BEGIN
	WRITELN (OUT);
	WRITELN (OUT);
	COUNTERERROR := 0;
	FOR I := 1 TO MAXNUMBERERROR DO
	IF ERR [ I ] = 0 
	THEN
	ELSE	BEGIN
		CASE I OF
		1 :BEGIN
		     	WRITELN (OUT,' *KODR01S dOCTigHuT fizi~ECKij KOHEc dAHHyX');
		     	WRITELN (OUT, ' PAHx{E lOgi~ECKOgO KOHcA dAHHyX');
		     	WRITE (OUT,' *KODR01I pPOBEPxTE KOdiPOBO~Hyj blAHK ; ');
	     	END;
		2 :	WRITELN (OUT,' *KODR02S ObOzHA~EHiE HE COdEPviT CiMBOlOB  : ');
		3: 	BEGIN
	     			WRITE (OUT,' *KODR03S ObOzHA~EHiE pPEBy{AET MAKCiMAlxHu` dliHu ');
			     	WRITE (OUT,LONGNAME:4)
		END;
		4 :	WRITE (OUT,' *KODR04M zABEP{HiE PAbOTy                    ; ');
		6 :	WRITE (OUT,' *KODR06S CpiCOK cEpEj q~EK HE CfOPMiPOBAH   ; ');
		7 :	WRITE (OUT,' *KODR07S HEpPABilxHO zAdAHy KOOPdiHATy q~ejKi  ; ');
		8 :	WRITE (OUT,' *KODR08S iMq MAPKEPA HE COdEPviT CiMBOlOB     ; ');
		9 :	WRITE (OUT,' *KODR09S dliHA MAPKEPA pPEBy{ET             :', LONGNAME:4);
		10 :	WRITE (OUT,' *KODR10S HOMEP KOHTAKTA pPEBy{ET                :',MAXNUMBPINS:4);
		11 :	WRITE (OUT,' *KODR11S HEdOpuCTiMyj CiMBOl                   ; ');
		12 :	WRITE (OUT,' *KODR12S ObPyB cEpi                           ; ');
		13 :	WRITE (OUT,' *KODR13S puAHTA uvE zAdEjCTBOBAHA B q~EjKE    ; ');
		14 :	WRITE (OUT,' *KODR14S KOli~EsTBO q~EEK pO X pPEBy{AET XX      :',XX:4);
		15 :	WRITE (OUT,' *KODR15S KOli~ECTBO CTPOK blAHKA bOlx{E  YY      :',YY:4);
		16 :	WRITE (OUT,' *KODR16S KOli~EsTBO q~EEK pO X MEHx{E    XX      :',XX:4);
		17 :	WRITE (OUT,' *KODR17S kontakt elementa uve zadejstwowan ');
		18 :	WRITE (OUT,' *KODR18S o~enx mnogo o{ibok');
		19 :	WRITE (OUT,' *KODR19S na cepx ssyla`tsq dwa markera');
		20 :	WRITE (OUT,' *KODR20S cepx sodervit menx{e dwuh kontaktow ');
		22 :	WRITE (OUT,' *KODR22S obryw cepi pri prowerke na swqznostx s predidu{imi q~ejkami ');
		23 :	WRITE (OUT,' *KODR23S cepx soedinqetsq s vgutom ');
		25 :	WRITE (OUT,' *KODR25S kontakt podkl`~aetsq k vgutu ');
		ELSE	WRITE(OUT,' *KODR98W o{ibka ne opisana N=',I)
	     	END; 
	     	WRITELN (OUT,ERR[I]);
	     	COUNTERERROR:=COUNTERERROR+ERR[I];
	END;
	IF COUNTERERROR > 0
	THEN	WRITELN (OUT,' *KODR99M CuMMAPHOE KOli~ECTBO O{ibOK PABHO ',COUNTERERROR:7);
END;

BEGIN
	WRITELN(' *KODR00I ***** CTAPT zAdAHiq ***** ' );
	INIZDATE;
    	GROSS; 
99  :   ERRORMESSAGE;
    	PUTELEMTREE;   
	PUTMARKER;
	STAT;
	CLOSE(OUT);
	PUTTREE;
	CLOSE(SHEF);
	WRITELN(' *KODR99I ***** zABEP{EHiE zAdAHiq **** ' ); 
END.
