#include <stdio.h>
#include <wderr.h>

#define LAT	017	/* Latin alphabet used */
#define NAT	016	/* National alphabet used */

#define	ESC	033	/* Define Escape char */

#define NORMAL	0	/* Normal state of automata */
#define JUSTES	1	/* Escape just typed */
#define YCOORD	2	/* Y-Coordinate after ESC Y */
#define XCOORD	3	/* X-Coordinate after ESC Y (Y + 040 ) */

typedef int void;

typedef int boolean;

typedef struct _w_ {
   int
      x,	/* Window's start X */
      y,	/* Window's start Y */
      w,	/* Window's width */
      h,	/* Window's height */
      cx,	/* Window's cursor X */
      cy,	/* Window's cursor Y */
      sx,	/* Window's saved X */
      sy,	/* Window's saved Y */
      cs,	/* Window's current state */
      cr,	/* Window's current FontSet */
      st,	/* Window overlap other windows */
      bl;	/* Window was blocked by other windows */
   char
     *sv;	/* Pointer to underlying saved area */
} window;

static int $w_bittab[ 16 ] = {
   0000001, 0000002, 0000004, 0000010, 0000020, 0000040, 0000400, 0000200,
   0000400, 0001000, 0002000, 0004000, 0010000, 0020000, 0040000, 0100000
};

static char $w_save[ 80 ][ 24 ];

static window BASE = {
   0, 0, 79, 24, 0, 0, 0, 0, NORMAL, LAT, 0, 0, &$w_save
};

static window *$w_WDT[ 16 ] = {
   &BASE, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};

static int $W_Ptr = 0;

static window *$w_cur = &BASE, *$w_last = &BASE;

 /**********************************************************************\
 *                                                                      *
 * VOID                                                                 *
 *    W_INIT( )                                                         *
 *    Initialize window system if called in first time.                 *
 * Else reset to initial state                                          *
 *                                                                      *
 \**********************************************************************/

void w_init( ) {
   register char *r; register int i;

   r = &$w_save[ 0 ][ 0 ];
   for( i = 0; i < 1920; i++ )
      *r++ = ' ';
   for( $W_Ptr = 1; $W_Ptr < 16; $W_Ptr++ )
      if( $w_cur = $w_WDT[ $W_Ptr ] )
         $w_dstr( );
   $W_Ptr = 0; $w_cur = $w_last = &BASE; erase( ); 
}

 /**********************************************************************\
 *                                                                      *
 * INT                                                                  *
 *    W_CREATE( X, Y, W, H ) int X, Y, W, H;                            *
 *    Creates a window with width W and height H with                   *
 * coordinates of left-up corner in ( X, Y ). Returns a window          *
 * number or error code ( always negative                               *
 * Errors codes are:                                                    *
 *                                                                      *
 *   TMW - Too many windows. There are already 16 active                *
 *         windows in system.                                           *
 *   IWD - Illegal window dimensions. This window does not fit          *
 *         in present screen frame.                                     *
 *                                                                      *
 \**********************************************************************/

int w_create( x, y, w, h ) int x, y, w, h; {
   register window *wd; register char *r; register int i;

   if( $W_Ptr == 15 )
      return( TMW );
   if( w < 3 || h < 3 || x < 0 || y < 0 || ( x + w ) > 79 || ( y + h ) > 24 )
      return( IWD );
   wd = ( window * )$w_getmem( sizeof( window ) );
   wd->x = x; wd->y = y; wd->w = w; wd->h = h;
   r = ( char * )$w_getmem( w * h ); wd->sv = r;
   $w_cur = $w_last = $w_WDT[ ++$W_Ptr ] = wd;
   wd->cr = LAT; wd->bl = 0; wd->cs = NORMAL;
   for( i = 0; i < $W_Ptr; i++ )
      if( $w_upon( wd, $w_WDT[ i ] ) ) {
         $w_WDT[ i ]->bl |= $w_bittab[ $W_Ptr ]; wd->st |= $w_bittab[ i ];
      }
   $w_copy( ); $w_draw( ); return( $W_Ptr );
}

 /**********************************************************************\
 *                                                                      *
 * INT                                                                  *
 *    W_SET( W ) int W;                                                 *
 *    Switch window system to window W; save parameters of              *
 * old window. Make sure that window W not blocked by other             *
 * window                                                               *
 *                                                                      *
 \**********************************************************************/

int w_set( w ) int w; {
   register window *wd;

   if( w < 0 || w > $W_Ptr )
      return( IWN );
   $w_cur = wd = $w_WDT[ w ];
   if( wd->bl )
      return( WWB );
   outb( wd->cr ); outc( wd->x + wd->cx, wd->y + wd->cy ); return( w );
}

 /**********************************************************************\
 *                                                                      *
 * INT                                                                  *
 *    W_DELETE( )                                                       *
 *    Delete current window from screen. Restore all characters         *
 * under.                                                               *
 * Return:                                                              *
 *    Value >= 0 - Succes, Value is next window descriptor              *
 *    Value <  0 - on error.                                            *
 * Errors codes are:                                                    *
 *   WNL - Window not last.                                             *
 *   WWB - Window was blocked by other window(s).                       *
 *                                                                      *
 \**********************************************************************/

int w_delete( ) {
   register window *wd, *wd2; register int i;

   if( ( wd = $w_cur ) == &BASE )
      return( NSW );
   if( wd->bl )
      return( WWB );
   if( wd != $w_last )
      return( WNL );
   if( wd->st )
      for( i = 0; i < $W_Ptr; i++ )
         if( wd->st & $w_bittab[ i ] ) {
            wd2 = $w_WDT[ i ]; wd2->bl &= ~$w_bittab[ $W_Ptr ];
         }
   $w_ypoc( ); $w_dstr( ); wd = $w_cur = $w_last = $w_WDT[ --$W_Ptr ];
   outb( wd->cr ); outc( wd->x + wd->cx, wd->y + wd->cy ); return( $W_Ptr );
}

 /**********************************************************************\
 *                                                                      *
 * VOID                                                                 *
 *    W_REL( X, Y ) int *X, *Y;                                         *
 *    Returns relative coordinates of cursor position within            *
 *    current window.                                                   *
 *                                                                      *
 \**********************************************************************/

void w_rel( x, y ) int *x, *y; {
   register window *wd;

   wd = $w_cur; *x = wd->cx; *y = wd->cy;
}

 /**********************************************************************\
 *                                                                      *
 * VOID                                                                 *
 *    W_ABS( X, Y ) int *X, *Y;                                         *
 *    Returns absolute coordinates of cursor position within            *
 *    current window.                                                   *
 *                                                                      *
 \**********************************************************************/

void w_abs( x, y ) int *x, *y; {
   register window *wd;

   wd = $w_cur; *x = wd->x + wd->cx; *y = wd->y + wd->cy;
}

/*
 * INT
 *    W_READ( X, Y, LINE, LEN ) int X, Y, LEN; char *LINE;
 *    Copy contents of current window from ( X, Y ) with
 * length LEN into user's buffer. Insert NULL at the end of
 * string.
 *
 */

int w_gets( x, y, line, len ) int len, x, y; register char *line; {
   register window *wd; register int i;

   wd = $w_cur;
   if( ( x >= wd->w ) || ( y >= wd->h ) )
      return( IPX );
   if( x + len >= wd->w )
      len = wd->w - x - 1;
   for( i = x; i < x + len; i++ )
      *line++ = $w_save[ wd->x + i ][ wd->y + y ] & 0177;
   *line = '\000';
   return( len );
}

/*
 * VOID
 *    W_GETS( X, Y, LINE, LEN ) int X, Y, LEN; char *LINE;
 *    Copy contents of current window from ( X, Y ) with
 * length LEN into user's buffer. Insert NULL at the end of
 * string.
 *
 */

void w_read( x, y, line ) int x, y; register char *line; {
   register int len;

   if( ( len = w_gets( x, y, line, 80 ) ) < 0 )
      return( len );
   while( line[ --len ] == 040 );
   line[ ++len ] = '\000';
   return( 0 );
}

int w_getc( x, y ) int x, y; {
   register window *wd;

   wd = $w_cur;
   if( ( x >= wd->w ) || ( y >= wd->h ) )
      return( IPX );
   return( $w_save[ wd->x + x ][ wd->y + y ] & 0177 );
}

int w_getr( x, y ) int x, y; {
   register window *wd;

   wd = $w_cur;
   if( ( x >= wd->w ) || ( y >= wd->h ) )
      return( IPX );
   return( ( $w_save[ wd->x + x ][ wd->y + y ] & 0200 ) ? NAT : LAT );
}

int w_printf( argl ) void argl; {
   register char *hold, *ptr, c;

   hold = ptr = ( char * )$w_getmem( 256 ); sprintf( ptr, "%r", &argl );
   while( ( c = *ptr++ ) )
      $w_outc( c );
   $w_free( hold );
}

int w_putc( c ) int c; {

   $w_outc( c );
}

void $w_outc( c ) register int c; {
   register window *wd;

   wd = $w_cur;
   switch( wd->cs ) {
      case NORMAL:
         if( c == ESC )
            wd->cs = JUSTES;
         else
            $w_pri( c );
         break;
      case JUSTES:
         if( c == 'Y' )
            wd->cs = YCOORD;
         else {
            $w_esc( c ); wd->cs = NORMAL;
         }
         break;
      case YCOORD:
         wd->sy = c; wd->cs = XCOORD;
         break;
      case XCOORD:
         wd->sx = c; wd->cs = NORMAL; $w_pos( );
         break;
  }
}

$w_pri( c ) register int c; {
   register window *wd;

   wd = $w_cur;
   c &= 0177;
   switch( c ) {
      case 007:
         outb( 007 );
         break;
      case 015:
         $w_cr( );
         break;
      case 012:
         $w_cr( );
         if( wd->cy != ( wd->h - 2 ) ) {
            wd->cy++; outb( ESC ); outb( 'B' );
         } else
            $w_uscr( );
         break;
      case 010:
         $w_esc( 'D' );
         break;
      case LAT:
         wd->cr = LAT; outb( LAT );
         break;
      case NAT:
         wd->cr = NAT; outb( NAT );
         break;
      default:
         if( c >= ' ' ) {
            if( wd->cr == NAT )
               c |= 0200;
            $w_save[ wd->x + wd->cx++ ][ wd->y + wd->cy ] = c; outb( c );
            if( wd->cx == ( wd->w - 1 ) ) {
               outb( 010 ); wd->cx--;
            }
         }
   }
}

$w_pos( ) {
   register window *wd;

   wd = $w_cur; wd->sy -= 32; wd->sx -= 32;
   if( wd->sy < 1 )
      wd->cy = 1;
   else
      if( wd->sy > wd->h - 2 )
         wd->cy = wd->h - 2;
      else
         wd->cy = wd->sy;
   if( wd->sx < 1 )
      wd->cx = 1;
   else
      if( wd->sx > wd->w - 2 )
         wd->cx = wd->w - 2;
      else
         wd->cx = wd->sx;
   outc( wd->x + wd->cx, wd->y + wd->cy );
}

$w_esc( c ) int c; {
   register window *wd; register int i, j;

   wd = $w_cur;
   switch( c ) {
      case 'I': case 'A':
         if( wd->cy != 1 ) {
            wd->cy--; outb( ESC ); outb( 'A' );
         } else
            if( c == 'I' )
               $w_dscr( );
         break;
      case 'B':
         if( wd->cy != ( wd->h - 2 ) ) {
            wd->cy++; outb( ESC ); outb( 'B' );
         }
         break;
      case 'C':
         if( wd->cx != ( wd->w - 2 ) ) {
            wd->cx++; outb( ESC ); outb( 'C' );
         }
         break;
      case 'D':
         if( wd->cx != 1 ) {
            wd->cx--; outb( ESC ); outb( 'D' );
         }
         break;
      case 'K':
         outc( wd->x + wd->cx, wd->y + wd->cy );
         for( i = wd->cx; i < ( wd->w - 1 ); i++ ) {
            outb( ' ' ); $w_save[ wd->x + i ][ wd->y + wd->cy ] = ' ';
         }
         outc( wd->x + wd->cx, wd->y + wd->cy );
         break;
      case 'J':
         i = wd->cx; j = wd->cy;
         for( ; wd->cy < ( wd->h - 1 ); wd->cy++ ) {
            $w_esc( 'K' ); $w_cr( );
         }
         wd->cx = i; wd->cy = j; outc( wd->x + wd->cx, wd->y + wd->cy );
         break;
      case 'H':
         wd->cx = wd->cy = 1; outc( wd->x + wd->cx, wd->y + wd->cy );
         break;
      default:
         break;
   }
}

$w_uscr( ) {
   register window *wd; register int x, y; int ix, iy, reg; register char c;

   wd = $w_cur; ix = wd->cx; iy = wd->cy; reg = LAT;
   if( wd->h > 3 )
      for( y = wd->y + 1; y < ( wd->y + wd->h - 2 ); y++ ) {
         outc( wd->x + 1, y );
         for( x = wd->x + 1; x < ( wd->x + wd->w - 1 ); x++ ) {
            $w_save[ x ][ y ] = c = $w_save[ x ][ y + 1 ];
            if( c & 0200 ) {
               if( reg == LAT ) {
                  outb( NAT ); reg = NAT;
               }
            } else {
               if( reg == NAT ) {
                  outb( LAT ); reg = LAT;
               }
            }
            outb( c );
         }
      }
   wd->cx = 1; wd->cy = wd->h - 2; $w_esc( 'K' );
   wd->cx = ix; wd->cy = iy; outc( wd->x + wd->cx, wd->y + wd->cy );
}

$w_dscr( ) {
   register window *wd; register int x, y; int ix, iy, reg; register char c;

   wd = $w_cur; ix = wd->cx; iy = wd->cy; reg = LAT;
   if( wd->h > 3 )
      for( y = wd->y + 2; y < ( wd->y + wd->h - 1 ); y++ ) {
         outc( wd->x + 1, y );
         for( x = wd->x + 1; x < ( wd->x + wd->w - 1 ); x++ ) {
            $w_save[ x ][ y ] = c = $w_save[ x ][ y - 1 ];
            if( c & 0200 ) {
               if( reg == LAT ) {
                  outb( NAT ); reg = NAT;
               }
            } else {
               if( reg == NAT ) {
                  outb( LAT ); reg = LAT;
               }
            }
            outb( c );
         }
      }
   wd->cx = 1; wd->cy = 1; $w_esc( 'K' );
   wd->cx = ix; wd->cy = iy; outc( wd->x + wd->cx, wd->y + wd->cy );
}

$w_cr( ) {
   register window *wd;

   wd = $w_cur; wd->cx = 1; outc( wd->x + wd->cx, wd->y + wd->cy );
}

w_dca( x, y ) int x, y; {
   w_printf( "\033Y%c%c", y + 32, x + 32 );
}

static char dca_seq[ ] = { '\033', '\131', '\040', '\040', '\000' };

outc( x, y ) { 
   dca_seq[ 3 ] = ( x + 32 ); dca_seq[ 2 ] = ( y + 32 ); out( dca_seq );
}

outdca( x, y, string ) int x, y; char *string; {
   outc( x, y ); out( string );
}

erase( ) {
   out( "\033H\033J\033J" );
}

home( ) {
   out( "\033H" );
}

$w_getmem( size ) int size; {
   register int ptr;

   if( ( ptr = malloc( size ) ) == NULL ) {
      erase( ); printf( "\017Dynamic memory exhausted. Program failed\n" );
      exit( );
   }
   return( ptr );
}

void $w_free( ptr ) {
   free( ptr );
}

void $w_dstr( ) {
   register window *wd;

   wd = $w_cur; $w_free( wd->sv ); $w_free( wd ); $w_WDT[ $W_Ptr ] = NULL;
}

boolean $w_upon( new, old ) register window *new, *old; {
   if(    ( new->x >= ( old->x + old->w ) ) ||
          ( new->y >= ( old->y + old->h ) ) ||
          ( old->x >= ( new->x + new->w ) ) ||
          ( old->y >= ( new->y + new->h ) )
     )
      return( TRUE );
   else
      return( FALSE );
}

void $w_copy( ) {
   register window *wd; register char *r; int x, y;

   wd = $w_cur; r = wd->sv;
   for( y = wd->y; y < ( wd->y + wd->h ); y++ )
      for( x = wd->x; x < ( wd->x + wd->w ); x++ )
         *r++ = $w_save[ x ][ y ];
}

void $w_ypoc( ) {
   register window *wd; register char c, *r; int x, y, reg;

   reg = LAT; wd = $w_cur; r = wd->sv; outb( LAT );
   for( y = wd->y; y < ( wd->y + wd->h ); y++ ) {
      outc( wd->x, y );
      for( x = wd->x; x < ( wd->x + wd->w ); x++ ) {
         c = *r++; $w_save[ x ][ y ] = c;
         if( c & 0200 ) {
            if( reg == LAT ) {
               outb( NAT ); reg = NAT;
            }
         } else {
            if( reg == NAT ) {
               outb( LAT ); reg = LAT;
            }
         }
         outb( c );
      }
   }
}

void $w_draw( ) {
   register window *wd; register int x, y; int i, j; char c;

   wd = $w_cur; x = wd->x; y = wd->y; outb( LAT );
   for( j = y; j < ( y + wd->h ); j++ ) {
      outc( x, j );
      $w_save[ x ][ j ] = '|'; outb( '|' );
      for( i = x + 1; i < ( x + wd->w - 1); i++ ) {
         if( j == y )
            c = '~';
         else if( j == ( y + wd->h - 1 ) )
            c = '_';
         else
            c = ' ';
         $w_save[ i ][ j ] = c; outb( c );
      }
      $w_save[ x + wd->w - 1 ][ j ] = '|'; outb( '|' );
   }
   wd->cx = wd->cy = 1; outc( x + 1, y + 1 );
}
                                                                                                                                                                                                                                                                                                                                                                