#include	<StdIO.H>
#include	"LexAn.H"

FILE	*infile;
FILE	*oufile;
char inpp[ 80 ], inp[ 80 ];

char ibuf[ 256 ], obuf[ 256 ];

int $$narg = 1;

extern	float getfpt( );
extern	long  getlong( );
	FILE *diafile;
extern	int   Type;
extern	union MER Value;

#include	"memory.c"
#include	"scaner.c"
#include	"execut.c"
#include	"syntax.c"

exact( m, t ) char *m, *t; {
   while( *m == *t++ ) {
      if( *m++ == NULL )
         return( TRUE );
   }
   return( FALSE );
}

occur( m, t ) char *m, *t; {
   for( ;; ) {
      if( *m == *t ) {
         if( subst( m, t ) )
            return( TRUE );
         if( *m++ == NULL )
            return( FALSE );
      }
   }
}
         
subst( m, t ) char *m, *t; {
   if( *m == *t ) {
      while( *m++ == *t++ )
         if( *m == NULL ) return( TRUE );
      if( *--t == NULL )
         return( TRUE );
   }
   return( FALSE );
}

int	t_count;
int	_L[ PR_MAX ], _R[ PR_MAX ], _T[ PR_MAX ];
char	*_H[ PR_MAX ];

h_parse( ) { register FILE *TEMP;
   TEMP = diafile;
   if( ( diafile = fopen( "sy:title.dsc", "r" ) ) == NULL )
      synerr( "Cannot open SY:TITLE.DSC" );
   t_count = 0;
   while( TRUE ) {
      do_tit( ); getlex( );
      if( Type == EOF )
         break;
      unlex( );
   }
   fclose( diafile ); diafile = TEMP;
}

do_tit( ) { register int c;
   getlex( );
   if( Type != TIT )
      synerr( "Title expected." );
   if( Value.Vint - t_count++ != 1 )
      synerr( "Column numbers must be properly ordered" );
   getlex( );
   if( Type != MOV )
      synerr( "= expected." );
   getlex( );
   if( Type != OCU )
      synerr( "Column name expected." );
   _H[ t_count ] = Value.Vstring;
   getlex( );
   if( Type != COM )
      synerr( "Comma skipped." );
   getlex( );
   if( Type != PAR )
      synerr( "Left margin expected" );
   _L[ t_count ] = ( int )Value.Vfloat;
   getlex( );
   if( Type != COM )
      synerr( "Comma skipped." );
   getlex( );
   if( Type != PAR )
      synerr( "Right margin expected" );
   _R[ t_count ] = ( int )Value.Vfloat;
   getlex( );
   if( Type != COM )
      synerr( "Comma skipped." );
   c = skb( );
   switch( c ) {
      case 'F': case 'f':
         _P[ t_count ].T = FLT; _T[ t_count ] = FLT; break;
      case 'L': case 'l':
         _P[ t_count ].T = FLT; _T[ t_count ] = LNG; break;
      case 'D': case 'd':
         _P[ t_count ].T = DAT; _T[ t_count ] = DAT; break;
      case 'I': case 'i':
         _P[ t_count ].T = FLT; _T[ t_count ] = INT; break;
      case 'S': case 's':
         _P[ t_count ].T = STR; _T[ t_count ] = STR; break;
      case 'C': case 'c':
         _P[ t_count ].T = FLT; _T[ t_count ] = CHR; break;
      default:
         synerr( "Unrecognized requizit type." );
   }
   getlex( );
   if( Type != END )
      synerr( "Semicolon expected." );
}

synerr( s ) {
   fprintf( stderr, "?TPR-D-" ); fprintf( stderr, "%s\n", s );
}

main( ) {
   diafile = stdin;
   printf( "Enter input file name:\200" );
   gets( inpp );
   dofile( inp, inpp, "TXT" );
   if( ( infile = fopen( inp, "r" ) ) == NULL ) {
      ynerr( "Cannot open input file\n", 1 );
   }
   printf( "Enter output file name:\200" );
   gets( inpp );
   dofile( inp, inpp, "TXT" );
   if( ( oufile = fopen( inp, "w" ) ) == NULL ) {
      ynerr( "Cannot open ouput file\n", 1 );
   }
   h_parse( );
cyc:
   printf( "Enter command ( Print, Compute, Select ):\200" );
   gets( inpp );
   if( subst( "PRINT", inpp ) )
      print( );
   else if( subst( "COMPUTE", inpp ) )
      compute( );
   else if( subst( "SELECT", inpp ) )
      select( );
   else
      { printf( "Illegal command.\n" ); goto cyc; }
}

print( ) { register int i, j;
   j = 0; i = 1;
   pri_tit( ); j = 3;
   for( ;; ) {
      if( fgetss( ibuf, 255, infile ) == NULL ) {
         fprintf( oufile, "$\014\n" ); break;
      }
      if( ibuf[ 0 ] == '$' )
         continue;
      fprintf( oufile, "$ %-5d%s\n", i, ibuf );
      i++; j++;
      if( j == 65 ) {
         fprintf( oufile, "$\014\n" ); pri_tit( ); j = 3;
      }
   }
}

pri_tit( ) { register int i; register char *r;
   r = obuf;
   for( i = 0; i < _R[ t_count ]; i++ )
      *r++ = '-';
   *r = '\000';
   fprintf( oufile, "$------%s\n", obuf );
   r = obuf;
   for( i = 1; i < t_count + 1; i++ )
      r = mvt( r, i );
   *r = '\000';
   fprintf( oufile, "$ N    %s\n", obuf );
   r = obuf;
   for( i = 0; i < _R[ t_count ]; i++ )
      *r++ = '-';
   *r = '\000';
   fprintf( oufile, "$------%s\n", obuf );
}

mvt( z, h ) char *z; int h; { register int i, k, j; char *v;
   v = _H[ h ]; k = _R[ h ] - _L[ h ]; j = 1;
   for( i = 0; i < k; i++ ) {
      if( *v == '\000' )
         j = 0;
      if( j )
         *z++ = *v++;
      else
         *z++ = ' ';
   }
   *z++ = ' ';
   return( z );
}
   
PROGRAM sel;

select( ) { register int i;
   printf( "Enter Select options:\0200" );
   _logic( sel ); i = 1; Number = 1.; clmima( );
   for( ;; ) {
      if( fgetss( ibuf, 255, infile ) == NULL )
         break;
      if( ibuf[ 0 ] == '$' )
         continue;
      dpr( );
      if( _select( sel ) ) {
         i++; Number = ( float )i; domima( );
         back( );
      }
   }   
}

PROGRAM com;

compute( ) { register int i;
   printf( "Enter Select options:\0200" );
   syntax( com ); i = 1; Number = 1.; clmima( );
   for( ;; ) {
      if( fgetss( ibuf, 255, infile ) == NULL )
         break;
      if( ibuf[ 0 ] == '$' )
         continue;
      dpr( ); i++; Number = ( float )i; execut( com ); domima( ); back( );
   }   
}

clmima( )  { register int i;
   for( i = 1; i < t_count + 1; i++ ) {
      _MIN[ i ] = FLS; _MAX[ i ] = FLS; _SUM[ i ] = FLS; _AVE[ i ] = FLS;
   }
}

domima( ) { register int i;
   for( i = 1; i < t_count + 1; i++ ) {
      if( _P[ i ].T != FLT )
         continue;
      _SUM[ i ] += _P[ i ].Vfloat;
      _AVE[ i ] = _SUM[ i ] / Number;
      if( _P[ i ].Vfloat < _MIN[ i ] )
         _MIN[ i ] = _P[ i ].Vfloat;
      if( _P[ i ].Vfloat > _MAX[ i ] )
         _MAX[ i ] = _P[ i ].Vfloat;
   }
}

dofile( file, nam, ext ) char   *file, *nam, *ext; {
   name( file, nam, ext, 0 );
}

ynerr( st, mode ) char *st; int mode; {
   fprintf( stderr, "?TPR-F-" ); fprintf( stderr, "%s", st );
   if( mode > 0 ) {
      perror( "Error explanation " ); fprintf( stderr, "\n" );
   }
   exit( 4 );
}

name( fn, file, type, mode ) char *fn, *file, type; int   mode; {
                             register char *p1, *p2; register int c;
   p1 = fn; p2 = file; while( ( c = *p2++ ) && c != '.' ) *p1++ = c;
   if( mode == 0 ) {
      if( c == '.' ) {
         do {
            *p1++ = c;
         } while( c = *p2++ );
      } else {
         *p1++ = '.'; p2 = type; while( c = *p2++ ) *p1++ = c;
      }
   } else {
      *p1++ = '.'; p2 = type; while( c = *p2++ ) *p1++ = c;
   }
   *p1 = '\000';
}
                                                                                                                                              