PROGRAM	*CUR_PROG;

I_PUT( TYP, VAL ) int TYP; int VAL; { register ELEM *E;
   E = P_PUT( CUR_PROG ); E->T = TYP; E->V.I = VAL;
}

F_PUT( TYP, VAL ) int TYP; float VAL; { register ELEM *E;
   E = P_PUT( CUR_PROG ); E->T = TYP; E->V.F = VAL;
}

L_PUT( TYP, VAL ) int TYP; long VAL; { register ELEM *E;
   E = P_PUT( CUR_PROG ); E->T = TYP; E->V.L = VAL;
}

S_PUT( TYP, VAL ) int TYP; char *VAL; { register ELEM *E;
   E = P_PUT( CUR_PROG ); E->T = TYP; E->V.S = VAL;
}

SYNTAX( P ) PROGRAM *P; {
   P_FREE( P ); CUR_PROG = P;
   while( TRUE ) {
      STATE( ); GETLEX( );
      if( TYPE == EOF ) {
         I_PUT( EOF, NULL ); break;
      } else
         UNLEX( );
   }
}

LOGIC( P ) PROGRAM *P; {
   P_FREE( P ); CUR_PROG = P; EXPR( ); GETLEX( );
   if( TYPE == EOF || TYPE == END )
      I_PUT( EOF, NULL );
   else
      SYNERR( "Selecting program has illegal format" );
}

STATE( ) {
   GETLEX( );
   if( TYPE != REQ )
      SYNERR( "Requizit expected" );
   I_PUT( PAD, V.V ); GETLEX( );
   if( TYPE != MOV )
      SYNERR( "'=' expected." );
   EXPR( ); GETLEX( );
   if( TYPE != END )
      SYNERR( "Semicolon expected after statement." );
   I_PUT( MOV, NULL );
}

EXPR( ) {
   LOGICAL( ); GETLEX( );
   if( TYPE != THE ) {
      UNLEX( ); return;
   }
   EXPR( ); GETLEX( );
   if( TYPE != ELS )
      SYNERR( "Else clause expected." );
   EXPR( ); I_PUT( _IF, NULL );
}

LOGICAL( ) {
   LAND( ); GETLEX( );
   if( TYPE == LOR ) {
      LOGICAL( ); I_PUT( LOR, NULL );
   } else
      UNLEX( );
}

LAND( ) {
   LEQL( ); GETLEX( );
   if( TYPE == AND ) {
      LEQL( ); I_PUT( AND, NULL );
   } else
      UNLEX( );
}

LEQL( ) { int SAVEQL;
   RELAT( ); GETLEX( );
   if( TYPE == EQL ) {
      SAVEQL = V.I; RELAT( ); I_PUT( EQL, SAVEQL );
   } else
      UNLEX( );
}

RELAT( ) { int SAVREL;
   PRIMARY( ); GETLEX( );
   if( TYPE == REL ) {
      SAVREL = V.I; PRIMARY( ); I_PUT( REL, SAVREL );
   } else
      UNLEX( );
}

PRIMARY( ) { int SAVPRIM;
   TERM( ); GETLEX( );
   if( TYPE == ADD || TYPE == SUB ) {
      SAVPRIM = TYPE; TERM( ); I_PUT( SAVPRIM, NULL );
   } else
      UNLEX( );
}

TERM( ) { int SAVTERM;
   UNARY( ); GETLEX( );
   if( TYPE == FAC ) {
      SAVTERM = V.I; UNARY( ); I_PUT( FAC, SAVTERM );
   } else
      UNLEX( );
}

UNARY( ) { int SAVUNARY;
   GETLEX( );
   if( TYPE == NOT || TYPE == SUB ) {
      SAVUNARY = TYPE; FACTOR( );
      I_PUT( ( SAVUNARY == SUB ) ? UNA : NOT, NULL );
   }  else {
      UNLEX( ); FACTOR( );
   }
}

FACTOR( ) {
   GETLEX( );
   if( TYPE == LBR ) {
      EXPR( ); GETLEX( );
      if( TYPE != RBR )
         SYNERR( "Right brace expected." );
   } else {
      UNLEX( ); CONST( );
   }
}

CONST( ) {
   GETLEX( );
   if( TYPE == AVE || TYPE == MIN || TYPE == MAX ||
       TYPE == SUM || TYPE == NUM || TYPE == REQ )
      I_PUT( TYPE, V.I );
   else if( TYPE == PAR )
      F_PUT( TYPE, V.F );
   else if( TYPE == DAT )
      L_PUT( TYPE, V.L );
   else if( TYPE == EXA || TYPE == OCU )
      S_PUT( TYPE, V.S );
   else
      SYNERR( "Bad constant." );
}
                                                                                                                                                                                                                                                                                                                                                                                                                               