#include <stdio.h>

#define SNAP    0010000
#define SEGMENT 0020000
#define MACROS  0160000
#define EMPTY	0170000

#define TYPE_MASK  0007777
#define LAYER_MASK 0170377
#define TOOL_MASK  0177400

FILE	*brdfile;

int	block, word, asnap, asegm, mask, lay;

int	segm_a[ 256 ][ 16 ], snap_a[ 256 ][ 16 ], snaps[ 16 ], segms[ 16 ];

char	inp[ 80 ], out[ 80 ], buf[ 80 ];
char	*p;

char $$prom[ ] = "BRD:INFO>\200";

main( argc, argv ) char *argv[ ]; int argc; {
  register int tag, i, j;

  printf( "\016\n" );

  for( i = 0; i < 256; i++ )
    for( j = 0; j < 16; j++ ) {
      snap_a[ i ][ j ] = 0; segm_a[ i ][ j ] = 0;
    }

  for( j = 0; j < 16; j++ ) {
    snaps[ j ] = 0; segms[ j ] = 0;
  }

  mask = lay = block = word = asnap = asegm = 0;

  name( inp, argv[ 1 ], "BRD" );

  if( ( brdfile = fopen( inp, "rn" ) ) == NULL ) {
    name( inp, argv[ 1 ], "DRL" );
    if( ( brdfile = fopen( inp, "rn" ) ) == NULL )
      synerr( "o[IBKA OTKRYTIQ FAJLA\n", 1 );
  }

  while( TRUE ) {
    if( !( tag = getword( ) ) )
      break;
    switch( tag & ~TYPE_MASK ) {
      case EMPTY:
        break;
      case SNAP:
        getword( ); getword( );
        mask = tag & ~TOOL_MASK; lay = ( tag & ~LAYER_MASK ) >> 8;
        snap_a[ mask ][ lay ]++; snaps[ lay ]++; asnap++;
        break; 
      case SEGMENT:
        getword( ); getword( ); getword( ); getword( );
        mask = tag & ~TOOL_MASK; lay = ( tag & ~LAYER_MASK ) >> 8;
        segm_a[ mask ][ lay ]++; segms[ lay ]++; asegm++;
        break;
      default:
        printf( "bLOK: %3d, SLOWO %3d -- NEWERNYJ TIP \LEMENTA %o\n",
                block, word, tag );
    }
  }

  for( tag = 0; tag < 16; tag++ )
    if( segms[ tag ] ) {
      printf( "\nsLOJ %d, PROWODNIKOW %d\n", tag, segms[ tag ] );
      for( j = i = 0; i < 256; i++ )
        if( segm_a[ i ][ tag ] ) {
          if( j == 6 ) {
            printf( "\n" ); j = 0;
          }
          printf( "t%-3o - %-5d ", i, segm_a[ i ][ tag ] ); j++;
        }
    }

  for( tag = 0; tag < 16; tag++ )
    if( snaps[ tag ] ) {
      printf( "\nsLOJ %d, PE^ATNYH \\LEMENTOW %d\n", tag, snaps[ tag ] );
      for( j = i = 0; i < 256; i++ )
        if( snap_a[ i ][ tag ] ) {
          if( j == 6 ) {
            printf( "\n" ); j = 0;
          }
          printf( "t%-3o - %-5d ", i, snap_a[ i ][ tag ] ); j++;
        }
    }

  printf( "\n\nwSEGO PROWODNIKOW %d, PE^ATNYH \\LEMENTOW %d\n",
          asegm, asnap );

  printf( "\017" );

}

getword( ) {  register int i;

  i = getw( brdfile );
  if( ferror( brdfile ) == 1 )
    synerr( "o[IBKA WWODA/WYWODA W FAJLE\n", 1 );
  if( ++word > 256 ) {
    word = 0; block++;
  }
  return( i );
}

synerr( st, mode ) char *st; int mode; {
  fprintf( stderr, "?\017BRD:INFO-F-\016" ); fprintf( stderr, "%s", st );
  if( mode )
    perror( "o[IBKA\017 " );
  printf( "\017" ); exit( 4 );
}

name( fn, file, type ) char *fn, *file, *type; {
  register char *p1, *p2; register int c;

  p1 = fn; p2 = file;
  while( ( c = *p2++ ) && c != '.' )
    *p1++ = c;
  if( c == '.' ) {
    *p1++ = '.';
    while( *p1++ = *p2++ )
      ;
  } else {
    *p1++ = '.'; p2 = type;
    while( *p1++ = *p2++ )
      ;
  }
  *p1 = '\000';
}
                                                                                                                                                                                                                                                                      