float	FTR = 1.0;
float	FLS = 0.0;
float	_MIN[ PR_MAX ], _MAX[ PR_MAX ], _SUM[ PR_MAX ], _AVE[ PR_MAX ];
float	Number;
Datum	_P[ PR_MAX ];
Datum	Stack[ ST_MAX ];
int	Stack_ptr;

Clear( ) {
   Stack_ptr = 0;
}

push( d ) Datum	*d; { register Datum *r;
   if( Stack_ptr < ST_MAX ) {
      r = &Stack[ Stack_ptr++ ]; r->T = d->T; r->V.Vlong = d->V.Vlong;
   } else
      Synerr( "Executor's stack overflowed." );
}

pop( d ) Datum *d; { register Datum *r;
   if( --Stack_ptr >= 0 ) {
      r = &Stack[ Stack_ptr ]; d->T = r->T; d->V.Vlong = r->V.Vlong;
   } else
      Stack_ptr++; Synerr( "Executor's stack underflowed." ); 
}

Datum	rr, ll, oo;

_select( p ) { register Datum *l;
   l = &ll; execut( p ); pop( l );
   if( l->T == FLT )
      if( l->V.Vfloat != FLS )
         return( TRUE );
    return( FALSE );
}
   
Execute( p ) PROGRAM *p; { ELEM *e; register Datum *r, *l,*o;
   o = &oo; r = &rr; l = &ll;
   Clear( );
   while( e = p_get( p ) ) {
      switch( e->T ) {
         case REQ:
            push( &_P[ e->V.Vint ] ); break;
         case MIN:
            o->T = FLT; o->V.Vfloat = _MIN[ e->V.Vint ]; push( o );
            break;
         case MAX:
            o->T = FLT; o->V.Vfloat = _MAX[ e->V.Vint ]; push( o );
            break;
         case SUM:
            o->T = FLT; o->V.Vfloat = _SUM[ e->V.Vint ]; push( o );
            break;
         case AVE:
            o->T = FLT; o->V.Vfloat = _AVE[ e->V.Vint ]; push( o );
            break;
         case NUM:
            o->T = FLT; o->V.Vfloat = Number; push( o );
            break;
         case MOV:
            pop( r ); pop( l );
            if( l->T != PAD )
               synerr( "Requizit required" );
            o = &_P[ l->V.Vint ];
            o->T = r->T; o->V.Vlong = r->V.Vlong;
            break;
         case FAC:
            pop( r ); pop( l );
            if( l->T != FLT || r->T != FLT )
               intyp( );
            switch( e->V.Vint ) {
               case MUL:
                  o->V.Vfloat = l->V.Vfloat * r->V.Vfloat; break;
               case DIV:
                  o->V.Vfloat = l->V.Vfloat / r->V.Vfloat; break;
               case TRU:
                  /* o->V.Vfloat = l->V.Vfloat / r->V.Vfloat; break; */
                  o->V.Vfloat = FLS; break;
            }
            o->T = FLT; push( o ); break;
         case OCU: case EXA:
            push( e ); break;
         case _IF:
            pop( r ); pop( l ); pop( o );
            if( o->T != FLT )
               intyp( );
            if( o->V.Vfloat != FLS )
               push( l );
            else
               push( r );
            break;
         case EQL:
            pop( r ); pop( l );
            if( r->T == FLT && l->T == FLT ) {
               if( r->V.Vfloat == l->V.Vfloat )
                  o->V.Vfloat = ( e->V.Vint == EQU ) ? FTR : FLS;
               else
                  o->V.Vfloat = ( e->V.Vint == EQU ) ? FLS : FTR;
            } else if( r->T == DAT && l->T == DAT ) {
               if( r->V.Vlong == l->V.Vlong )
                  o->V.Vfloat = ( e->V.Vint == EQU ) ? FTR : FLS;
               else
                  o->V.Vfloat = ( e->V.Vint == EQU ) ? FLS : FTR;
            } else if( r->T == STR && ( l->T == EXA || l->T == OCU ) ) {
               if( ( ( l->T == EXA ) ? exact( r->V.Vstring, l->V.Vstring )
                                     : occur( r->V.Vstring, l->V.Vstring ) ) )
                  o->V.Vfloat = ( e->V.Vint == EQU ) ? FTR : FLS;
               else
                  o->V.Vfloat = ( e->V.Vint == EQU ) ? FLS : FTR;
            } else {
               intyp( ); o->V.Vfloat = FLS;
            } o->T = FLT; push( o );break;
         case DAT:
            push( e ); break;
         case ADD: case SUB:
            pop( r ); pop( l );
            if( l->T != FLT || r->T != FLT )
               intyp( );
            switch( e->V.Vint ) {
               case ADD:
                  o->V.Vfloat = l->V.Vfloat + r->V.Vfloat; break;
               case SUB:
                  o->V.Vfloat = l->V.Vfloat - r->V.Vfloat; break;
            }
            o->T = FLT; push( o ); break;
         case REL:
            pop( r ); pop( l );
            if( ( r->T == FLT || r->T == DAT ) && ( r->T == l->T ) ) {
               switch( e->V.Vint ) {
                  case GRE:
                     if( r->T == DAT )
                        if( l->V.Vlong > r->V.Vlong )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                     else
                        if( l->V.Vfloat > r->V.Vfloat )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                  break;
                  case GEQ:
                     if( r->T == DAT )
                        if( l->V.Vlong >= r->V.Vlong )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                     else
                        if( l->V.Vfloat >= r->V.Vfloat )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                  break;
                  case LES:
                     if( r->T == DAT )
                        if( l->V.Vlong < r->V.Vlong )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                     else
                        if( l->V.Vfloat < r->V.Vfloat )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                  break;
                  case LEQ:
                     if( r->T == DAT )
                        if( l->V.Vlong <= r->V.Vlong )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                     else
                        if( l->V.Vfloat <= r->V.Vfloat )
                           o->V.Vfloat = FTR;
                        else
                           o->V.Vfloat = FLS;
                  break;
               }
            } else {
               intyp( ); o->V.Vfloat = FLS;
            } o->T = FLT; break;
         case AND:
            pop( r ); pop( l );
            if( r->T != FLT || l->T != FLT )
               intyp( );
            if( r->V.Vfloat != FLS && l->V.Vfloat != FLS )
               o->V.Vfloat = FTR;
            else
               o->V.Vfloat = FLS;
            o->T = FLT; push( o ); break;
         case LOR:
            pop( r ); pop( l );
            if( r->T != FLT || l->T != FLT )
               intyp( );
            if( r->V.Vfloat != FLS || l->V.Vfloat != FLS )
               o->V.Vfloat = FTR;
            else
               o->V.Vfloat = FLS;
            o->T = FLT; push( o ); break;
         case NOT:
            pop( r );
            if( r->T != FLT )
               intyp( );
            if( r->V.Vfloat == FLS )
               r->V.Vfloat = FTR;
            else
               r->V.Vfloat = FLS;
            push( r ); break;
         case UNA:
            pop( o );
            if( o->T != FLT )
               intyp( );
            o->V.Vfloat = -o->V.Vfloat;
            push( o ); break;
         case PAR:
            o->T = FLT; o->V.Vfloat = e->V.Vfloat; push( o );
            break;
         case PAD:
            push( e ); break;
         default:
            Synerr( "____" );
      }
   }
}
intyp( ) {
   synerr( "Incompatible types duping program execution" );
}
                                                                                                                                                                                                                                                                                                                                                                                                 