#define	NPARS	256

int	nn[ NPARS + 2 ];
int	param[ 128 ][ 8 ];

int	c;

char	inp[ 80 ];

int	OFF;

int	CNT;

int	TABLE;

int	stream, count;

char	*from;

int	ESCCHAR = '%';

main( argc, argv ) char *argv[ ]; {

  name( inp, argv[ 1 ], "TXT", 0 );

  iniparam( ); stream = 0; TABLE = 0;

  OFF = TRUE;

  if( ( infile = fopen( "sy:init.eps", "r" ) ) != NULL ) {
    while( ( c = get( ) ) != EOF )
      if( c == ESCCHAR )
        escape( );
    fclose( infile );
  }
      
  if( ( infile = fopen( "dk:reprog.eps", "r" ) ) != NULL ) {
    while( ( c = get( ) ) != EOF )
      if( c == ESCCHAR )
        escape( );
    fclose( infile );
  }

  OFF = FALSE;

  if( ( infile = fopen( inp, "r" ) ) == NULL )
    synerr( "Cannot open input file\n", 1 );

  while( ( c = get( ) ) != EOF )
    if( c == ESCCHAR )
      { OFF = TRUE; escape( ); OFF = FALSE; }
    else
      out( c );
}

iniparam( ) { register int i, j;
  for( i = 0; i < 128; i++ )
    for( j = 0; i < 8; j++ )
      param[ i ][ j ] = 0;
}

reprog( ) { register int i, *o; register char *p;
  o = &param[ nn[ 1 ] & 0177 ][ TABLE ];
  if( nn[ 0 ] == 1 )
    synerr( "Reprogramming failed.", 0 );
  else
    if( nn[ 0 ] == 1 ) {
      if( *o ) {
        mfree( *o ); *o = NULL;
      }
    } else {
      if( nn[ 1 ] == ESCCHAR )
        synerr( "Cannot reprogramme ESCAPE character.", 0 );
      if( ( p = malloc( nn[ 0 ] ) ) == NULL )
        synerr( "Dynamic memory exhausted.", 0 );
      if( *o )
        mfree( *o );
      *o = p; *p++ = nn[ 0 ] - 1;
      for( i = 0; i < nn[ 0 ] - 1; i++ )
        *p++ = nn[ i + 2 ];
    }
}

get( ) { register int i;
  if( stream ) {
    if( --count == 0 )
      stream = 0;
    return( ( *from++ ) & 0377 );
  } else {
    if( ( c = getc( infile ) ) == EOF )
      return( EOF );
    if( param[ c ] == NULL || OFF )
      return( c );
    else {
      stream = 1; from = param[ c ]; count = ( *from++ ) & 0377;
      return( get( ) );
    }
  }
}

escape( ) {
   gc( );
   if( c == '(' ) {
      pars( ); gc( );
   }
   switch( c ) {
     case 'C':
       reprog( ); break;
     case 'O':
       if( nn[ 0 ] )
         for( i = 1; i < nn[ 0 ]; i++ )
           out( nn[ i ] );
       break;
     default:
       out( c );
   }
}

pars( ) { register int i;
   nn[ 0 ] = 0;
   for( i = 1; i < NPARS; i++ ) {
      gc( ); skb( );
      if( c == ')' && i == 1 )
         return;
      else
        if( c == '\'' ) {
          gc( ); nn[ i ] = c; gc( );
          if( c != '\'' )
            synerr( "Illegal literal in escape sequence.", 0 );
          gc( );
        } else
          if( c == '"' ) {
            for( ;; ) {
              gc( );
              if( c != '"' )
                nn[ i++ ] = c;
              else
                { i--; gc( ); break; }
            }
          } else
            nn[ i ] = getnum( );
      skb( );
      if( c == ')' ) {
         nn[ 0 ] = i; return;
      } else
         if( c == ',' )
            continue;
         else
            synerr( "Invalid data in escape sequence.", 0 );
   }
}

getnum( ) { register int i, flg;
  flg = 1; i = 0;
  if( c == '-' ) {
    flg = -1; gc( );
  } else
    if( c == '0' ) {
      gc( );
      if( c == 'X' || c == 'x' ) {
        gc( );
        for( ;; ) {
          if( c >= '0' && c <= '9' )
             i = ( i << 4 ) + ( c - '0' );
          else
            if( c >= 'A' && c <= 'F' )
              i = ( i << 4 ) + ( c - 'A' + 10 );
            else
              if( c >= 'a' && c <= 'f' )
                i = ( i << 4 ) + ( c - 'a' + 10 );
              else
                break;
          gc( );
        }                
      } else
        if( c == 'B' || c == 'b' ) {
          gc( );
          for( ;; ) {
            if( c == '0' || c == '1' )
              i = ( i << 1 ) + ( c - '0' );
            else
              break;
            gc( );
          }
        } else {
          for( ;; ) {
            if( c >= '0' && c <= '7' )
              i = ( i << 3 ) + ( c - '0' );
            else
              break;
            gc( );
          }
        }
  } else {
    for( ;; ) {
      if( c >= '0' && c <= '9' )
        i = ( i * 10 ) + ( c - '0' );
      else
        break;
      gc( );
    }
  }
  return( i * flg );
}

gc( ) {
  if( ( c = get( ) ) == EOF )
    synerr( "EOF during escape sequence.", 0 );
}

skb( ) {
  while( c == '\n' || c == ' ' || c == '\t' )
    gc( );
}

synerr( st, mode ) char *st; {
  fprintf( stderr, "?EPS-F-" ); fprintf( stderr, "%s", st );
  if( mode == 1 ) {
    perror( " Error explanation " ); fprintf( stderr, "\n" );
  } else
    if( mode == 2 )
      return;
  exit( 4 );
}
                                                                                                                                                                                                                                                                                     