char Sertif[] = "RTMBase V1.0; D.Lyahovitch, I.Horolenko;";
struct defdb {
   int  Opened;		/*  set if database <use> is opened */
   int  Fields;		/*  number of fields                */
   int  Records;	/*  number of records               */
   int  Length;		/*  length record of bytes          */
   int  Size;		/*  size database of records        */
   int  Virtual;
   int  SftBit;		/*  bitmap shift                    */
   int  SftIdx;		/*  index shift                     */
   char Script;		/*  security byte                   */
   int  DefIdx;
   int  PntBuf;
}
union unival {
  int    I;
  unsign U;
  long   L;
  real   R;
  char   C;
  char   *S;
}
struct val {
  char   Type;
  unival Val;
}
struct info {
  char Name[15];
  int  Numcol;
  char Type;
  int  Length;
  int  Shift;
}

DefDb dbFirst, dbSecond;

char checsum;







LineSum( line ) char *line; {
  char sum;
  
  for(sum = 0; *line; sum += line++ )
    ;
  return ( sum );
}

OpenDb( use, name, password) int use; char *name, *password; {
  union pa {
            char c[16];
            int  i[8];
           };
  pa l;
  int i, c;
  defdb *d;

                  /*   Opening data base define file   */
  d = use ? &FirstDb : &SecondDb;
  if( d->Opened )
    StatEr( >>, >> );
  checsum = LineSum( Sertif );
  Use( use );
  if ( IOpen( name ) )
    StatEr(stat, er);
  SetAddress( 8 );
  for( i = 0, c = 0; i < 8; i++) {
    l.i[i] = SeqGet();
    l.c[c++] ^= checsum;
    l.c[c++] ^= checsum;
  }
  if ( strcmp( l.c, password ))
    StatEr( >>, >> );
  d->Script  = LineSum( l.c );
  d->Fields  = ReadWord( 0 );
  d->Records = ReadWord( 1 );
  d->Size    = ReadWord( 2 );
  d->SftBit  = ReadWord( 3 );
  d->SftIdx  = ReadWord( 4 );
  d->Length  = ReadWord( 5 );
  d->Opened  = TRUE;
              /*     Opening  data base data file       */
  DOpen( name, d->Length );
}

CloseDB( use ) int use; {

  defdb *d;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  d->Opened  = FALSE;
  WriteWord( 0 ) = d->Fields;
  WriteWord( 1 ) = d->Records;
  WriteWord( 2 ) = d->Size;
  WriteWord( 3 ) = d->SftBit;
  WriteWord( 4 ) = d->SftIdx;
  Flash( );
}

InfoDB( use, fields, records, size ) int use, fields, records, size; {

  defdb *d;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  fields  = d->Fields;
  records = d->Records;
  size    = d->Size;
}

FldInfo( use, column, inform ) int use; column; info *inform; {

  struct fl{
    int  i[8];
    char c[16];
  }
  fl s;
  int i;
  defdb *d;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  if( column > d->Fields )
    StatEr( >>, >> );
  --column;
  SetAddress( 16 + column * 8 );
  for( i = 0; i < 8; i++)
    s.i[i] = SeqGet();
  strcpy( inform.Name, s );
  inform.Numcol = ++column;
  inform.Type   = s.c[11];
  inform.Length = s.i[7];
  inform.Shift  = s.i[6];
}


NamToCol( use, name, inform ) int use; char *name; info *inform; {

  int column;

  for( column = 1; column <= d->Fields; column++){
    FldInfo( use, column, inform );
    if( strcmp( name, inform.Name ) = 0 )
      break;
  }
  if( column > d->Fields )
    StatEr( >>, >> );
}


GoToRec( use, record ) int use, record; {

  defdb *d;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  d->Virtual = ReadWord( d->SftIdx + --record );
  d->PntBuf = DRead( d->Virtual );
}


GetValue( use, column, value ) int use, column; val *value; { 

  defdb *d;
  char *rec;
  info field;
  int i;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  rec = d->PntBuf;
  if( !( rec[column/8] &( 1 << ( column % 8 ) ) ) )
    return( 1 );
  FldInfo( use, column, &field );
  rec += field.Shift;
  if( ( value.Type = field.Type) == "S" )
    value.Val.S = rec;
  else
    for( i = 0; i < field.Length; i++ )
      value.Val.S[i] = *rec++;
  DMark();
  return( 0 );
}


PutValue( use, column, value ) int use, column; val *value; { 

  defdb *d;
  char *rec;
  info field;
  int i;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  rec = d->PntBuf;
  FldInfo( use, column, &field );
  rec[column/8] |= ( 1 << ( column % 8 ) );
  rec += field.Shift;
  if( ( value.Type = field.Type) == "S" )
    strncpy( rec, value.Val.S, field.Length );
  for( i = 0; i < field.Length; i++ )
    *rec++ = value.Val.S[i];
}

InsRec( use, record ) int use, record; (

  defdb *d;
  char *rec;
  int i, w;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  for( i = 0; i < d->Records; i++ ) {
    w = ReadWord( d->SftBit + i / 16 );
    if( !( w & ( 1 << ( i % 16  ) ) ) )
      break;
  }
  if( i >= d->Records )
    StatEr( ??, ?? );
  w |= ( 1 << ( i % 16 ) );
  WriteWord( d->SftBit + i / 16, w );
  d->Virtual = i;
  if( record > d->Records )
    record = d->Records;
  else {
    --record;
    for( i = d->SftIdx + d->Records, w = i - 1; w >= record; i--, w-- )
      WriteWord( i, ReadWord( w ) );
  }
  WriteWord( d->SftIdx + record, d->Virtual );
  d->PntBuf = DRead( d->Virtual );
  for( rec = d->PntBuf; rec < d->PntBuf + d->Length - 1; *rec++ = 0 )
    ;
  d->Records++;
  DMark( );
}

DelRec( use, record ) int use, record; {

  defdb *d;
  char *rec;
  int i, w;

  d = use ? &FirstDb : &SecondDb;
  Use( use );
  if( !d->Opened )
    StatEr( >>, >> );
  if( record > d->Records )
    StatEr( ??, ?? );
  d->Virtual = ReadWord( d->SftIdx + --record );
  w = ReadWord( d->SftBit + d->Virtual );
  w &= ~( 1 << ( d->Virtual % 16 ) );
  WriteWord( d->SftBit + d->Virtual, w );
  for( i = d->SftIdx + record, w = i + 1; i <= d->Records; i++, w++ );
    WriteWord( i, ReadWord( w ) );
  d->Records--;
  WriteWord( d->Records, 0 );
}
                                                                                                                 