#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>


        /* । ᮢ ॣ஢  */

#define OUT_REG        BASE      /* ।  */
#define IN_REG         BASE      /* ਥ  */
#define LOW_DIV        BASE      /*訩  ⥫*/
#define HIGH_DIV       BASE+1    /*訩  ⥫*/
#define INT_REG        BASE+1    /*᪠ ࠧ襭 뢠*/
#define INT_ID_REG     BASE+2    /*稭 뢠*/
#define CONTROL        BASE+3    /*ࠢ饥 ᫮ */
#define MODEM          BASE+4    /*㣨 ࠢ ᪨ ᨣ*/
#define STATUS         BASE+5    /*ﭨ */
#define M_STATUS       BASE+6    /*ﭨ ᪨ ᨣ*/

/*********। ᭮ ⠭ ************/
        /****** । B_?????   ******/
#define   B_110         1040
#define   B_150         768
#define   B_300         384
#define   B_600         192
#define   B_1200        96
#define   B_2400        48
#define   B_4800        24
#define   B_9600        12 /*  12, ࠢ    /*

/********᪨ ࠧ襭 뢠 **********/
#define   DATA_REC   0x01      /* ਭ                           */
#define   EMPTY_BUF  0x02      /* ।                       */
#define   ERROR      0x04      /*訡  ਥ                  */
#define   MODEM_INT  0x08      /* ﭨ ᪨ ᨣ*/

/*ࠢ騥 ⠭*/

#define   DIVISOR    0x80      /* ࠢ 㯮  ॣࠬ*/
#define   BIT_8      0x03      /* 뫪 8                 */
#define   BIT_7      0x02      /* 뫪 7                 */
#define   STOP_1     0x00      /*1 ⮯                      */
#define   STOP_2     0x04      /*2 ⮯                      */
#define   NOPARITY   0x00      /* ஫ ⭮              */
#define   DTR        0x01      /*ࠢ  DTR              */
#define   RTS        0x02      /*ࠢ  RTS              */

/*᪨ ⮢                                                 */
#define   DATA_IN    0x01      /* ਭ                     */
#define   OVERRUN    0x02      /*९                       */
#define   FRAME_ERR  0x08      /*訡 ଠ 뫪             */
#define   DATA_OUT   0x20      /*⮢  ।                   */

/*᪨ ﭨ ᪨ ᨣ                             */
#define   CTS   0x10      /*ﭨ  CTS (ਥ)          */
#define   DSR   0x20      /*ﭨ  DSR (।稪)        */

#define ESC 27
#define EOF (-1)

int BASE=0x3F8;     /* ()   ॣ஢ */
int speed=12;   /* ।  */
FILE *f1;


/*। 㭪権 */
void   init_port(void);
int    out_port(int symbol);
int in_port(int *symbol);

int error_code;

int main(int argc,char *argv[])

{
 char name[]="Noname00.ext";
 char ext[]=".ext";
 int i,j,leng,adr,byte;


/*  */
  if( argc==1 )
  { printf("\nணࠬ   0010 १ ᫥⥫ ");
    printf("\n ப:\n COP_BK %s /COM1 /9600 ",name);
    printf("\nࠬ  祬 /  易⥫,");
    printf("\n 㬮砭 /COM1 /9600\n");
    return(1);
  }
/***    ***/
  strcpy(name,argv[1]);
  i=0;
  while( name[i] != '.' && name[i] != '\0' ) i++;
  if( name[i] == '\0') strcpy(ext,"");
  else
  {
   j=0;
   while( ext[j++]=name[i++] );
  }



/***   ***/
  if( argc > 2 && argc < 5 )
  {
   i=2;
   do
   {
    if( argv[i][0] == '/')
    {
    if( stricmp( argv[i],"/COM1") == 0 ) BASE=0x3F8;
    else if( stricmp( argv[i],"/COM2") == 0 ) BASE=0x2F8;
    else
         {
           speed = 115200/atoi( &argv[i][1] );
           if( speed == 0 )
           {
             printf("\noe  ᪮ ");
             exit(1);
           }
         }
    }
    else
    {
     printf("\n ࠬ ");
     exit(1);
    }
   }
   while( ++i < argc );
  }

  else if( argc != 2 )
       {
        printf("\n譨 ࠬ ");   exit(1);
       }

/*****⨥ 䠩  ।******/

  f1 = fopen(name,"rb" );
  if ( f1 == 0 )
  {
    printf("\n   䠩 %s\n",name);
    return(3);
  }

  init_port();

/*****   ******/
  if ( stricmp(ext,".pbk") == 0 )
  {
    out_port( 0125 );
    printf("\n।  0125n");

    in_port( &byte );
    printf("\nਭ  %o\n",byte);

    if ( byte != 0125 )
    {
      printf("\n訡  ਥ-।\n" );fclose(f1); return(4);
    }

       /*  ।  㧪  䠩*/

       byte=fgetc(f1); out_port(byte);adr=byte;
       byte=fgetc(f1); out_port(byte);adr=adr+byte*256;

       /* ।   䠩 */

       byte=fgetc(f1); out_port(byte);leng=byte;
       byte=fgetc(f1); out_port(byte);leng=leng+byte*256;
  }
  else
  {
    i=0; j=0;
    while( (byte=fgetc(f1))  != EOF )
    {
      if( byte != 015 ) j++;
      i++;
    }

    fclose(f1);
    f1 = fopen(name,"rb" );
    if ( f1 == 0 )
    {
      printf("\n   䠩 %s\n",name);
      return(3);
    }
    if ( stricmp(ext,".tbk") == 0 ) leng=j;
    else leng=i;
    adr=0;

    /*  ।  0 㧪   䠩 */

    out_port(0); out_port(0);

    /* ।    䠩 */

    byte=0377 & leng ; out_port(byte);
    byte=(0177400 & leng) >> 8; out_port(byte);
  }

  printf("। 䠩 %s  =%o =%d\n",name,adr,leng);

  if ( stricmp(ext,".tbk") != 0 )
  {
    /*  ।  ⥪⮢ ᨢ  */
  printf("।  ⥪⮢ 䠩  ७ %s\n",ext);

    i=0;
    while( leng )
    {
     byte=fgetc(f1);
     out_port(byte);
     printf("%o  \r",--leng);
    }
  }
  else
  {
    /*  । ⥪⮢ ᨢ  */
    i=0;

  printf("। ⥪⮢ 䠩  ७ %s\n",ext);

    while( leng )
    {
     byte=fgetc(f1);
     if( byte != 015 )
     {
       out_port(byte);
       printf("%o  \r",--leng);
     }
    }
  }
  fclose(f1);
}


/**********樠 ***********/
void init_port(void)
{
  outportb(CONTROL,DIVISOR);
  outportb(LOW_DIV,speed);
  outportb(HIGH_DIV,speed >> 8);
  outportb(CONTROL,BIT_8+STOP_1+NOPARITY);
  outportb(INT_REG,0);
  if (  ( inportb(STATUS) & DATA_IN) != 0)  inportb(IN_REG);
  outportb(MODEM,0);
}

/*******   ***********/
int out_port(int symbol)
{
 long timeout;
 timeout=clock();

 while( (inportb(M_STATUS) & CTS) == 0);
 do {
     if( (clock()-timeout) == 3)
     {
       printf("\nC  -0010  ࠡ⠥ !!!\n");
       return(1);
     }
    }
 while( (inportb(STATUS) & DATA_OUT) == 0);
 outportb(OUT_REG,symbol);
 return(0);
}

/**********   ***********/
int in_port(int *symbol)
{
 long tmp;

 tmp=clock();

 outportb(MODEM,RTS);
 do
 {
   if((clock()-tmp)>= 10 )
   {
     printf("\nਥ    ࠡ⠥  ६\n");
     return (1);
   }
     error_code=inportb(STATUS);
 }
 while (( error_code & DATA_IN) == 0 );
 if(( error_code & (FRAME_ERR+OVERRUN))!=0)
 {
  printf("\n訡  ਥ" );
  return(2);
 }
 else
 {
  *symbol=inportb(IN_REG);
  outportb(MODEM,0);
  return(0);
 }
}
