/***************************************************************************
                          bkread.h  -  constants and variables and
                                       procedures of bkread

    bkread - utility to read BK tapes via soundcard

                             -------------------
    begin                : Sun Oct 28 2001
    copyright            : (C) 2001 by Alexander "las" Lunev
    email                : imbecyle@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _BKREAD_H_
#define _BKREAD_H_

#if defined (linux) || defined (__linux) || defined (__linux__)
#define SYSTEM_LINUX
#elif defined (_OS_SUN_) || defined (__SVR4)
#define SYSTEM_SOLARIS
#endif

#if !defined (USE_LINUX_AUDIO) && !defined (USE_SOLARIS_AUDIO)

#ifdef SYSTEM_LINUX
#define USE_LINUX_AUDIO
#endif

#ifdef SYSTEM_SOLARIS
#define USE_SOLARIS_AUDIO
#endif

#endif

#if defined (SYSTEM_LINUX) || defined (SYSTEM_LINUX)
#define SYSTEM_UNIX
#endif

/* Constants */

#define PATTERN_ZERO (0)
#define PATTERN_ONE  (1)
#define PATTERN_SYNC (2)
#define PATTERN_ERR  (-1)

#define MAX_SAMPLE_RATE_K 100
#define MIN_SAMPLE_RATE_K 8
#define MAX_SAMPLE_RATE (MAX_SAMPLE_RATE_K * 1000)
#define MIN_SAMPLE_RATE (MIN_SAMPLE_RATE_K * 1000)
#define DEFAULT_SAMPLE_RATE 44100


/* Variables */

extern int sample_rate;
extern int edge_level;
extern int pattern_count;
extern int pattern_start;
extern int verbose;
extern int max_adaptations;

extern char *last_error;
extern int last_pattern;

extern int period0, min_0_period, max_0_period,
           period1, min_1_period, max_1_period,
           periodS, min_S_period, max_S_period,
           max_period;

extern int adapt_tries;

extern unsigned char data[];

/* Functions */

#endif
