/***************************************************************************
                          audio.h  -  description

    bkread - utility to read BK tapes via soundcard

                             -------------------
    begin                : Wed Oct 31 2001
    copyright            : (C) 2001 by Alexander "las" Lunev
    email                : imbecyle@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _AUDIO_H_
#define _AUDIO_H_

#include "bkread.h"

// The functions definitions from audio.c
void open_audio();
#if defined (USE_SOLARIS_AUDIO)
void audioioctl(int req, audio_info_t *arg);
#elif defined (USE_LINUX_AUDIO)
void audioioctl(int req, void *arg);
void mixerioctl(int req, void *arg);
#endif

void init_audio();

int get_next_sample();
#if defined (USE_LINUX_AUDIO)
void mixerioctl(int req, void *arg);
#endif

void set_rec_gain(int val);
void set_monitor_gain(int val);
void set_sample_rate(int val);
void closeall();

// The variables definitions from audio.c
extern char *audio_name;
#if defined (USE_LINUX_AUDIO)
extern char *mixer_name;
extern int mixerdev;
#endif
extern int audiodev;

extern int record_gain, monitor_gain;
extern int sample_rate;
extern int edge_level;

// The functions definitions from analyze.c
int get_next_sample();
int read_pattern(int max);
int find_sync();
int analyze_pattern(int length);
void calculate_periods(int p0);
int try_adapt(int pattern, int to);
int read_bit();
void detect_preamble();
int detect_marker();
int read_byte(unsigned char *byte);

#endif
