////////////////////////////////////////////////////////////////////////////////
// 
// Reset module
//

module vm1_reset
(
	input      clk,
	input      reset,
	output reg dclo,
	output reg aclo
);

parameter  DCLO_WIDTH = 4;
parameter  ACLO_WIDTH = 12;

integer cnt;

always @(posedge clk or posedge reset) begin
	
	if(reset) begin
		cnt  <= 0;
		aclo <= 1;
		dclo <= 1;
	end else begin
		if(dclo | aclo) begin
			cnt <= cnt + 1;
			if(cnt > DCLO_WIDTH) dclo <= 0;
			if(cnt > ACLO_WIDTH) aclo <= 0;
		end
	end
end

endmodule
