library ieee;
use ieee.STD_LOGIC_UNSIGNED.all;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

	-- Add your library and packages declaration here ...

entity bkv1610_vhd_tst is
end bkv1610_vhd_tst;

architecture TB_ARCHITECTURE of bkv1610_vhd_tst is
	-- Component declaration of the tested unit
component bkv1610
port(
--	vgar : out std_logic_vector(4 downto 0);
--	vgag : out std_logic_vector(5 downto 0);
--	vgab : out std_logic_vector(4 downto 0);
--	vgah : out std_logic;
--	vgav : out std_logic;
	-- HDMI
	HDMI_D0		: out std_logic;
	HDMI_D0N		: out std_logic;
	HDMI_D1		: out std_logic;
	HDMI_D1N		: out std_logic;
	HDMI_D2		: out std_logic;
	HDMI_D2N		: out std_logic;
	HDMI_CLK		: out std_logic;
	HDMI_CLKN	: out std_logic;
	basic : in std_logic;
	tx : out STD_LOGIC;
	rx : in STD_LOGIC;
	ps2k_c : in STD_LOGIC;
	ps2k_d : in STD_LOGIC;
--	ifetch : out STD_LOGIC;
--	iwait : out STD_LOGIC;
--	KT0 : out std_logic;
--	KT1 : out std_logic;
--	DRAM_A : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
--	DRAM_BA : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
--	DRAM_CLK : OUT STD_LOGIC;
--	DRAM_DQ : INOUT STD_LOGIC_VECTOR(15 DOWNTO 0);
--	DRAM_DQM : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
--	DRAM_NCAS : OUT STD_LOGIC;
--	DRAM_NRAS : OUT STD_LOGIC;
--	DRAM_NWE : OUT STD_LOGIC;
--- TEST
---	test_bus_addr	: out std_logic_vector(17 downto 0);
---
	TEST	: out std_logic_vector(7 downto 0);

	DAC_OUT_L	: out std_logic;
	DAC_OUT_R	: out std_logic;

	clk100mhz : in STD_LOGIC;
	nreset : in STD_LOGIC );
end component;

--component mt48lc4m16a2
--  generic(
--       addr_bits : integer := 12;
--       col_bits : integer := 8;
--       data_bits : integer := 16;
--       mem_sizes : integer := 1048575;
--       tAC : real := 5.4;
--       tHZ : real := 5.4;
--       tMRD : real := 2.0;
--       tOH : real := 3.0;
--       tRAS : real := 37.0;
--       tRC : real := 60.0;
--       tRCD : real := 15.0;
--       tRFC : real := 66.0;
--       tRP : real := 15.0;
--       tRRD : real := 14.0;
--       tWRa : real := 7.0;
--       tWRm : real := 14.0
--  );
--  port (
--       Addr : in STD_LOGIC_VECTOR(addr_bits-1 downto 0);
--       Ba : in STD_LOGIC_VECTOR(1 downto 0);
--       Cas_n : in STD_LOGIC;
--       Cke : in STD_LOGIC;
--       Clk : in STD_LOGIC;
--       Cs_n : in STD_LOGIC;
--       Dqm : in STD_LOGIC_VECTOR(1 downto 0);
--       Ras_n : in STD_LOGIC;
--       We_n : in STD_LOGIC;
--       Dq : inout STD_LOGIC_VECTOR(data_bits-1 downto 0)
--  );
--end component;

	-- Stimulus signals - signals mapped to the input and inout ports of tested entity
signal rx : STD_LOGIC;
signal ps2k_c : STD_LOGIC;
signal ps2k_d : STD_LOGIC;
---	signal cpuclk : STD_LOGIC;
signal clk100mhz : STD_LOGIC;
signal nreset : STD_LOGIC;
-- Observed signals - signals mapped to the output ports of tested entity
--signal vgar : std_logic_vector(4 downto 0);
--signal vgag : std_logic_vector(5 downto 0);
--signal vgab : std_logic_vector(4 downto 0);
--signal vgah : STD_LOGIC;
--signal vgav : STD_LOGIC;
-- HDMI
signal HDMI_D0	: std_logic;
signal HDMI_D0N	: std_logic;
signal HDMI_D1	: std_logic;
signal HDMI_D1N	: std_logic;
signal HDMI_D2	: std_logic;
signal HDMI_D2N	: std_logic;
signal HDMI_CLK	: std_logic;
signal HDMI_CLKN	: std_logic;
signal basic : STD_LOGIC;
signal tx : STD_LOGIC;
--signal ifetch : STD_LOGIC;
--signal iwait : STD_LOGIC;
--signal KT0 : STD_LOGIC;
--signal KT1 : STD_LOGIC;
--SIGNAL DRAM_A : STD_LOGIC_VECTOR(11 DOWNTO 0);
--SIGNAL DRAM_BA : STD_LOGIC_VECTOR(1 DOWNTO 0);
--SIGNAL DRAM_CLK : STD_LOGIC;
--SIGNAL DRAM_DQ : STD_LOGIC_VECTOR(15 DOWNTO 0);
--SIGNAL DRAM_DQM : STD_LOGIC_VECTOR(1 DOWNTO 0);
--SIGNAL DRAM_NCAS : STD_LOGIC;
--SIGNAL DRAM_NRAS : STD_LOGIC;
--SIGNAL DRAM_NWE : STD_LOGIC;
---signal test_bus_addr : std_logic_vector(17 downto 0);
signal TEST : std_logic_vector(7 downto 0);
signal DAC_OUT_L : std_logic;
signal DAC_OUT_R : std_logic;

	-- Add your code here ...

begin

	-- Unit Under Test port map
	UUT : bkv1610
		port map (
--	vgar => vgar,
--	vgag => vgag,
--	vgab => vgab,
--	vgah => vgah,
--	vgav => vgav,
	HDMI_D0 => HDMI_D0,
	HDMI_D0N => HDMI_D0N,
	HDMI_D1 => HDMI_D1,
	HDMI_D1N => HDMI_D1N,
	HDMI_D2 => HDMI_D2,
	HDMI_D2N => HDMI_D2N,
	HDMI_CLK => HDMI_CLK,
	HDMI_CLKN => HDMI_CLKN,
			basic => basic,
			tx => tx,
			rx => rx,
			ps2k_c => ps2k_c,
			ps2k_d => ps2k_d,
--			ifetch => ifetch,
--			iwait => iwait,
--	KT0 => KT0,
--	KT1 => KT1,
--	DRAM_A => DRAM_A,
--	DRAM_BA => DRAM_BA,
--	DRAM_CLK => DRAM_CLK,
--	DRAM_DQ => DRAM_DQ,
--	DRAM_DQM => DRAM_DQM,
--	DRAM_NCAS => DRAM_NCAS,
--	DRAM_NRAS => DRAM_NRAS,
--	DRAM_NWE => DRAM_NWE,
---			test_bus_addr => test_bus_addr,
	TEST => TEST,
	DAC_OUT_L => DAC_OUT_L,
	DAC_OUT_R => DAC_OUT_R,
	clk100mhz => clk100mhz,
	nreset => nreset
	);

--i2 : mt48lc4m16a2
--PORT MAP (
--       Addr => DRAM_A,
--       Ba => DRAM_BA,
--       Cas_n => DRAM_NCAS,
--       Cke => '1',
--       Clk => DRAM_CLK,
--       Cs_n => '0',
--       Dqm => DRAM_DQM,
--       Ras_n => DRAM_NRAS,
--       We_n => DRAM_NWE,
--       Dq => DRAM_DQ
--	);
	
	-- Add your stimulus here ...
STIMULUS: process
begin  -- of stimulus process

	nreset <= '0';
	rx <= '0';
	ps2k_c <= '0';
	ps2k_d <= '0';
	wait for 4000 ns;
	nreset <= '1';
	wait for 100000 ns;
	rx <= '1';
	wait for 40000 ns;
	rx <= '0';
	wait;
end process; -- end of stimulus process

CLOCK_clk50mhz : process
begin
	clk100mhz <= '0';
	wait for 5 ns;
	clk100mhz <= '1';
	wait for 5 ns;
end process;

end TB_ARCHITECTURE;

configuration TESTBENCH_FOR_bkv1610 of bkv1610_vhd_tst is
	for TB_ARCHITECTURE
		for UUT : bkv1610
			use entity work.bkv1610(implementation);
		end for;
	end for;
end TESTBENCH_FOR_bkv1610;

