-------------------------------------------------------------------[04.06.2014]
-- SDRAM Controller
-------------------------------------------------------------------------------
-- Engineer: MVV
-- Adapted By Ynicky for Marsohod3

-- CLK		= 100 MHz	= 10 ns
-- WR/RD	= 6T		= 60 ns
-- RFSH		= 6T		= 60 ns

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use IEEE.std_logic_unsigned.all;

entity sdram is
port (
	CLK_I	: in std_logic;
	PRES_I	: in std_logic;
	-- Memory port
	ADDR_I	: in std_logic_vector(23 downto 0);
	DATA_I	: in std_logic_vector(15 downto 0);
---	UXDATA_I	: in std_logic_vector(127 downto 0);
	DATA_O	: out std_logic_vector(15 downto 0);
---	UXDATA_O	: out std_logic_vector(127 downto 0);
	WR_I	: in std_logic;
	BE_I	: in std_logic_vector(1 downto 0);
	RD_I	: in std_logic;
	RFSH_I	: in std_logic;
---	WRD_I		: in std_logic;
---	UXWE_I	: in std_logic_vector(7 downto 0);
---	UXWR_I	: in std_logic;
	IDLE_O	: out std_logic;
	-- SDRAM Pin
	CLK_O	: out std_logic;
	RAS_O	: out std_logic;
	CAS_O	: out std_logic;
	WE_O	: out std_logic;
	DQM_O	: out std_logic_vector(1 downto 0);
	BA_O	: out std_logic_vector(1 downto 0);
	MA_O	: out std_logic_vector(11 downto 0);
	DQ_IO	: inout std_logic_vector(15 downto 0) );
end sdram;

architecture rtl of sdram is
	signal state 		: unsigned(4 downto 0);
	signal address 	: std_logic_vector(23 downto 0);
	signal data_reg	: std_logic_vector(15 downto 0);
---	signal uxdata_reg	: std_logic_vector(127 downto 0);
	signal data			: std_logic_vector(15 downto 0);	
---	signal uxdata		: std_logic_vector(15 downto 0);	
	signal idle1		: std_logic;
	
	-- SD-RAM control signals
	signal sdr_cmd		: std_logic_vector(2 downto 0);
	signal sdr_ba		: std_logic_vector(1 downto 0);
	signal sdr_dqm		: std_logic_vector(1 downto 0);
	signal sdr_a		: std_logic_vector(11 downto 0);
	signal sdr_dq		: std_logic_vector(15 downto 0);

	constant SdrCmd_xx 	: std_logic_vector(2 downto 0) := "111"; -- no operation
	constant SdrCmd_ac 	: std_logic_vector(2 downto 0) := "011"; -- activate
	constant SdrCmd_rd 	: std_logic_vector(2 downto 0) := "101"; -- read
	constant SdrCmd_wr 	: std_logic_vector(2 downto 0) := "100"; -- write		
	constant SdrCmd_pr 	: std_logic_vector(2 downto 0) := "010"; -- precharge all
	constant SdrCmd_re 	: std_logic_vector(2 downto 0) := "001"; -- refresh
	constant SdrCmd_ms 	: std_logic_vector(2 downto 0) := "000"; -- mode regiser set

---signal cntA	: std_logic_vector(2 downto 0);
---signal uxsdwe : std_logic;

---- Init----------------------------------------------------------  Idle      Read----------  Write---------  Refresh-------
---- 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14  15        16 17 12 13 14  18 19 12 13 14  10 11 12 13 14
---- pr xx xx re xx xx xx xx xx re xx xx xx xx xx ms xx xx xx xx xx  xx/ac/re  xx rd xx xx xx  xx wr xx xx xx  xx xx xx xx xx
-- Init-------------------------------------------------------------------  Idle      Read-------------  Write------------  Refresh----------
-- 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14 15 16 17  18        19 1A 14 15 16 17  1B 1C 14 15 16 17  12 13 14 15 16 17
-- pr xx xx re xx xx xx xx xx xx re xx xx xx xx xx xx ms xx xx xx xx xx xx  xx/ac/re  xx rd xx xx xx xx  xx wr xx xx xx xx  xx xx xx xx xx xx

begin
	process (PRES_I,CLK_I)
	begin
		if PRES_I = '1' then
			sdr_cmd <= SdrCmd_xx after 1 ns;			-- NOP
			sdr_dqm <= (others => '1');
			sdr_dq  <= (others => 'Z');
			sdr_ba  <= (others => '1');
			sdr_a   <= (others => '1');
			state <= (others => '0') after 1 ns;
		elsif (CLK_I'event and CLK_I = '0') then
			case state is
				-- Init
				when "00000" =>					-- s00
					sdr_cmd <= SdrCmd_pr;			-- PRECHARGE
					sdr_a <= "111111111111";
					sdr_dq <= (others => 'Z');
					sdr_ba <= "00";
					sdr_dqm <= "11";
					state <= state + 1;
				when "00011" | "01010" =>			-- s03 s0A
					sdr_cmd <= SdrCmd_re;			-- REFRESH
					state <= state + 1;
				when "10001" =>					-- s11
					sdr_cmd <= SdrCmd_ms;			-- LOAD MODE REGISTER
					sdr_a <= "00" & "1" & "00" & "010" & "0" & "000";				
					state <= state + 1;
				
				-- Idle
				when "11000" =>					-- s18
					sdr_cmd <= SdrCmd_xx;			-- NOP
					sdr_dq <= (others => 'Z');
					idle1 <= '1';
					if (RD_I = '1') then
--						if WRD_I = '1' then
--							address <= ADDR_I(23 downto 4) & cntA & '0';
--						else
							address <= ADDR_I;
--						end if;
						idle1 <= '0';
						sdr_cmd <= SdrCmd_ac;		-- ACTIVE
						sdr_ba <= ADDR_I(9 downto 8);
						sdr_a <= ADDR_I(21 downto 10);					 
						state <= "11001";		-- s19 Read
					elsif (WR_I = '1') then
--						if WRD_I = '1' then
--							address <= ADDR_I(23 downto 4) & cntA & '0';
--						else
							address <= ADDR_I;
--						end if;
--						if WRD_I = '1' then
--							case cntA is
--								when "000"  => uxdata <= UXDATA_I(15 downto 0);
--								when "001"  => uxdata <= UXDATA_I(31 downto 16);
--								when "010"  => uxdata <= UXDATA_I(47 downto 32);
--								when "011"  => uxdata <= UXDATA_I(63 downto 48);
--								when "100"  => uxdata <= UXDATA_I(79 downto 64);
--								when "101"  => uxdata <= UXDATA_I(95 downto 80);
--								when "110"  => uxdata <= UXDATA_I(111 downto 96);
--								when others => uxdata <= UXDATA_I(127 downto 112);
--							end case;
--						end if;
						idle1 <= '0';
						data <= DATA_I;
						sdr_cmd <= SdrCmd_ac;		-- ACTIVE
						sdr_ba <= ADDR_I(9 downto 8);
						sdr_a <= ADDR_I(21 downto 10);
						state <= "11011";		-- s1B Write
					elsif (RFSH_I = '1') then
						idle1 <= '0';
						sdr_cmd <= SdrCmd_re;		-- REFRESH
						state <= "10010";		-- s12
					end if;

				-- A21 A20 A19 A18 A17 A16 A15 A14 A13 A12 A11 A10 A9 A8 A7 A6 A5 A4 A3 A2 A1 A0
				-- -----------ROW-------------------------------- BA1 BA0 -----COLUMN-------- HL		

				-- Single read - with auto precharge
				when "11010" =>					-- s1A
					sdr_cmd <= SdrCmd_rd;			-- READ (A10 = 1 enable auto precharge; A7..0 = column)
---					sdr_a <= "0100" & address(8 downto 1);
					sdr_a <= "0100" & address(7 downto 1) & '0';
					sdr_dqm <= "00";
					state <= "10100";			-- s14
				-- Single write - with auto precharge
				when "11100" =>					-- s1C
					sdr_cmd <= SdrCmd_wr;			-- WRITE (A10 = 1 enable auto precharge; A7..0 = column)
---					sdr_a <= "0100" & address(8 downto 1);
					sdr_a <= "0100" & address(7 downto 1) & '0';
--					if WRD_I = '1' then
--						sdr_dq <= uxdata;
--						sdr_dqm <= "00";
--					else
--						sdr_dq <= data & data;
--						sdr_dqm <= not address(0) & address(0);
--					end if;
					sdr_dq <= data;
					sdr_dqm <= not BE_I(1) & not BE_I(0);
					state <= "10100";			-- s14
				when others =>
					sdr_dq <= (others => 'Z');
					sdr_cmd <= SdrCmd_xx;			-- NOP
					state <= state + 1;
			end case;
		end if;
	end process;
	
	process (PRES_I,CLK_I,state,DQ_IO)
	begin
		if PRES_I = '1' then
---			uxdata_reg <= (others=>'0');
			data_reg <= x"0000";
---			cntA <= "000";
		elsif (CLK_I'event and CLK_I = '1' and idle1 = '0') then
			if (state = "10110") then --- s16
--				if WRD_I = '1' then
--					case cntA is
--						when "000"  => uxdata_reg(15 downto 0) <= DQ_IO;
--						when "001"  => uxdata_reg(31 downto 16) <= DQ_IO;
--						when "010"  => uxdata_reg(47 downto 32) <= DQ_IO;
--						when "011"  => uxdata_reg(63 downto 48) <= DQ_IO;
--						when "100"  => uxdata_reg(79 downto 64) <= DQ_IO;
--						when "101"  => uxdata_reg(95 downto 80) <= DQ_IO;
--						when "110"  => uxdata_reg(111 downto 96) <= DQ_IO;
--						when others => uxdata_reg(127 downto 112) <= DQ_IO;
--					end case;
--				elsif (address(0) = '0') then
--					data_reg <= DQ_IO(7 downto 0);
--				else
					data_reg <= DQ_IO(15 downto 0);
--				end if;
			end if;
--			if WRD_I = '0' then
--				cntA <= "000";
--			elsif state = "11000" then --- s18
--				cntA <= cntA + "001";
--			end if;
		end if;
	end process;
	

--	process (state,UXWR_I,UXWE_I,cntA)
--	begin
--			if (state = "11000") then --- s18
--					case cntA is
--						when "000"  => uxsdwe <= not UXWE_I(0) and UXWR_I;
--						when "001"  => uxsdwe <= not UXWE_I(1) and UXWR_I;
--						when "010"  => uxsdwe <= not UXWE_I(2) and UXWR_I;
--						when "011"  => uxsdwe <= not UXWE_I(3) and UXWR_I;
--						when "100"  => uxsdwe <= not UXWE_I(4) and UXWR_I;
--						when "101"  => uxsdwe <= not UXWE_I(5) and UXWR_I;
--						when "110"  => uxsdwe <= not UXWE_I(6) and UXWR_I;
--						when others => uxsdwe <= not UXWE_I(7) and UXWR_I;
--					end case;
--			end if;
--	end process;

			

	IDLE_O	<= idle1;
	DATA_O 	<= data_reg;
---	UXDATA_O <= uxdata_reg;
	CLK_O 	<= CLK_I;
	RAS_O 	<= sdr_cmd(2);
	CAS_O 	<= sdr_cmd(1);
	WE_O 	<= sdr_cmd(0);
	DQM_O 	<= sdr_dqm;
	BA_O	<= sdr_ba;
	MA_O 	<= sdr_a;
	DQ_IO 	<= sdr_dq;

end rtl;