#**************************************************************
# Time Information
#**************************************************************

set_time_format -unit ns -decimal_places 3



#**************************************************************
# Create Clock
#**************************************************************

create_clock -name {clk100mhz} -period 10.000 -waveform { 0.000 5.000 } [get_ports {clk100mhz}]


#**************************************************************
# Create Generated Clock
#**************************************************************

create_generated_clock -name {hdmiclk} -source [get_nets {pll0|altpll_component|auto_generated|wire_pll1_clk[0]}] -divide_by 4 -multiply_by 5 -duty_cycle 50.000 -master_clock {clk100mhz}
create_generated_clock -name {sysclk} -source [get_nets {pll0|altpll_component|auto_generated|wire_pll1_clk[1]}] -divide_by 1 -multiply_by 1 -duty_cycle 50.000 -master_clock {clk100mhz}
create_generated_clock -name {vgaclk} -source [get_nets {pll0|altpll_component|auto_generated|wire_pll1_clk[2]}] -divide_by 4 -multiply_by 1 -duty_cycle 50.000 -master_clock {clk100mhz}
create_generated_clock -name {cpuclkp} -source [get_nets {pll0|altpll_component|auto_generated|wire_pll1_clk[3]}] -divide_by 25 -multiply_by 1 -duty_cycle 50.000 -master_clock {clk100mhz}
create_generated_clock -name {cpuclkn} -source [get_nets {pll0|altpll_component|auto_generated|wire_pll1_clk[4]}] -divide_by 25 -multiply_by 1 -duty_cycle 50.000 -master_clock {clk100mhz}
#**************************************************************
# Set Clock Latency
#**************************************************************



#**************************************************************
# Set Clock Uncertainty
#**************************************************************



#**************************************************************
# Set Input Delay
#**************************************************************

set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[0]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[1]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[2]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[3]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[4]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[5]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[6]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[7]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[8]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[9]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[10]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[11]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[12]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[13]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[14]}]
set_input_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[15]}]

#**************************************************************
# Set Output Delay
#**************************************************************

set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[0]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[1]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[2]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[3]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[4]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[5]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[6]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[7]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[8]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[9]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[10]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[11]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[12]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[13]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[14]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQ[15]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_A*}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_CLK}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_NCAS}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_NRAS}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_NWE}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_BA*}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQM[0]}]
set_output_delay -add_delay  -clock [get_clocks {sysclk}]  5.000 [get_ports {DRAM_DQM[1]}]


#**************************************************************
# Set Clock Groups
#**************************************************************



#**************************************************************
# Set False Path
#**************************************************************



#**************************************************************
# Set Multicycle Path
#**************************************************************



#**************************************************************
# Set Maximum Delay
#**************************************************************



#**************************************************************
# Set Minimum Delay
#**************************************************************



#**************************************************************
# Set Input Transition
#**************************************************************

