--- BK0010-01 ---
--- LeftCtrl   - SU
--- LeftAlt    - AR2
--- RightAlt   - RUS
--- RightCtrl  - LAT
--- LeftShift  - NR
--- RightShift - 
--- CapsLock   - ZAGL/STR
--- Esc        - KT
--- F12        - STOP
--- F11        - White/Color
--- F10        - Standard/SIMD


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.std_logic_unsigned.all;

entity bkkbd is
port(
	pres : in STD_LOGIC;
	clk : in STD_LOGIC;
	clken : in STD_LOGIC;
	br : out std_logic;
	bg : in std_logic;
	int_vector : out std_logic_vector(8 downto 0);
	rd : in std_logic;
	wr : in std_logic;
	dw8 : in std_logic;
	keyupdn : out std_logic;
	kbdreset : out std_logic;
	kbdcolor : out std_logic;
	kbdsimd : out std_logic;
	kbdstop : out std_logic;
	addr_match : out std_logic;
	base_addr : in std_logic_vector(17 downto 0); --- o177660
	addr  : in std_logic_vector(17 downto 0);
	din : in STD_LOGIC_VECTOR(15 downto 0);
	kbci : in STD_LOGIC;
	kbdi : in STD_LOGIC;
	opalnum : out STD_LOGIC_VECTOR(3 downto 0);
	dout : out STD_LOGIC_VECTOR(15 downto 0);
	TEST : out STD_LOGIC_VECTOR(7 downto 0)
	);
end;

architecture beh of bkkbd is

-- PS/2 interface
component ps2_intf is
generic (filter_length : positive := 16);
port(
	CLK			:	in	std_logic;
	nRESET		:	in	std_logic;
	-- PS/2 interface (could be bi-dir)
	PS2_CLK		:	in	std_logic;
	PS2_DATA	:	in	std_logic;
	-- Byte-wide data interface - only valid for one clock
	-- so must be latched externally if required
	DATA		:	out	std_logic_vector(7 downto 0);
	VALID		:	out	std_logic;
	ERROR		:	out	std_logic
	);
end component;

signal snres: std_logic;
signal sKsrg: std_logic_vector(15 downto 0);
signal sKdrg: std_logic_vector(7 downto 0);
-- Interface to PS/2 block
signal keyb_data	:	std_logic_vector(7 downto 0);
signal keyb_valid	:	std_logic;
signal keyb_error	:	std_logic;
signal tg_valid	: std_logic;
signal extended	:	std_logic;
signal released	:	std_logic;
signal capslock	:	std_logic; --- ZAGL/STR
signal ruslat:	std_logic; --- RUS/LAT
signal leftalt:	std_logic; --- AR2
signal leftshift:	std_logic; --- NR
signal leftctrl:	std_logic; --- SU
signal base_addr_match : std_logic;
signal interrupt_trigger : std_logic := '0';
type interrupt_state_type is (
   i_idle,
   i_req,
   i_wait
);
signal interrupt_state : interrupt_state_type := i_idle;
signal skeyupdn :	std_logic;

begin

TEST <= skeyupdn & sKdrg(6 downto 0);
keyupdn <= skeyupdn;
snres <= not pres;

ps2 : ps2_intf port map (
	CLK => clk,
	nRESET => snres,
	PS2_CLK => kbci,
	PS2_DATA => kbdi,
	DATA => keyb_data,
	VALID => keyb_valid,
	ERROR => keyb_error
	);

base_addr_match <= '1' when base_addr(17 downto 2) = addr(17 downto 2) else '0';
addr_match <= base_addr_match;

dout <= "00000000" & sKsrg(7 downto 6) & "000000" when (base_addr_match = '1' and rd = '1' and addr(2 downto 1) = "00") --- o177660
	else "000000000" & sKdrg(6 downto 0) when (base_addr_match = '1' and rd = '1' and addr(2 downto 1) = "01") --- o177662
	else x"0000";
		
mk_dout:process (clk,clken,pres,sKsrg,base_addr_match,rd,wr,dw8,addr,released)
begin
	if pres = '1' then
		br <= '0' after 1 ns;
		interrupt_trigger <= '0' after 1 ns;
		interrupt_state <= i_idle after 1 ns;
		skeyupdn <= '1' after 1 ns;
	elsif (clk = '1' and clk'event) then
		if clken = '1' then
			if released = '1' or sKsrg(7) = '0' then
				skeyupdn <= '1' after 1 ns;
			elsif sKsrg(7) = '1' then
				skeyupdn <= '0' after 1 ns;
			end if;
			case interrupt_state is
				when i_idle =>
					if sKsrg(6) = '0' and sKsrg(7) = '1' then
						if interrupt_trigger = '0' then
							interrupt_state <= i_req after 1 ns;
							br <= '1' after 1 ns;
							interrupt_trigger <= '1' after 1 ns;
						end if;
					else
						interrupt_trigger <= '0' after 1 ns;
					end if;
				when i_req =>
					if bg = '1' then
						br <= '0' after 1 ns;
						interrupt_state <= i_wait after 1 ns;
					end if;
				when i_wait =>
					if bg = '0' then
						interrupt_state <= i_idle after 1 ns;
					end if;
				when others => interrupt_state <= i_idle after 1 ns;
			end case;
		end if;
	end if;
end process;

mk_sKsrg_sKdrg:process (pres,clk,clken,rd,wr,dw8,addr,din,base_addr_match,keyb_data,keyb_valid,keyb_error)
begin
if pres = '1' then
	tg_valid <= '0' after 1 ns;
	int_vector <= o"060" after 1 ns;
	sKsrg <= x"0040" after 1 ns; --- D6 = '1'
	sKdrg <= x"00" after 1 ns;
	opalnum <= "0000" after 1 ns;
	released <= '0' after 1 ns;
	capslock <= '1' after 1 ns; --- ZAGL
	extended <= '0' after 1 ns;
	ruslat <= '0' after 1 ns; --- LAT
	leftalt <= '0' after 1 ns; --- AR2
	leftshift <= '0' after 1 ns; --- NR
	leftctrl <= '0' after 1 ns; --- SU
	kbdreset <= '0' after 1 ns;
	kbdcolor <= '0' after 1 ns;
	kbdsimd <= '0' after 1 ns;
	kbdstop <= '0' after 1 ns;
elsif (clk = '1' and clk'event) then
	if keyb_valid = '1' then
		tg_valid <= '1' after 1 ns;
	elsif clken = '1' then
		tg_valid <= '0' after 1 ns;
	end if;
	if clken = '1' then
		if base_addr_match = '1' and wr = '1' then
			if dw8 = '0' or (dw8 = '1' and addr(0) = '0') then
				case addr(2 downto 1) is
					when "00" => sKsrg(6) <= din(6);
					when others => null;
				end case;
			end if;
			if dw8 = '0' or (dw8 = '1' and addr(0) = '1') then
				case addr(2 downto 1) is
					when "01" => opalnum <= din(11 downto 8);
					when others => null;
				end case;
			end if;
		end if;
		if base_addr_match = '1' and rd = '1' and addr(2 downto 1) = "01" then
			sKsrg(7) <= '0' after 1 ns;
			sKsrg(1) <= '0' after 1 ns;
		elsif tg_valid = '1' then
			if keyb_data = x"7E" then --- ScrollLock
				if released = '0' then
					kbdreset <= '1' after 1 ns; --- Reset
				else
					kbdreset <= '0' after 1 ns;
					released <= '0' after 1 ns;
				end if;
------------
			elsif keyb_data = x"09" then --- F10
				if released = '0' then
					kbdsimd <= '1' after 1 ns; --- SIMD
				else
					kbdsimd <= '0' after 1 ns;
					released <= '0' after 1 ns;
				end if;
			elsif keyb_data = x"78" then --- F11
				if released = '0' then
					kbdcolor <= '1' after 1 ns; --- White/Color
				else
					kbdcolor <= '0' after 1 ns;
					released <= '0' after 1 ns;
				end if;
------------
			elsif keyb_data = x"07" then --- F12
--				int_vector <= o"004" after 1 ns;
--				sKsrg(7) <= '1' after 1 ns;
				if released = '0' then
					kbdstop <= '1' after 1 ns; --- STOP
				else
					kbdstop <= '0' after 1 ns;
					released <= '0' after 1 ns;
				end if;
			elsif keyb_data = x"F0" then --- keyup
				released <= '1' after 1 ns;
				extended <= '0' after 1 ns;
			elsif keyb_data = x"E0" then
				extended <= '1' after 1 ns;
			elsif keyb_data = x"11" then --- Alt
				if extended = '0' then --- LeftAlt
					if released = '0' then
						leftalt <= '1' after 1 ns; --- AR2
						int_vector <= o"274" after 1 ns;
					else
						leftalt <= '0' after 1 ns;
						released <= '0' after 1 ns;
						int_vector <= o"060" after 1 ns;
					end if;
				else --- RightAlt
					int_vector <= o"060" after 1 ns;
---					if released = '0' then
					if released = '0' and sKsrg(7) = '0' then
						ruslat <= '1' after 1 ns; --- RUS
						sKsrg(7) <= '1' after 1 ns;
						sKdrg <= x"0E" after 1 ns;
					else
						released <= '0' after 1 ns;
					end if;
				end if;
			elsif keyb_data = x"12" then --- LeftShift
				if released = '0' then
					leftshift <= '1' after 1 ns; --- NR
---					int_vector <= o"060" after 1 ns;
				else
					leftshift <= '0' after 1 ns;
					released <= '0' after 1 ns;
				end if;
			elsif keyb_data = x"14" then --- Ctrl
				if extended = '0' then --- LeftCtrl
					if released = '0' then
						leftctrl <= '1' after 1 ns; --- SU
---						int_vector <= o"060" after 1 ns;
					else
						leftctrl <= '0' after 1 ns;
						released <= '0' after 1 ns;
					end if;
				else --- RightCtrl
---					if released = '0' then
					if released = '0' and sKsrg(7) = '0' then
						ruslat <= '0' after 1 ns; --- LAT
---						int_vector <= o"060" after 1 ns;
						sKsrg(7) <= '1' after 1 ns;
						sKdrg <= x"0F" after 1 ns;
					else
						released <= '0' after 1 ns;
					end if;
				end if;
			elsif keyb_data = x"58" then --- CapsLock
				if released = '0' then
					capslock <= not capslock after 1 ns; --- ZAGL/STR
---					int_vector <= o"060" after 1 ns;
				else
					released <= '0' after 1 ns;
				end if;
---			elsif leftalt = '1' then --- AR2
			elsif leftalt = '1' and sKsrg(7) = '0' then --- AR2
---				int_vector <= o"060" after 1 ns;
				if released = '0' then
					if leftshift = '1' then --- NR
						case keyb_data is
							when x"2E" => sKdrg <= x"35" after 1 ns; sKsrg(7) <= '1' after 1 ns;---5
							when x"36" => sKdrg <= x"36" after 1 ns; sKsrg(7) <= '1' after 1 ns;---6
							when x"3D" => sKdrg <= x"37" after 1 ns; sKsrg(7) <= '1' after 1 ns;---7
							when others => null;
						end case;
					else
						case keyb_data is
							when x"0A" => sKdrg <= x"0C" after 1 ns; sKsrg(7) <= '1' after 1 ns;---F8
---extended						when x"6B" => sKdrg <= x"08" after 1 ns; sKsrg(7) <= '1' after 1 ns;---<=
---extended						when x"4C" => sKdrg <= x"42" after 1 ns; sKsrg(7) <= '1' after 1 ns;---:
							when x"4C" => sKdrg <= x"3B" after 1 ns; sKsrg(7) <= '1' after 1 ns;---;
							---
							when others => null;
						end case;
					end if;
				else
					released <= '0' after 1 ns;
				end if;
---			elsif leftshift = '1' then --- NR
			elsif leftshift = '1' and sKsrg(7) = '0' then --- NR
---				int_vector <= o"060" after 1 ns;
				if released = '0' then
					if ruslat = '0' then --- LAT
						case keyb_data is
							when x"16" => sKdrg <= x"21"; sKsrg(7) <= '1' after 1 ns;---!
							when x"1E" => sKdrg <= x"40"; sKsrg(7) <= '1' after 1 ns;---@
							when x"26" => sKdrg <= x"23"; sKsrg(7) <= '1' after 1 ns;---#
							when x"25" => sKdrg <= x"24"; sKsrg(7) <= '1' after 1 ns;---$
							when x"2E" => sKdrg <= x"25"; sKsrg(7) <= '1' after 1 ns;---%
							when x"36" => sKdrg <= x"7E"; sKsrg(7) <= '1' after 1 ns;---^
							when x"3D" => sKdrg <= x"26"; sKsrg(7) <= '1' after 1 ns;---&
							when x"3E" => sKdrg <= x"2A"; sKsrg(7) <= '1' after 1 ns;---*
							when x"46" => sKdrg <= x"28"; sKsrg(7) <= '1' after 1 ns;---(
							when x"45" => sKdrg <= x"29"; sKsrg(7) <= '1' after 1 ns;---)
							when x"4E" => sKdrg <= x"2D"; sKsrg(7) <= '1' after 1 ns;--- -
							when x"55" => sKdrg <= x"2B"; sKsrg(7) <= '1' after 1 ns;---+
							when x"5D" => sKdrg <= x"5C"; sKsrg(7) <= '1' after 1 ns;---\
							when others => null;
						end case;
					else --- RUS
						case keyb_data is
							when x"16" => sKdrg <= x"21"; sKsrg(7) <= '1' after 1 ns;---!
							when x"1E" => sKdrg <= x"22"; sKsrg(7) <= '1' after 1 ns;---"
							when x"26" => sKdrg <= x"23"; sKsrg(7) <= '1' after 1 ns;---#
							when x"25" => sKdrg <= x"3B"; sKsrg(7) <= '1' after 1 ns;---;
							when x"2E" => sKdrg <= x"25"; sKsrg(7) <= '1' after 1 ns;---%
							when x"36" => sKdrg <= x"3A"; sKsrg(7) <= '1' after 1 ns;---:
							when x"3D" => sKdrg <= x"26"; sKsrg(7) <= '1' after 1 ns;---&
							when x"3E" => sKdrg <= x"2A"; sKsrg(7) <= '1' after 1 ns;---*
							when x"46" => sKdrg <= x"28"; sKsrg(7) <= '1' after 1 ns;---(
							when x"45" => sKdrg <= x"29"; sKsrg(7) <= '1' after 1 ns;---)
							when x"4E" => sKdrg <= x"2D"; sKsrg(7) <= '1' after 1 ns;--- -
							when x"55" => sKdrg <= x"2B"; sKsrg(7) <= '1' after 1 ns;---+
							when x"5D" => sKdrg <= x"2F"; sKsrg(7) <= '1' after 1 ns;---/
							when others => null;
						end case;
					end if;
				else
					released <= '0' after 1 ns;
				end if;
---			elsif leftctrl = '1' then --- SU
			elsif leftctrl = '1' and sKsrg(7) = '0' then --- SU
---				int_vector <= o"060" after 1 ns;
				if released = '0' then
					if ruslat = '0' then --- LAT
					else --- RUS
						case keyb_data is
							when x"15" => sKdrg <= x"6A"; sKsrg(7) <= '1' after 1 ns;---SU/й
							when x"1D" => sKdrg <= x"52"; sKsrg(7) <= '1' after 1 ns;---SU/ц
							when x"24" => sKdrg <= x"53"; sKsrg(7) <= '1' after 1 ns;---SU/у
							when others => null;
						end case;
					end if;
					case keyb_data is
						when x"34" => sKdrg <= x"07"; sKsrg(7) <= '1' after 1 ns;---SU/G (ZVONOK)
						when x"3A" => sKdrg <= x"0D"; sKsrg(7) <= '1' after 1 ns;---SU/M (UST TAB)
						when x"4D" => sKdrg <= x"10"; sKsrg(7) <= '1' after 1 ns;---SU/P (SBR TAB)
						when x"2D" => sKdrg <= x"12"; sKsrg(7) <= '1' after 1 ns;---SU/R
						when x"2C" => sKdrg <= x"14"; sKsrg(7) <= '1' after 1 ns;---SU/T (GT)
						when x"3C" => sKdrg <= x"15"; sKsrg(7) <= '1' after 1 ns;---SU/U ()
						when x"54" => sKdrg <= x"1C"; sKsrg(7) <= '1' after 1 ns;---SU/[ (UPLT)
						when x"5B" => sKdrg <= x"1D"; sKsrg(7) <= '1' after 1 ns;---SU/] (UPRT)
						when x"52" => sKdrg <= x"1F"; sKsrg(7) <= '1' after 1 ns;---SU/' (DNLT)
						when x"5D" => sKdrg <= x"1E"; sKsrg(7) <= '1' after 1 ns;---SU/\ (DNRT)

						when x"15" => sKdrg <= x"4A"; sKsrg(7) <= '1' after 1 ns;---й
						when others => null;
					end case;
				else
					released <= '0' after 1 ns;
				end if;
			elsif extended = '0' then
---			elsif extended = '0' and sKsrg(7) = '0' then
---				int_vector <= o"060" after 1 ns;
---				if released = '0' then
				if released = '0' and sKsrg(7) = '0' then
---					sKsrg(7) <= '1' after 1 ns;
					if ruslat = '0' then --- LAT
						if capslock = '1' then --- ZAGL
							case keyb_data is
								when x"5A" => sKdrg <= x"0A"; sKsrg(7) <= '1' after 1 ns;---Enter
								when x"66" => sKdrg <= x"18"; sKsrg(7) <= '1' after 1 ns;---BackSpace
								when x"0D" => sKdrg <= x"09"; sKsrg(7) <= '1' after 1 ns;---Tab
								when x"29" => sKdrg <= x"20"; sKsrg(7) <= '1' after 1 ns;---Space
								when x"76" => sKdrg <= x"03"; sKsrg(7) <= '1' after 1 ns;---Esc / KT

---int_vector <= o"274" after 1 ns;
								when x"05" => sKdrg <= x"01"; sKsrg(7) <= '1' after 1 ns;---F1 / POVT
								when x"06" => sKdrg <= x"0B"; sKsrg(7) <= '1' after 1 ns;---F2 / =|=>|
								when x"04" => sKdrg <= x"16"; sKsrg(7) <= '1' after 1 ns;---F3 / |<==
								when x"0C" => sKdrg <= x"17"; sKsrg(7) <= '1' after 1 ns;---F4 / |==>
								when x"03" => sKdrg <= x"02"; sKsrg(7) <= '1' after 1 ns;---F5 / IND SU
								when x"0B" => sKdrg <= x"04"; sKsrg(7) <= '1' after 1 ns;---F6 / BLOK RED
								when x"83" => sKdrg <= x"00"; sKsrg(7) <= '1' after 1 ns;---F7 / SHAG
								when x"0A" => sKdrg <= x"0C"; sKsrg(7) <= '1' after 1 ns;---F8 / SBR
								when x"01" => sKdrg <= x"13"; sKsrg(7) <= '1' after 1 ns;---F9 / VS
---								when x"07" => sKdrg <= x""; sKsrg(7) <= '1' after 1 ns;---F12 / STOP
------------------------------------

								when x"1C" => sKdrg <= x"41"; sKsrg(7) <= '1' after 1 ns;---A
								when x"32" => sKdrg <= x"42"; sKsrg(7) <= '1' after 1 ns;---B
								when x"21" => sKdrg <= x"43"; sKsrg(7) <= '1' after 1 ns;---C
								when x"23" => sKdrg <= x"44"; sKsrg(7) <= '1' after 1 ns;---D
								when x"24" => sKdrg <= x"45"; sKsrg(7) <= '1' after 1 ns;---E
								when x"2B" => sKdrg <= x"46"; sKsrg(7) <= '1' after 1 ns;---F
								when x"34" => sKdrg <= x"47"; sKsrg(7) <= '1' after 1 ns;---G
								when x"33" => sKdrg <= x"48"; sKsrg(7) <= '1' after 1 ns;---H
								when x"43" => sKdrg <= x"49"; sKsrg(7) <= '1' after 1 ns;---I
								when x"3B" => sKdrg <= x"4A"; sKsrg(7) <= '1' after 1 ns;---J
								when x"42" => sKdrg <= x"4B"; sKsrg(7) <= '1' after 1 ns;---K
								when x"4B" => sKdrg <= x"4C"; sKsrg(7) <= '1' after 1 ns;---L
								when x"3A" => sKdrg <= x"4D"; sKsrg(7) <= '1' after 1 ns;---M
								when x"31" => sKdrg <= x"4E"; sKsrg(7) <= '1' after 1 ns;---N
								when x"44" => sKdrg <= x"4F"; sKsrg(7) <= '1' after 1 ns;---O
								when x"4D" => sKdrg <= x"50"; sKsrg(7) <= '1' after 1 ns;---P
								when x"15" => sKdrg <= x"51"; sKsrg(7) <= '1' after 1 ns;---Q
								when x"2D" => sKdrg <= x"52"; sKsrg(7) <= '1' after 1 ns;---R
								when x"1B" => sKdrg <= x"53"; sKsrg(7) <= '1' after 1 ns;---S
								when x"2C" => sKdrg <= x"54"; sKsrg(7) <= '1' after 1 ns;---T
								when x"3C" => sKdrg <= x"55"; sKsrg(7) <= '1' after 1 ns;---U
								when x"2A" => sKdrg <= x"56"; sKsrg(7) <= '1' after 1 ns;---V
								when x"1D" => sKdrg <= x"57"; sKsrg(7) <= '1' after 1 ns;---W
								when x"22" => sKdrg <= x"58"; sKsrg(7) <= '1' after 1 ns;---X
								when x"35" => sKdrg <= x"59"; sKsrg(7) <= '1' after 1 ns;---Y
								when x"1A" => sKdrg <= x"5A"; sKsrg(7) <= '1' after 1 ns;---Z
								when x"16" => sKdrg <= x"31"; sKsrg(7) <= '1' after 1 ns;---1
								when x"1E" => sKdrg <= x"32"; sKsrg(7) <= '1' after 1 ns;---2
								when x"26" => sKdrg <= x"33"; sKsrg(7) <= '1' after 1 ns;---3
								when x"25" => sKdrg <= x"34"; sKsrg(7) <= '1' after 1 ns;---4
								when x"2E" => sKdrg <= x"35"; sKsrg(7) <= '1' after 1 ns;---5
								when x"36" => sKdrg <= x"36"; sKsrg(7) <= '1' after 1 ns;---6
								when x"3D" => sKdrg <= x"37"; sKsrg(7) <= '1' after 1 ns;---7
								when x"3E" => sKdrg <= x"38"; sKsrg(7) <= '1' after 1 ns;---8
								when x"46" => sKdrg <= x"39"; sKsrg(7) <= '1' after 1 ns;---9
								when x"45" => sKdrg <= x"30"; sKsrg(7) <= '1' after 1 ns;---0
								when x"54" => sKdrg <= x"5B"; sKsrg(7) <= '1' after 1 ns;---[
								when x"5B" => sKdrg <= x"5D"; sKsrg(7) <= '1' after 1 ns;---]
								when x"4E" => sKdrg <= x"2D"; sKsrg(7) <= '1' after 1 ns;--- -
								when x"55" => sKdrg <= x"3D"; sKsrg(7) <= '1' after 1 ns;---=
								when x"4A" => sKdrg <= x"2F"; sKsrg(7) <= '1' after 1 ns;---/
								when x"5D" => sKdrg <= x"5C"; sKsrg(7) <= '1' after 1 ns;---\
								when x"4C" => sKdrg <= x"3B"; sKsrg(7) <= '1' after 1 ns;---;
								when x"41" => sKdrg <= x"2C"; sKsrg(7) <= '1' after 1 ns;---,
								when x"49" => sKdrg <= x"2E"; sKsrg(7) <= '1' after 1 ns;---.
								when x"52" => sKdrg <= x"27"; sKsrg(7) <= '1' after 1 ns;---'
								when x"0E" => sKdrg <= x"7E"; sKsrg(7) <= '1' after 1 ns;---~
								when others => null;
							end case;
						else --- STR
							case keyb_data is
								when x"5A" => sKdrg <= x"0A"; sKsrg(7) <= '1' after 1 ns;---Enter
								when x"66" => sKdrg <= x"18"; sKsrg(7) <= '1' after 1 ns;---BackSpace
								when x"0D" => sKdrg <= x"09"; sKsrg(7) <= '1' after 1 ns;---Tab
								when x"29" => sKdrg <= x"20"; sKsrg(7) <= '1' after 1 ns;---Space
								when x"76" => sKdrg <= x"03"; sKsrg(7) <= '1' after 1 ns;---Esc
								when x"1C" => sKdrg <= x"61"; sKsrg(7) <= '1' after 1 ns;---a
								when x"32" => sKdrg <= x"62"; sKsrg(7) <= '1' after 1 ns;---b
								when x"21" => sKdrg <= x"63"; sKsrg(7) <= '1' after 1 ns;---c
								when x"23" => sKdrg <= x"64"; sKsrg(7) <= '1' after 1 ns;---d
								when x"24" => sKdrg <= x"65"; sKsrg(7) <= '1' after 1 ns;---e
								when x"2B" => sKdrg <= x"66"; sKsrg(7) <= '1' after 1 ns;---f
								when x"34" => sKdrg <= x"67"; sKsrg(7) <= '1' after 1 ns;---g
								when x"33" => sKdrg <= x"68"; sKsrg(7) <= '1' after 1 ns;---h
								when x"43" => sKdrg <= x"69"; sKsrg(7) <= '1' after 1 ns;---i
								when x"3B" => sKdrg <= x"6A"; sKsrg(7) <= '1' after 1 ns;---j
								when x"42" => sKdrg <= x"6B"; sKsrg(7) <= '1' after 1 ns;---k
								when x"4B" => sKdrg <= x"6C"; sKsrg(7) <= '1' after 1 ns;---l
								when x"3A" => sKdrg <= x"6D"; sKsrg(7) <= '1' after 1 ns;---m
								when x"31" => sKdrg <= x"6E"; sKsrg(7) <= '1' after 1 ns;---n
								when x"44" => sKdrg <= x"6F"; sKsrg(7) <= '1' after 1 ns;---o
								when x"4D" => sKdrg <= x"70"; sKsrg(7) <= '1' after 1 ns;---p
								when x"15" => sKdrg <= x"71"; sKsrg(7) <= '1' after 1 ns;---q
								when x"2D" => sKdrg <= x"72"; sKsrg(7) <= '1' after 1 ns;---r
								when x"1B" => sKdrg <= x"73"; sKsrg(7) <= '1' after 1 ns;---s
								when x"2C" => sKdrg <= x"74"; sKsrg(7) <= '1' after 1 ns;---t
								when x"3C" => sKdrg <= x"75"; sKsrg(7) <= '1' after 1 ns;---u
								when x"2A" => sKdrg <= x"76"; sKsrg(7) <= '1' after 1 ns;---v
								when x"1D" => sKdrg <= x"77"; sKsrg(7) <= '1' after 1 ns;---w
								when x"22" => sKdrg <= x"78"; sKsrg(7) <= '1' after 1 ns;---x
								when x"35" => sKdrg <= x"79"; sKsrg(7) <= '1' after 1 ns;---y
								when x"1A" => sKdrg <= x"7A"; sKsrg(7) <= '1' after 1 ns;---z
								when x"16" => sKdrg <= x"31"; sKsrg(7) <= '1' after 1 ns;---1
								when x"1E" => sKdrg <= x"32"; sKsrg(7) <= '1' after 1 ns;---2
								when x"26" => sKdrg <= x"33"; sKsrg(7) <= '1' after 1 ns;---3
								when x"25" => sKdrg <= x"34"; sKsrg(7) <= '1' after 1 ns;---4
								when x"2E" => sKdrg <= x"35"; sKsrg(7) <= '1' after 1 ns;---5
								when x"36" => sKdrg <= x"36"; sKsrg(7) <= '1' after 1 ns;---6
								when x"3D" => sKdrg <= x"37"; sKsrg(7) <= '1' after 1 ns;---7
								when x"3E" => sKdrg <= x"38"; sKsrg(7) <= '1' after 1 ns;---8
								when x"46" => sKdrg <= x"39"; sKsrg(7) <= '1' after 1 ns;---9
								when x"45" => sKdrg <= x"30"; sKsrg(7) <= '1' after 1 ns;---0
								when x"54" => sKdrg <= x"5B"; sKsrg(7) <= '1' after 1 ns;---[
								when x"5B" => sKdrg <= x"5D"; sKsrg(7) <= '1' after 1 ns;---]
								when x"4E" => sKdrg <= x"2D"; sKsrg(7) <= '1' after 1 ns;--- -
								when x"55" => sKdrg <= x"3D"; sKsrg(7) <= '1' after 1 ns;---=
								when x"4A" => sKdrg <= x"3F"; sKsrg(7) <= '1' after 1 ns;---?
								when x"5D" => sKdrg <= x"5C"; sKsrg(7) <= '1' after 1 ns;---\
								when x"4C" => sKdrg <= x"3B"; sKsrg(7) <= '1' after 1 ns;---;
								when x"41" => sKdrg <= x"2C"; sKsrg(7) <= '1' after 1 ns;---,
								when x"49" => sKdrg <= x"2E"; sKsrg(7) <= '1' after 1 ns;---.
								when x"52" => sKdrg <= x"27"; sKsrg(7) <= '1' after 1 ns;---'
								when x"0E" => sKdrg <= x"7E"; sKsrg(7) <= '1' after 1 ns;---~
								when others => null;
							end case;
						end if;	
					else --- RUS	
						if capslock = '1' then --- ZAGL
							case keyb_data is
								when x"5A" => sKdrg <= x"0A"; sKsrg(7) <= '1' after 1 ns;---Enter
								when x"66" => sKdrg <= x"18"; sKsrg(7) <= '1' after 1 ns;---BackSpace
								when x"0D" => sKdrg <= x"09"; sKsrg(7) <= '1' after 1 ns;---Tab
								when x"29" => sKdrg <= x"20"; sKsrg(7) <= '1' after 1 ns;---Space
								when x"76" => sKdrg <= x"03"; sKsrg(7) <= '1' after 1 ns;---Esc
								when x"1C" => sKdrg <= x"66"; sKsrg(7) <= '1' after 1 ns;---Ф
								when x"32" => sKdrg <= x"69"; sKsrg(7) <= '1' after 1 ns;---И
								when x"21" => sKdrg <= x"73"; sKsrg(7) <= '1' after 1 ns;---С
								when x"23" => sKdrg <= x"77"; sKsrg(7) <= '1' after 1 ns;---В
								when x"24" => sKdrg <= x"75"; sKsrg(7) <= '1' after 1 ns;---У
								when x"2B" => sKdrg <= x"61"; sKsrg(7) <= '1' after 1 ns;---А
								when x"34" => sKdrg <= x"70"; sKsrg(7) <= '1' after 1 ns;---П
								when x"33" => sKdrg <= x"72"; sKsrg(7) <= '1' after 1 ns;---Р
								when x"43" => sKdrg <= x"7B"; sKsrg(7) <= '1' after 1 ns;---Ш
								when x"3B" => sKdrg <= x"6F"; sKsrg(7) <= '1' after 1 ns;---О
								when x"42" => sKdrg <= x"6C"; sKsrg(7) <= '1' after 1 ns;---Л
								when x"4B" => sKdrg <= x"64"; sKsrg(7) <= '1' after 1 ns;---Д
								when x"3A" => sKdrg <= x"78"; sKsrg(7) <= '1' after 1 ns;---Ь
								when x"31" => sKdrg <= x"74"; sKsrg(7) <= '1' after 1 ns;---Т
								when x"44" => sKdrg <= x"7D"; sKsrg(7) <= '1' after 1 ns;---Щ
								when x"4D" => sKdrg <= x"7A"; sKsrg(7) <= '1' after 1 ns;---З
								when x"15" => sKdrg <= x"6A"; sKsrg(7) <= '1' after 1 ns;---Й
								when x"2D" => sKdrg <= x"6B"; sKsrg(7) <= '1' after 1 ns;---К
								when x"1B" => sKdrg <= x"79"; sKsrg(7) <= '1' after 1 ns;---Ы
								when x"2C" => sKdrg <= x"65"; sKsrg(7) <= '1' after 1 ns;---Е
								when x"3C" => sKdrg <= x"67"; sKsrg(7) <= '1' after 1 ns;---Г
								when x"2A" => sKdrg <= x"6D"; sKsrg(7) <= '1' after 1 ns;---М
								when x"1D" => sKdrg <= x"63"; sKsrg(7) <= '1' after 1 ns;---Ц
								when x"22" => sKdrg <= x"7E"; sKsrg(7) <= '1' after 1 ns;---Ч
								when x"35" => sKdrg <= x"6E"; sKsrg(7) <= '1' after 1 ns;---Н
								when x"1A" => sKdrg <= x"71"; sKsrg(7) <= '1' after 1 ns;---Я
								when x"16" => sKdrg <= x"31"; sKsrg(7) <= '1' after 1 ns;---1
								when x"1E" => sKdrg <= x"32"; sKsrg(7) <= '1' after 1 ns;---2
								when x"26" => sKdrg <= x"33"; sKsrg(7) <= '1' after 1 ns;---3
								when x"25" => sKdrg <= x"34"; sKsrg(7) <= '1' after 1 ns;---4
								when x"2E" => sKdrg <= x"35"; sKsrg(7) <= '1' after 1 ns;---5
								when x"36" => sKdrg <= x"36"; sKsrg(7) <= '1' after 1 ns;---6
								when x"3D" => sKdrg <= x"37"; sKsrg(7) <= '1' after 1 ns;---7
								when x"3E" => sKdrg <= x"38"; sKsrg(7) <= '1' after 1 ns;---8
								when x"46" => sKdrg <= x"39"; sKsrg(7) <= '1' after 1 ns;---9
								when x"45" => sKdrg <= x"30"; sKsrg(7) <= '1' after 1 ns;---0
								when x"54" => sKdrg <= x"68"; sKsrg(7) <= '1' after 1 ns;---Х
								when x"5B" => sKdrg <= x"7F"; sKsrg(7) <= '1' after 1 ns;---Ъ
								when x"4E" => sKdrg <= x"2D"; sKsrg(7) <= '1' after 1 ns;--- -
								when x"55" => sKdrg <= x"3D"; sKsrg(7) <= '1' after 1 ns;---=
								when x"4A" => sKdrg <= x"2F"; sKsrg(7) <= '1' after 1 ns;---/
								when x"5D" => sKdrg <= x"5C"; sKsrg(7) <= '1' after 1 ns;---\
								when x"4C" => sKdrg <= x"76"; sKsrg(7) <= '1' after 1 ns;---Ж
								when x"52" => sKdrg <= x"7C"; sKsrg(7) <= '1' after 1 ns;---Э
								when x"41" => sKdrg <= x"62"; sKsrg(7) <= '1' after 1 ns;---Б
								when x"49" => sKdrg <= x"60"; sKsrg(7) <= '1' after 1 ns;---Ю
---								when x"0E" => sKdrg <= x""; sKsrg(7) <= '1' after 1 ns;---Ё ???
								when others => null;
							end case;
						else --- STR
							case keyb_data is
								when x"5A" => sKdrg <= x"0A"; sKsrg(7) <= '1' after 1 ns;---Enter
								when x"66" => sKdrg <= x"18"; sKsrg(7) <= '1' after 1 ns;---BackSpace
								when x"0D" => sKdrg <= x"09"; sKsrg(7) <= '1' after 1 ns;---Tab
								when x"29" => sKdrg <= x"20"; sKsrg(7) <= '1' after 1 ns;---Space
								when x"76" => sKdrg <= x"03"; sKsrg(7) <= '1' after 1 ns;---Esc
								when x"1C" => sKdrg <= x"46"; sKsrg(7) <= '1' after 1 ns;---ф
								when x"32" => sKdrg <= x"49"; sKsrg(7) <= '1' after 1 ns;---и
								when x"21" => sKdrg <= x"53"; sKsrg(7) <= '1' after 1 ns;---с
								when x"23" => sKdrg <= x"57"; sKsrg(7) <= '1' after 1 ns;---в
								when x"24" => sKdrg <= x"55"; sKsrg(7) <= '1' after 1 ns;---у
								when x"2B" => sKdrg <= x"41"; sKsrg(7) <= '1' after 1 ns;---а
								when x"34" => sKdrg <= x"50"; sKsrg(7) <= '1' after 1 ns;---п
								when x"33" => sKdrg <= x"52"; sKsrg(7) <= '1' after 1 ns;---р
								when x"43" => sKdrg <= x"5B"; sKsrg(7) <= '1' after 1 ns;---ш
								when x"3B" => sKdrg <= x"4F"; sKsrg(7) <= '1' after 1 ns;---о
								when x"42" => sKdrg <= x"4C"; sKsrg(7) <= '1' after 1 ns;---л
								when x"4B" => sKdrg <= x"44"; sKsrg(7) <= '1' after 1 ns;---д
								when x"3A" => sKdrg <= x"58"; sKsrg(7) <= '1' after 1 ns;---ь
								when x"31" => sKdrg <= x"54"; sKsrg(7) <= '1' after 1 ns;---т
								when x"44" => sKdrg <= x"5D"; sKsrg(7) <= '1' after 1 ns;---щ
								when x"4D" => sKdrg <= x"5A"; sKsrg(7) <= '1' after 1 ns;---з
								when x"15" => sKdrg <= x"4A"; sKsrg(7) <= '1' after 1 ns;---й
								when x"2D" => sKdrg <= x"4B"; sKsrg(7) <= '1' after 1 ns;---к
								when x"1B" => sKdrg <= x"59"; sKsrg(7) <= '1' after 1 ns;---ы
								when x"2C" => sKdrg <= x"45"; sKsrg(7) <= '1' after 1 ns;---е
								when x"3C" => sKdrg <= x"47"; sKsrg(7) <= '1' after 1 ns;---г
								when x"2A" => sKdrg <= x"4D"; sKsrg(7) <= '1' after 1 ns;---м
								when x"1D" => sKdrg <= x"43"; sKsrg(7) <= '1' after 1 ns;---ц
								when x"22" => sKdrg <= x"5E"; sKsrg(7) <= '1' after 1 ns;---ч
								when x"35" => sKdrg <= x"4E"; sKsrg(7) <= '1' after 1 ns;---н
								when x"1A" => sKdrg <= x"51"; sKsrg(7) <= '1' after 1 ns;---я
								when x"16" => sKdrg <= x"31"; sKsrg(7) <= '1' after 1 ns;---1
								when x"1E" => sKdrg <= x"32"; sKsrg(7) <= '1' after 1 ns;---2
								when x"26" => sKdrg <= x"33"; sKsrg(7) <= '1' after 1 ns;---3
								when x"25" => sKdrg <= x"34"; sKsrg(7) <= '1' after 1 ns;---4
								when x"2E" => sKdrg <= x"35"; sKsrg(7) <= '1' after 1 ns;---5
								when x"36" => sKdrg <= x"36"; sKsrg(7) <= '1' after 1 ns;---6
								when x"3D" => sKdrg <= x"37"; sKsrg(7) <= '1' after 1 ns;---7
								when x"3E" => sKdrg <= x"38"; sKsrg(7) <= '1' after 1 ns;---8
								when x"46" => sKdrg <= x"39"; sKsrg(7) <= '1' after 1 ns;---9
								when x"45" => sKdrg <= x"30"; sKsrg(7) <= '1' after 1 ns;---0
								when x"54" => sKdrg <= x"48"; sKsrg(7) <= '1' after 1 ns;---х
								when x"5B" => sKdrg <= x"5F"; sKsrg(7) <= '1' after 1 ns;---ъ
								when x"4E" => sKdrg <= x"2D"; sKsrg(7) <= '1' after 1 ns;--- -
								when x"55" => sKdrg <= x"3D"; sKsrg(7) <= '1' after 1 ns;---=
								when x"4A" => sKdrg <= x"2F"; sKsrg(7) <= '1' after 1 ns;---/
								when x"5D" => sKdrg <= x"5C"; sKsrg(7) <= '1' after 1 ns;---\
								when x"4C" => sKdrg <= x"56"; sKsrg(7) <= '1' after 1 ns;---ж
								when x"52" => sKdrg <= x"5C"; sKsrg(7) <= '1' after 1 ns;---э
								when x"41" => sKdrg <= x"42"; sKsrg(7) <= '1' after 1 ns;---б
								when x"49" => sKdrg <= x"40"; sKsrg(7) <= '1' after 1 ns;---ю
---								when x"0E" => sKdrg <= x""; sKsrg(7) <= '1' after 1 ns;---ё
								when others => null;
							end case;
						end if;
					end if;
				else --- released = '1'
					released <= '0' after 1 ns;				
				end if;
			else --- extended = '1'
				if keyb_data = x"F0" then --- keyup
					released <= '1' after 1 ns;
---29299312
				elsif released = '0' and sKsrg(7) = '0' then
---				elsif released = '0' then
						if leftalt = '1' then --- AR2
							int_vector <= o"274" after 1 ns;
							if leftctrl = '1' then --- SU
								case keyb_data is
									when x"3C" => sKdrg <= x"35" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- AR2/SU/U / GRAF
									when x"4D" => sKdrg <= x"36" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- AR2/SU/P / ZAP
									when x"21" => sKdrg <= x"37" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- AR2/SU/C / STIR
									when others => null;
								end case;
							else
								case keyb_data is
---extended									when x"0A" => sKdrg <= x"0C" after 1 ns; sKsrg(7) <= '1' after 1 ns;---F8
									when x"6B" => sKdrg <= x"08" after 1 ns; sKsrg(7) <= '1' after 1 ns;---<=
									when x"4C" => sKdrg <= x"42" after 1 ns; sKsrg(7) <= '1' after 1 ns;---:
---extended									when x"4C" => sKdrg <= x"43" after 1 ns; sKsrg(7) <= '1' after 1 ns;---;
									---
									when others => null;
								end case;
							end if;
						else
							int_vector <= o"060" after 1 ns;
							case keyb_data is
								when x"14" => sKdrg <= x"0F" after 1 ns; ruslat <= '0' after 1 ns; sKsrg(7) <= '1' after 1 ns; --- LAT
								when x"11" => sKdrg <= x"0E" after 1 ns; ruslat <= '1' after 1 ns; sKsrg(7) <= '1' after 1 ns; --- RUS
								when x"75" => sKdrg <= x"1A" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- ArrowUP
								when x"6B" => sKdrg <= x"08" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- ArrowLT
								when x"72" => sKdrg <= x"1B" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- ArrowDN
								when x"74" => sKdrg <= x"19" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- ArrowRT

								when x"71" => sKdrg <= x"75" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- Delete / GRAF
								when x"69" => sKdrg <= x"1E" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- End / ZAP
								when x"7A" => sKdrg <= x"1F" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- PD / STIR

								when x"6C" => sKdrg <= x"0D" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- Home / USTAB
								when x"7D" => sKdrg <= x"10" after 1 ns; sKsrg(7) <= '1' after 1 ns; --- PU / SBRTAB

								when others => null;
							end case;
						end if;
				else --- released = '1'
					released <= '0' after 1 ns;				
				end if;
			end if;
--		elsif keyb_error = '1' then
--			sKsrg(1) <= '1' after 1 ns;
		end if;
	end if;
end if;  
end process;

end;

