-------------------------------------------------------------------------------
--
-- Title       : bk1610vga
-- Design      : BK1610
-- Author      : Yefremoff Nick
-- Company     : Home
--
-------------------------------------------------------------------------------
--
-- File        : bk1610vga_640x480x60.vhd
-- Generated   : 2019
--
-------------------------------------------------------------------------------
--
-- Description : VGA controller (640x480) 60 fps. Data = 640(192+256+192)x480(112+256+112) pixels.
--
-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.std_logic_unsigned.all;

entity bk1610vga is
	 port(
		pres   : in std_logic; --- active high
		aclk   : in std_logic; --- 100 MHz
		bk1vdata: in std_logic_vector(15 downto 0); --- BK 2 port VRAM data
		bk3vdata: in std_logic_vector(15 downto 0); --- BK 2 port VRAM data
		bk5vdata: in std_logic_vector(15 downto 0); --- BK 2 port VRAM data
		border : in std_logic_vector(2 downto 0); --- colour of border
		icolor : in std_logic; --- White/Color
		isimd : in std_logic; --- Standard/SIMD
		ipalnum : in std_logic_vector(3 downto 0); --- <11:8> of port o177662
---		vgaport: in std_logic_vector(15 downto 0); --- vga port o177664
		bkvaddr: out std_logic_vector(15 downto 0); --- address of BK VRAM
		blank  : out std_logic; --- active high
		vgar   : out std_logic_vector(7 downto 0); --- R
		vgag   : out std_logic_vector(7 downto 0); --- G
		vgab   : out std_logic_vector(7 downto 0); --- B 
		vsync  : out std_logic; --- active low
		hsync  : out std_logic; --- active low

		clken : in STD_LOGIC;
		rd : in std_logic;
		wr : in std_logic;
		addr_match : out std_logic;
		base_addr : in std_logic_vector(17 downto 0); --- o177664
		addr  : in std_logic_vector(17 downto 0);
		din : in STD_LOGIC_VECTOR(15 downto 0);
		dout : out STD_LOGIC_VECTOR(15 downto 0);

		oInt   : out std_logic --- active high
		 );
end;

architecture beh of bk1610vga is
signal saddr : std_logic_vector(17 downto 0);
signal sd1addr : std_logic_vector(2 downto 0);
signal sd2addr : std_logic_vector(2 downto 0);
signal sd3addr : std_logic_vector(2 downto 0);
signal sd4addr : std_logic_vector(2 downto 0);
signal sd5addr : std_logic_vector(2 downto 0);
signal sd6addr : std_logic_vector(2 downto 0);
signal sd7addr : std_logic_vector(2 downto 0);
signal sd8addr : std_logic_vector(2 downto 0);
signal spix  : std_logic_vector(1 downto 0);
signal s1pixl : std_logic_vector(15 downto 0);
signal s3pixl : std_logic_vector(15 downto 0);
signal s5pixl : std_logic_vector(15 downto 0);
signal sdpixl : std_logic_vector(31 downto 0);
signal st2pixl : std_logic_vector(31 downto 0);
signal svgar : std_logic_vector(7 downto 0);
signal sdvgar : std_logic_vector(7 downto 0);
signal svgag : std_logic_vector(7 downto 0);
signal sdvgag : std_logic_vector(7 downto 0);
signal svgab : std_logic_vector(7 downto 0);
signal sdvgab : std_logic_vector(7 downto 0);
signal s512cnt : std_logic_vector(8 downto 0);
signal t4cnt : std_logic;
signal o12cnt,o14cnt,o52cnt : std_logic;
signal s793cnt : std_logic_vector(9 downto 0);
signal s525cnt : std_logic_vector(9 downto 0);
signal shsync,svsync : std_logic; --- синхроимпульсы
---signal slayeren : std_logic_vector(1 downto 0);
---signal sA : std_logic_vector(1 downto 0);
signal vB : std_logic;
signal base_addr_match : std_logic;
signal sRsm : std_logic_vector(15 downto 0);

--type ARR_TYPE is array(15 downto 0) of std_logic_vector(23 downto 0);
--signal sPAL: ARR_TYPE; --- палитра стандартных цветов
signal spalindx : std_logic_vector(7 downto 0);
signal spalette : std_logic_vector(23 downto 0);

begin
------------------------
--Цветной режим:
--
--cpu0|cpu1
--  00 00 - черный
--  00 01 - темносерый
--  00 10 - светлосерый
--  00 11 - белый
--
--  01 00 - темносиний
--  01 01 - яркосиний
--  01 10 - циановый
--  01 11 - пурпурный
--
--  10 00 - темнозеленый
--  10 01 - голубой
--  10 10 - яркозеленый
--  10 11 - коричневый
--
--  11 00 - темнокрасный
--  11 01 - фиолетовый
--  11 10 - желтый
--  11 11 - яркокрасный
--
--------------------------
--Чернобелый режим:
--
--cpu0|cpu1
--   0 0 - черный
--   0 1 - темносерый
--   1 0 - светлосерый
--   1 1 - белый

--- Standard Palette ----------------------------------
--mk_spalette:process (spalindx)
--begin
--	case spalindx is			--RGB888--
--		when "0000" => svgar <= x"00"; --- черный
--							svgag <= x"00"; --- черный
--							svgab <= x"00"; --- черный
--		when "0001" => svgar <= x"55"; --- темносерый
--							svgag <= x"55"; --- темносерый
--							svgab <= x"55"; --- темносерый
--		when "0010" => svgar <= x"AA"; --- светлосерый
--							svgag <= x"AA"; --- светлосерый
--							svgab <= x"AA"; --- светлосерый
--		when "0011" => svgar <= x"FF"; --- белый
--							svgag <= x"FF"; --- белый
--							svgab <= x"FF"; --- белый
--		when "0100" => svgar <= x"00"; --- темносиний
--							svgag <= x"00"; --- темносиний
--							svgab <= x"80"; --- темносиний
--		when "0101" => svgar <= x"00"; --- яркосиний
--							svgag <= x"00"; --- яркосиний
--							svgab <= x"FF"; --- яркосиний
--		when "0110" => svgar <= x"00"; --- циановый
--							svgag <= x"FF"; --- циановый
--							svgab <= x"FF"; --- циановый
--		when "0111" => svgar <= x"FF"; --- пурпурный
--							svgag <= x"00"; --- пурпурный
--							svgab <= x"FF"; --- пурпурный
--		when "1000" => svgar <= x"00"; --- темнозеленый
--							svgag <= x"80"; --- темнозеленый
--							svgab <= x"00"; --- темнозеленый
--		when "1001" => svgar <= x"00"; --- голубой
--							svgag <= x"80"; --- голубой
--							svgab <= x"FF"; --- голубой
--		when "1010" => svgar <= x"00"; --- яркозеленый
--							svgag <= x"FF"; --- яркозеленый
--							svgab <= x"00"; --- яркозеленый
--		when "1011" => svgar <= x"80"; --- коричневый
--							svgag <= x"40"; --- коричневый
--							svgab <= x"00"; --- коричневый
--		when "1100" => svgar <= x"80"; --- темнокрасный
--							svgag <= x"00"; --- темнокрасный
--							svgab <= x"00"; --- темнокрасный
--		when "1101" => svgar <= x"80"; --- фиолетовый
--							svgag <= x"00"; --- фиолетовый
--							svgab <= x"FF"; --- фиолетовый
--		when "1110" => svgar <= x"FF"; --- желтый
--							svgag <= x"FF"; --- желтый
--							svgab <= x"00"; --- желтый
--		when others => svgar <= x"FF"; --- яркокрасный
--							svgag <= x"00"; --- яркокрасный
--							svgab <= x"00"; --- яркокрасный
--	end case;
--end process;
--------------------------------------------------------
mk_spalette:process (spalindx)
begin
	case spalindx is
---BGR888:
		when x"00" => spalette <= x"000000"; --- черный
		when x"01" => spalette <= x"007FFF"; --- коричневый
		when x"02" => spalette <= x"FFFF00"; --- циановый
		when x"03" => spalette <= x"FFBF00"; --- голубой
		when x"04" => spalette <= x"7F0000"; --- темносиний
		when x"05" => spalette <= x"FF0000"; --- яркосиний
		when x"06" => spalette <= x"FF007F"; --- фиолетовый
		when x"07" => spalette <= x"FF00FF"; --- пурпурный
		when x"08" => spalette <= x"00FFFF"; --- желтый
		when x"09" => spalette <= x"00FF7F"; --- салатовый
		when x"0A" => spalette <= x"00FF00"; --- яркозеленый
		when x"0B" => spalette <= x"007F00"; --- темнозеленый
		when x"0C" => spalette <= x"00007F"; --- темнокрасный
		when x"0D" => spalette <= x"0000FF"; --- яркокрасный
		when x"0E" => spalette <= x"7F7F7F"; --- серый
		when x"0F" => spalette <= x"FFFFFF"; --- белый
		
		when x"10" => spalette <= x"0F000F"; --- MAGENTA
		when x"11" => spalette <= x"1F001F"; --- 
		when x"12" => spalette <= x"2F002F"; --- 
		when x"13" => spalette <= x"3F003F"; --- 
		when x"14" => spalette <= x"4F004F"; --- 
		when x"15" => spalette <= x"5F005F"; --- 
		when x"16" => spalette <= x"6F006F"; --- 
		when x"17" => spalette <= x"7F007F"; --- 
		when x"18" => spalette <= x"8F008F"; --- 
		when x"19" => spalette <= x"9F009F"; --- 
		when x"1A" => spalette <= x"AF00AF"; --- 
		when x"1B" => spalette <= x"BF00BF"; --- 
		when x"1C" => spalette <= x"CF00CF"; --- 
		when x"1D" => spalette <= x"DF00DF"; --- 
		when x"1E" => spalette <= x"EF00EF"; --- 
		when x"1F" => spalette <= x"FF00FF"; --- 
		
		when x"20" => spalette <= x"0F0F00"; --- CYAN
		when x"21" => spalette <= x"1F1F00"; --- 
		when x"22" => spalette <= x"2F2F00"; --- 
		when x"23" => spalette <= x"3F3F00"; --- 
		when x"24" => spalette <= x"4F4F00"; --- 
		when x"25" => spalette <= x"5F5F00"; --- 
		when x"26" => spalette <= x"6F6F00"; --- 
		when x"27" => spalette <= x"7F7F00"; --- 
		when x"28" => spalette <= x"8F8F00"; --- 
		when x"29" => spalette <= x"9F9F00"; --- 
		when x"2A" => spalette <= x"AFAF00"; --- 
		when x"2B" => spalette <= x"BFBF00"; --- 
		when x"2C" => spalette <= x"CFCF00"; --- 
		when x"2D" => spalette <= x"DFDF00"; --- 
		when x"2E" => spalette <= x"EFEF00"; --- 
		when x"2F" => spalette <= x"FFFF00"; --- 
		
		when x"30" => spalette <= x"00254B"; --- BROUN
		when x"31" => spalette <= x"002B57"; --- 
		when x"32" => spalette <= x"003263"; --- 
		when x"33" => spalette <= x"00376F"; --- 
		when x"34" => spalette <= x"003D7B"; --- 
		when x"35" => spalette <= x"004387"; --- 
		when x"36" => spalette <= x"004993"; --- 
		when x"37" => spalette <= x"004F9F"; --- 
		when x"38" => spalette <= x"0055AB"; --- 
		when x"39" => spalette <= x"005BB7"; --- 
		when x"3A" => spalette <= x"0061C3"; --- 
		when x"3B" => spalette <= x"0067CF"; --- 
		when x"3C" => spalette <= x"006DDB"; --- 
		when x"3D" => spalette <= x"0073E7"; --- 
		when x"3E" => spalette <= x"0079F3"; --- 
		when x"3F" => spalette <= x"007FFF"; --- 
		
		when x"40" => spalette <= x"874700"; --- SKY
		when x"41" => spalette <= x"8F4F00"; --- 
		when x"42" => spalette <= x"975700"; --- 
		when x"43" => spalette <= x"9F5F00"; --- 
		when x"44" => spalette <= x"A76700"; --- 
		when x"45" => spalette <= x"AF6F00"; --- 
		when x"46" => spalette <= x"B77700"; --- 
		when x"47" => spalette <= x"BF7F00"; --- 
		when x"48" => spalette <= x"C78700"; --- 
		when x"49" => spalette <= x"CF8F00"; --- 
		when x"4A" => spalette <= x"D79700"; --- 
		when x"4B" => spalette <= x"DF9F00"; --- 
		when x"4C" => spalette <= x"E7A700"; --- 
		when x"4D" => spalette <= x"EFAF00"; --- 
		when x"4E" => spalette <= x"F7B700"; --- 
		when x"4F" => spalette <= x"FFBF00"; --- 
		
		when x"50" => spalette <= x"0F0000"; --- BLUE
		when x"51" => spalette <= x"1F0000";
		when x"52" => spalette <= x"2F0000";
		when x"53" => spalette <= x"3F0000";
		when x"54" => spalette <= x"4F0000";
		when x"55" => spalette <= x"5F0000"; --- 
		when x"56" => spalette <= x"6F0000";
		when x"57" => spalette <= x"7F0000";
		when x"58" => spalette <= x"8F0000";
		when x"59" => spalette <= x"9F0000";
		when x"5A" => spalette <= x"AF0000"; --- 
		when x"5B" => spalette <= x"BF0000";
		when x"5C" => spalette <= x"CF0000";
		when x"5D" => spalette <= x"DF0000";
		when x"5E" => spalette <= x"EF0000";
		when x"5F" => spalette <= x"FF0000"; --- 
		
		when x"60" => spalette <= x"000000"; --- R-G
		when x"61" => spalette <= x"000024"; --- 
		when x"62" => spalette <= x"000048"; --- 
		when x"63" => spalette <= x"00006C"; --- 
		when x"64" => spalette <= x"002490";
		when x"65" => spalette <= x"0024B4"; --- 
		when x"66" => spalette <= x"0024D8";
		when x"67" => spalette <= x"0024FF";
		when x"68" => spalette <= x"004800";
		when x"69" => spalette <= x"004824";
		when x"6A" => spalette <= x"004848"; --- 
		when x"6B" => spalette <= x"00486C";
		when x"6C" => spalette <= x"006C90"; --- 
		when x"6D" => spalette <= x"006CB4";
		when x"6E" => spalette <= x"006CD8";
		when x"6F" => spalette <= x"006CFF"; --- 
		
		when x"70" => spalette <= x"009000"; --- R-G
		when x"71" => spalette <= x"009024"; --- 
		when x"72" => spalette <= x"009048"; --- 
		when x"73" => spalette <= x"00906C"; --- 
		when x"74" => spalette <= x"00B490"; --- 
		when x"75" => spalette <= x"00B4B4"; --- 
		when x"76" => spalette <= x"00B4D8"; --- 
		when x"77" => spalette <= x"00B4FF"; --- 
		when x"78" => spalette <= x"00D800"; --- 
		when x"79" => spalette <= x"00D824"; --- 
		when x"7A" => spalette <= x"00D848"; --- 
		when x"7B" => spalette <= x"00D86C"; --- 
		when x"7C" => spalette <= x"00FF90"; --- 
		when x"7D" => spalette <= x"00FFB4"; --- 
		when x"7E" => spalette <= x"00FFD8"; --- 
		when x"7F" => spalette <= x"00FFFF"; --- 
		
		when x"80" => spalette <= x"550000"; --- R-G
		when x"81" => spalette <= x"550024"; --- 
		when x"82" => spalette <= x"550048"; --- 
		when x"83" => spalette <= x"55006C"; --- 
		when x"84" => spalette <= x"552490"; --- 
		when x"85" => spalette <= x"5524B4"; --- 
		when x"86" => spalette <= x"5524D8"; --- 
		when x"87" => spalette <= x"5524FF"; --- 
		when x"88" => spalette <= x"554800"; --- 
		when x"89" => spalette <= x"554824"; --- 
		when x"8A" => spalette <= x"554848"; --- 
		when x"8B" => spalette <= x"55486C"; --- 
		when x"8C" => spalette <= x"556C90"; --- 
		when x"8D" => spalette <= x"556CB4"; --- 
		when x"8E" => spalette <= x"556CD8"; --- 
		when x"8F" => spalette <= x"556CFF"; --- 
		
		when x"90" => spalette <= x"559000"; --- R-G
		when x"91" => spalette <= x"559024"; --- 
		when x"92" => spalette <= x"559048"; --- 
		when x"93" => spalette <= x"55906C"; --- 
		when x"94" => spalette <= x"55B490"; --- 
		when x"95" => spalette <= x"55B4B4"; --- 
		when x"96" => spalette <= x"55B4D8"; --- 
		when x"97" => spalette <= x"55B4FF"; --- 
		when x"98" => spalette <= x"55D800"; --- 
		when x"99" => spalette <= x"55D824"; --- 
		when x"9A" => spalette <= x"55D848"; --- 
		when x"9B" => spalette <= x"55D86C"; --- 
		when x"9C" => spalette <= x"55FF90"; --- 
		when x"9D" => spalette <= x"55FFB4"; --- 
		when x"9E" => spalette <= x"55FFD8"; --- 
		when x"9F" => spalette <= x"55FFFF"; --- 
		
		when x"A0" => spalette <= x"000F00"; --- GREEN
		when x"A1" => spalette <= x"001F00"; --- 
		when x"A2" => spalette <= x"002F00"; --- 
		when x"A3" => spalette <= x"003F00"; --- 
		when x"A4" => spalette <= x"004F00"; --- 
		when x"A5" => spalette <= x"005F00"; --- 
		when x"A6" => spalette <= x"006F00"; --- 
		when x"A7" => spalette <= x"007F00"; --- 
		when x"A8" => spalette <= x"008F00"; --- 
		when x"A9" => spalette <= x"009F00"; --- 
		when x"AA" => spalette <= x"00AF00"; --- 
		when x"AB" => spalette <= x"00BF00"; --- 
		when x"AC" => spalette <= x"00CF00"; --- 
		when x"AD" => spalette <= x"00DF00"; --- 
		when x"AE" => spalette <= x"00EF00"; --- 
		when x"AF" => spalette <= x"00FF00"; --- 
		
		when x"B0" => spalette <= x"AA0000"; --- R-B
		when x"B1" => spalette <= x"AA0024"; --- 
		when x"B2" => spalette <= x"AA0048"; --- 
		when x"B3" => spalette <= x"AA006C"; --- 
		when x"B4" => spalette <= x"AA2490"; --- 
		when x"B5" => spalette <= x"AA24B4"; --- 
		when x"B6" => spalette <= x"AA24AA"; --- 
		when x"B7" => spalette <= x"AA24FF"; --- 
		when x"B8" => spalette <= x"AA4800"; --- 
		when x"B9" => spalette <= x"AA4824"; --- 
		when x"BA" => spalette <= x"AA4848"; --- 
		when x"BB" => spalette <= x"AA486C"; --- 
		when x"BC" => spalette <= x"AA6C90"; --- 
		when x"BD" => spalette <= x"AA6CB4"; --- 
		when x"BE" => spalette <= x"AA6CAA"; --- 
		when x"BF" => spalette <= x"AA6CFF"; --- 
		
		when x"C0" => spalette <= x"AA9000"; --- R-B
		when x"C1" => spalette <= x"AA9024"; --- 
		when x"C2" => spalette <= x"AA9048"; --- 
		when x"C3" => spalette <= x"AA906C"; --- 
		when x"C4" => spalette <= x"AAB490"; --- 
		when x"C5" => spalette <= x"AAB4B4"; --- 
		when x"C6" => spalette <= x"AAB4AA"; --- 
		when x"C7" => spalette <= x"AAB4FF"; --- 
		when x"C8" => spalette <= x"AAD800"; --- 
		when x"C9" => spalette <= x"AAD824"; --- 
		when x"CA" => spalette <= x"AAD848"; --- 
		when x"CB" => spalette <= x"AAD86C";
		when x"CC" => spalette <= x"AAFF90";
		when x"CD" => spalette <= x"AAFFB4";
		when x"CE" => spalette <= x"AAFFAA"; --- 
		when x"CF" => spalette <= x"AAFFFF"; --- 
		
		when x"D0" => spalette <= x"FF0000"; --- R-B
		when x"D1" => spalette <= x"FF0024"; --- 
		when x"D2" => spalette <= x"FF0048"; --- 
		when x"D3" => spalette <= x"FF006C"; --- 
		when x"D4" => spalette <= x"FF2490"; --- 
		when x"D5" => spalette <= x"FF24B4"; --- 
		when x"D6" => spalette <= x"FF24D8"; --- 
		when x"D7" => spalette <= x"FF24FF"; --- 
		when x"D8" => spalette <= x"FF4800"; --- 
		when x"D9" => spalette <= x"FF4824"; --- 
		when x"DA" => spalette <= x"FF4848"; --- 
		when x"DB" => spalette <= x"FF486C"; --- 
		when x"DC" => spalette <= x"FF6C90"; --- 
		when x"DD" => spalette <= x"FF6CB4"; --- 
		when x"DE" => spalette <= x"FF6CD8"; --- 
		when x"DF" => spalette <= x"FF6CFF"; --- 
		
		when x"E0" => spalette <= x"FF9000"; --- R-B
		when x"E1" => spalette <= x"FF9024"; --- 
		when x"E2" => spalette <= x"FF9048"; --- 
		when x"E3" => spalette <= x"906CFF"; --- 
		when x"E4" => spalette <= x"FFB490"; --- 
		when x"E5" => spalette <= x"FFB4B4"; --- 
		when x"E6" => spalette <= x"FFB4D8";
		when x"E7" => spalette <= x"FFB4FF";
		when x"E8" => spalette <= x"FFD800";
		when x"E9" => spalette <= x"FFD824"; --- 
		when x"EA" => spalette <= x"FFD848"; --- 
		when x"EB" => spalette <= x"FFD86C";
		when x"EC" => spalette <= x"FFFF90";
		when x"ED" => spalette <= x"FFFFB4";
		when x"EE" => spalette <= x"FFFFD8";
		when x"EF" => spalette <= x"FFFFFF"; --- 

		when x"F0" => spalette <= x"00000F"; --- RED 
		when x"F1" => spalette <= x"00001F"; --- 
		when x"F2" => spalette <= x"00002F"; --- 
		when x"F3" => spalette <= x"00003F"; --- 
		when x"F4" => spalette <= x"00004F"; --- 
		when x"F5" => spalette <= x"00005F"; --- 
		when x"F6" => spalette <= x"00006F";
		when x"F7" => spalette <= x"00007F";
		when x"F8" => spalette <= x"00008F";
		when x"F9" => spalette <= x"00009F"; --- 
		when x"FA" => spalette <= x"0000AF"; --- 
		when x"FB" => spalette <= x"0000BF";
		when x"FC" => spalette <= x"0000CF";
		when x"FD" => spalette <= x"0000DF";
		when x"FE" => spalette <= x"0000EF";
		when others => spalette <= x"0000FF"; --- 
	end case;
end process;
svgab <= spalette(23 downto 16);
svgag <= spalette(15 downto 8);
svgar <= spalette(7 downto 0);
---------------------------------------------------------------
		
vgar <= sdvgar;
vgag <= sdvgag;
vgab <= sdvgab;
hsync <= shsync;
vsync <= svsync;
oInt <= not svsync;

base_addr_match <= '1' when base_addr(17 downto 0) = addr(17 downto 0) else '0';
addr_match <= base_addr_match;

dout <= sRsm when (base_addr_match = '1' and rd = '1') --- o177664
	else x"0000";
		
process (pres,aclk,clken,base_addr_match,wr)
begin
	if pres = '1' then
		sRsm <= x"02D8" after 1 ns; --- o"1330"
	elsif (aclk = '1' and aclk'event) then
		if clken = '1' then
			if base_addr_match = '1' and wr = '1' then
				sRsm <= din after 1 ns;
			end if;
		end if;
	end if;
end process;

mk_sync:process (pres,aclk)
begin
	if pres = '1' then
		s793cnt <= "1100011000" after 1 ns; ---792
		s525cnt <= "1000001100" after 1 ns; ---524
		shsync <= '1' after 1 ns;
		svsync <= '1' after 1 ns;
		s512cnt <= "000000000" after 1 ns;
		t4cnt <= '0' after 1 ns;
		o12cnt <= '0' after 1 ns;
		o14cnt <= '0' after 1 ns;
		o52cnt <= '0' after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		s512cnt <= s512cnt + "000000001" after 1 ns;
		if (s512cnt(4 downto 0) = "00001") then
			o12cnt <= '1' after 1 ns;
		else o12cnt <= '0' after 1 ns;
		end if;
		if (s512cnt(4 downto 0) = "00011") then
			o14cnt <= '1' after 1 ns;
		else o14cnt <= '0' after 1 ns;
		end if;
		if (s512cnt(4 downto 0) = "11111") then
			o52cnt <= '1' after 1 ns;
		else o52cnt <= '0' after 1 ns;
		end if;
		if (s512cnt(1 downto 0) = "00") then
			t4cnt <= '1' after 1 ns;
		else t4cnt <= '0' after 1 ns;
		end if;
		if t4cnt = '1' then
			if s793cnt = "0000001100" then ---12
				shsync <= '0' after 1 ns;
			elsif s793cnt = "0001101010" then ---106
				shsync <= '1' after 1 ns;
			end if;
			if s793cnt = "1100011000" then ---792
				s512cnt <= "000000000" after 1 ns;
				s793cnt <= "0000000000" after 1 ns;
				if s525cnt = "1000001100" then ---524
					s525cnt <= "0000000000" after 1 ns;
				else
					s525cnt <= s525cnt + "1" after 1 ns;
				end if;
			else s793cnt <= s793cnt + "1" after 1 ns;
			end if;
			if s793cnt = "0000001100" then ---12
				if s525cnt = "0000000000" then ---0
					svsync <= '0' after 1 ns;
				elsif s525cnt = "0000000010" then ---2
					svsync <= '1' after 1 ns;
				end if;
			end if;
		end if;
	end if;
end process;

mk_sd2addr:process (pres,saddr,aclk,t4cnt)
begin
	if pres = '1' then
		sd1addr <= "000" after 1 ns;
		sd2addr <= "000" after 1 ns;
		sd3addr <= "000" after 1 ns;
		sd4addr <= "000" after 1 ns;
		sd5addr <= "000" after 1 ns;
		sd6addr <= "000" after 1 ns;
		sd7addr <= "000" after 1 ns;
		sd8addr <= "000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t4cnt = '1' then
			sd1addr <= saddr(2 downto 0) after 1 ns;
			sd2addr <= sd1addr after 1 ns;
			sd3addr <= sd2addr after 1 ns;
			sd4addr <= sd3addr after 1 ns;
			sd5addr <= sd4addr after 1 ns;
			sd6addr <= sd5addr after 1 ns;
			sd7addr <= sd6addr after 1 ns;
			sd8addr <= sd7addr after 1 ns;
		end if;
	end if;
end process;

mk_st2pixl:process (pres,aclk,t4cnt,sdpixl)
begin
	if pres = '1' then
		st2pixl <= x"00000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t4cnt = '1' then
			st2pixl <= sdpixl after 1 ns;
		end if;
	end if;
end process;

mk_spix:process (sd8addr,st2pixl,icolor,isimd)
begin
if isimd = '0' then --- (F10)
	if icolor = '0' then --- (F11) --- 512x256
		case sd8addr(2 downto 0) is
			when "000" =>
				if st2pixl(3 downto 0) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when "001" =>
				if st2pixl(7 downto 4) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when "010" =>
				if st2pixl(11 downto 8) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when "011" =>
				if st2pixl(15 downto 9) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when "100" =>
				if st2pixl(19 downto 16) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when "101" =>
				if st2pixl(23 downto 20) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when "110" =>
				if st2pixl(27 downto 24) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
			when others =>
				if st2pixl(31 downto 28) = "0000" then
					spalindx <= "00000000";
				else
					spalindx <= "00001111";
				end if;
		end case;
	else --- icolor = '1' (F11) --- 256x256
		case sd8addr(2 downto 0) is
			when "000" | "001" =>
				if (st2pixl(3) and st2pixl(7)) = '1' then
					spalindx <= "00001101";
				else
---					spalindx <= "0000" & st2pixl(3) & st2pixl(7) & st2pixl(3) & st2pixl(7);
					spalindx <= "0000" & st2pixl(7) & st2pixl(3) & st2pixl(7) & st2pixl(3);
				end if;
			when "010" | "011" =>
				if (st2pixl(11) and st2pixl(15)) = '1' then
					spalindx <= "00001101";
				else
---					spalindx <= "0000" & st2pixl(11) & st2pixl(15) & st2pixl(11) & st2pixl(15);
					spalindx <= "0000" & st2pixl(15) & st2pixl(11) & st2pixl(15) & st2pixl(11);
				end if;
			when "100" | "101" =>
				if (st2pixl(19) and st2pixl(23)) = '1' then
					spalindx <= "00001101";
				else
---					spalindx <= "0000" & st2pixl(19) & st2pixl(23) & st2pixl(19) & st2pixl(23);
					spalindx <= "0000" & st2pixl(23) & st2pixl(19) & st2pixl(23) & st2pixl(19);
				end if;
			when others =>
				if (st2pixl(27) and st2pixl(31)) = '1' then
					spalindx <= "00001101";
				else
---					spalindx <= "0000" & st2pixl(27) & st2pixl(31) & st2pixl(27) & st2pixl(31);
					spalindx <= "0000" & st2pixl(31) & st2pixl(27) & st2pixl(31) & st2pixl(27);
				end if;
		end case;
	end if;
else --- isimd = '1' (F10)
	if icolor = '0' then --- 512x256
		case sd8addr(2 downto 0) is
			when "000" => spalindx <= "0000" & st2pixl(3) & st2pixl(2) & st2pixl(1) & st2pixl(0);
			when "001" => spalindx <= "0000" & st2pixl(7) & st2pixl(6) & st2pixl(5) & st2pixl(4);
			when "010" => spalindx <= "0000" & st2pixl(11) & st2pixl(10) & st2pixl(9) & st2pixl(8);
			when "011" => spalindx <= "0000" & st2pixl(15) & st2pixl(14) & st2pixl(13) & st2pixl(12);
			when "100" => spalindx <= "0000" & st2pixl(19) & st2pixl(18) & st2pixl(17) & st2pixl(16);
			when "101" => spalindx <= "0000" & st2pixl(23) & st2pixl(22) & st2pixl(21) & st2pixl(20);
			when "110" => spalindx <= "0000" & st2pixl(27) & st2pixl(26) & st2pixl(25) & st2pixl(24);
			when others => spalindx <= "0000" & st2pixl(31) & st2pixl(30) & st2pixl(29) & st2pixl(28);
		end case;
	else --- icolor = '1' (F11) --- 256x256
		case sd8addr(2 downto 0) is
			when "000" | "001" =>
---				spalindx <= st2pixl(3) & st2pixl(7) & st2pixl(2) & st2pixl(6) & st2pixl(1) & st2pixl(5) & st2pixl(0) & st2pixl(4);
				spalindx <= st2pixl(7) & st2pixl(3) & st2pixl(6) & st2pixl(2) & st2pixl(5) & st2pixl(1) & st2pixl(4) & st2pixl(0);
			when "010" | "011" =>
---				spalindx <= st2pixl(11) & st2pixl(15) & st2pixl(10) & st2pixl(14) & st2pixl(9) & st2pixl(13) & st2pixl(8) & st2pixl(12);
				spalindx <= st2pixl(15) & st2pixl(11) & st2pixl(14) & st2pixl(10) & st2pixl(13) & st2pixl(9) & st2pixl(12) & st2pixl(8);
			when "100" | "101" =>
---				spalindx <= st2pixl(19) & st2pixl(23) & st2pixl(18) & st2pixl(22) & st2pixl(17) & st2pixl(21) & st2pixl(16) & st2pixl(20);
				spalindx <= st2pixl(23) & st2pixl(19) & st2pixl(22) & st2pixl(18) & st2pixl(21) & st2pixl(17) & st2pixl(20) & st2pixl(16);
			when others =>
---				spalindx <= st2pixl(27) & st2pixl(31) & st2pixl(26) & st2pixl(30) & st2pixl(25) & st2pixl(29) & st2pixl(24) & st2pixl(28);
				spalindx <= st2pixl(31) & st2pixl(27) & st2pixl(30) & st2pixl(26) & st2pixl(29) & st2pixl(25) & st2pixl(28) & st2pixl(24);
		end case;
	end if;
end if;
end process;

mk_paddr:process (pres,aclk,o12cnt,o14cnt,o52cnt,s793cnt,s525cnt,saddr,sRsm,bk1vdata,bk3vdata,bk5vdata)
---variable vB: std_logic;
begin
	if pres = '1' then
		vB    	<= '1' after 1 ns;
		s1pixl   <= x"0000" after 1 ns;
		s3pixl   <= x"0000" after 1 ns;
		s5pixl   <= x"0000" after 1 ns;
		sdpixl   <= x"00000000" after 1 ns;
		bkvaddr  <= "0000000000000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if (s525cnt > "0010010010") and (s525cnt < "0110010011") then --- > 146 and < 403
			if s793cnt > "0011010000" and s793cnt < "1011010001" then --- > 208 and < 721
				if o12cnt = '1' then
					bkvaddr <= "000" & (saddr(16 downto 4) + ((sRsm(7 downto 0) - x"D8") & "00000")) after 1 ns;
					vB <= saddr(3) after 1 ns;
				elsif o14cnt = '1' then
					s1pixl <= bk1vdata after 1 ns;
					s3pixl <= bk3vdata after 1 ns;
					s5pixl <= bk5vdata after 1 ns;
				elsif o52cnt = '1' then
---					sdpixl <= s1pixl after 1 ns;
					if vB = '0' then
						sdpixl(3 downto 0) <= s1pixl(0) & s3pixl(0) & s5pixl(0) & s3pixl(0) after 1 ns;
						sdpixl(7 downto 4) <= s1pixl(1) & s3pixl(1) & s5pixl(1) & s3pixl(1) after 1 ns;
						sdpixl(11 downto 8) <= s1pixl(2) & s3pixl(2) & s5pixl(2) & s3pixl(2) after 1 ns;
						sdpixl(15 downto 12) <= s1pixl(3) & s3pixl(3) & s5pixl(3) & s3pixl(3) after 1 ns;
						sdpixl(19 downto 16) <= s1pixl(4) & s3pixl(4) & s5pixl(4) & s3pixl(4) after 1 ns;
						sdpixl(23 downto 20) <= s1pixl(5) & s3pixl(5) & s5pixl(5) & s3pixl(5) after 1 ns;
						sdpixl(27 downto 24) <= s1pixl(6) & s3pixl(6) & s5pixl(6) & s3pixl(6) after 1 ns;
						sdpixl(31 downto 28) <= s1pixl(7) & s3pixl(7) & s5pixl(7) & s3pixl(7) after 1 ns;
					else
						sdpixl(3 downto 0) <= s1pixl(8) & s3pixl(8) & s5pixl(8) & s3pixl(8) after 1 ns;
						sdpixl(7 downto 4) <= s1pixl(9) & s3pixl(9) & s5pixl(9) & s3pixl(9) after 1 ns;
						sdpixl(11 downto 8) <= s1pixl(10) & s3pixl(10) & s5pixl(10) & s3pixl(10) after 1 ns;
						sdpixl(15 downto 12) <= s1pixl(11) & s3pixl(11) & s5pixl(11) & s3pixl(11) after 1 ns;
						sdpixl(19 downto 16) <= s1pixl(12) & s3pixl(12) & s5pixl(12) & s3pixl(12) after 1 ns;
						sdpixl(23 downto 20) <= s1pixl(13) & s3pixl(13) & s5pixl(13) & s3pixl(13) after 1 ns;
						sdpixl(27 downto 24) <= s1pixl(14) & s3pixl(14) & s5pixl(14) & s3pixl(14) after 1 ns;
						sdpixl(31 downto 28) <= s1pixl(15) & s3pixl(15) & s5pixl(15) & s3pixl(15) after 1 ns;
					end if;
				end if;
			end if;
		end if;
	end if;
end process;

mk_saddr:process (pres,aclk,t4cnt,s525cnt,s793cnt)
begin
	if pres = '1' then
		saddr <= "000000000000000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t4cnt = '1' then
			if s793cnt = "0000001100" and s525cnt = "0000000000" then --- =12 and =0
				saddr <= "000000000000000000" after 1 ns;
			elsif (s525cnt > "0010010010") and (s525cnt < "0110010011") then --- > 146 and < 403
				if s793cnt > "0011010000" and s793cnt < "1011010001" then --- > 208 and < 721
					saddr <= saddr + "1" after 1 ns;
				end if;
			end if;
		end if;
	end if;
end process;

mk_blank:process (pres,aclk,t4cnt,s525cnt,s793cnt)
begin
	if pres = '1' then
		blank <= '1' after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t4cnt = '1' then
			if s525cnt < "1000000011" and s525cnt > "0000100010" then --- < 515 and > 34
				if s793cnt > "0010010100" and s793cnt < "1100011000" then --- > 148 and < 792
					blank <= '0' after 1 ns;
				else
					blank <= '1' after 1 ns;
				end if;
			else
				blank <= '1' after 1 ns;
			end if;
		end if;
	end if;
end process;

mk_svga:process (pres,aclk,t4cnt,s525cnt,s793cnt,svgag,svgab,svgar)
begin
	if pres = '1' then
		sdvgar <= x"00" after 1 ns;
		sdvgag <= x"00" after 1 ns;
		sdvgab <= x"00" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t4cnt = '1' then
			if (s525cnt > "0010010010") and (s525cnt < "0110010011") then --- > 146 and < 403
				if s793cnt > "0011011000" and s793cnt < "1011011001" then --- > 216 and < 729
					sdvgar <= svgar(7) & svgar(6) & svgar(5) & svgar(4) & svgar(3) & svgar(2) & svgar(1) & svgar(0) after 1 ns;
					sdvgag <= svgag(7) & svgag(6) & svgag(5) & svgag(4) & svgag(3) & svgag(2) & svgag(1) & svgag(0) after 1 ns;
					sdvgab <= svgab(7) & svgab(6) & svgab(5) & svgab(4) & svgab(3) & svgab(2) & svgab(1) & svgab(0) after 1 ns;
				else
					sdvgag <= border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) after 1 ns;
					sdvgab <= border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) after 1 ns;
					sdvgar <= border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) after 1 ns;
				end if;
			else
				sdvgag <= border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) after 1 ns;
				sdvgab <= border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) after 1 ns;
				sdvgar <= border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) after 1 ns;
			end if;
		end if;
	end if;
end process;

end;
