#include <string>

//////////////////////////////////
typedef unsigned char        byte;
typedef unsigned short       word;
typedef unsigned long       dword;
typedef unsigned long long  qword;
//////////////////////////////////


const int MAX_SHORT_PACKET_SIZE = 10;


std::string  sPacketBuf;

std::string  sPhase;
std::string  sCmd_READ_RAW_Phase;
std::string  sCmd_READ_PACKED_STREAM_Phase;
std::string  sCmd_SIZE_Phase;
std::string  sCmd_WRITE_RAW_Phase;


word   uPacketSize;
word   uCheckSumm;
word   uCheckedSumm;

	
byte   uUnit;
dword  uBlock;
word   uByteCount;
word   uByteCnt;



void ByteReceiver( PVOID pData )
{
	byte ch = (byte)pData;

	if( !sPhase.size()  )
	{
		if( 01 == ch ) 
		{//  .   -  .
			sPhase = "SOH";
			sPacketBuf += ch;
			return;
		}

		TTY_OutputSocket.Send( pData );
		return;
	}
	
	if( "SOH" == sPhase  )
	{//   -  .
		sPacketBuf += ch;

		if( 0375 == ch ) 
		{//  
			sPhase = "#"; 
			return;
		}
		if( 0376 == ch ) 
		{//  
			sPhase = "$";
			return;
		}

		//    -   SOH   .
		TTY_OutputSocket.SendByte( 01 );
		TTY_OutputSocket.Send(   pData   );

		sPhase.clear();
		sPacketBuf.clear();
		return;
	}
	
	if( "#" == sPhase )
	{//  .   -     (    ).
		uPacketSize = ch;
		sPacketBuf += ch;
		uCheckedSumm = 0;

		if( !uPacketSize )
		{//    == 0 -   1
			sPhase.clear();
			sPacketBuf.clear();
			return;
		}
		
		if( uPacketSize > MAX_SHORT_PACKET_SIZE )
		{
			//  .
			sPhase = "X";
			return;
		}
		
		sPhase = "#L";
		return;
	}

	if( "$" == sPhase )
	{//  .   -       (    ).
		uPacketSize = ch;

		sPacketBuf += ch;
		uCheckedSumm = 0;
		sPhase = "$L";
		return;
	}
	
	if( "$L" == sPhase )
	{//  .   -       (    ).
		uPacketSize |= word(ch)<<8;
		sPacketBuf += ch;

		if( !uPacketSize )
		{//    == 0 -   2 -   1.
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   = 0.

			sPhase.clear();
			sPacketBuf.clear();
			return;
		}
		sPhase = "$LL";
		return;
	}
	
	if( "#L" == sPhase || "$LL" == sPhase )
	{//    ,  .   -  .
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		//  -     (  ).

		if( !(--uPacketSize) ) 
		{ //  .    .
			sPhase = "XX";
			return;
		}

		//  -    .

		if( 'C' == ch ) 
		{// C - 
			sPhase += ch; 
			return; 
		} 
		//   
		sPhase = "X";
		return;
	}
	
	if( "#LC" == sPhase )
	{//    .   - .
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		//  -      (  ).
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sPhase = "XX";
			return;
		}

		//  -     .

		if( 'R' == ch )
		{// : R == "READ_RAW -   ".
			sPhase = "#LCR";
			return;
		}
		
		if( 'r'  == ch )
		{// : r == "READ_PACKED_STREAM -   ".
			sPhase = "#LCr";
			return;
		}

		if( 's' == ch )
		{// : s == " ".
			sPhase = "#LCs";
			return;
		}

		//  .
		sPhase = "X";
		return;
	}
	
	if( "#LCR" == sPhase )
	{	
		return Cmd_READ_RAW( ch );
	}

	if( "#LCr" == sPhase )
	{//   . 

		//     == 7 -    ,    -  .
		
		if( 7 == uPacketSize )
		{//      -      1.       .
			sPhase = "#LCr1"; 
			goto LCr1;
		}

		sPacketBuf   += ch;
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sPhase = "XX";
			return;
		}

		if( 01 == ch )
		{//   == 1 - .
			sPhase = "#LCr1"; 
			return;
		}

		sPhase = "#LCr0";  //    .
		return;
	}
	
LCr1:
	if( "#LCr1" == sPhase )
	{//    -   .
		if( St_PackData )
		{
			return Cmd_READ_PACKED_STREAM( ch );
		}
		else
		{
			return Cmd_READ_RAW( ch );
		}
	}
	
	if( "#LCr0" == sPhase )
	{//    -    .
		return Cmd_READ_RAW( ch );
	}
	
	if( "#LCs" == sPhase )
	{	
		return Cmd_SIZE( ch );
	}

	if( "$LLC" == sPhase )
	{//    .   - .
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		//  -      (  ).
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sPhase = "XX";
			return;
		}
		
		//  -     .

		if( 'W' == ch )
		{// : R == "WRITE_RAW -   ".
			sPhase = "$LLCW";
			return;
		}
		
		//  .
		sPhase = "X";
		return;
	}	


	if( "$LLCW" == sPhase )
	{	
		return Cmd_WRITE_RAW( ch );
	}
	
	
	if( "X" == sPhase )
	{//  .
		char str[256];
		sprintf(str, LNG("HX: Bad Packet: Superfluous byte: %03o\n"), ch );
		Log( str );
	
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) { sPhase = "XX"; } //    .
		return;
	}
	
	if( "XX" == sPhase )
	{//  .   -    .
		Log( LNG("HX: Bad Packet: Wrong packet size !!!\n") );

		sPacketBuf += ch;

		uCheckSumm = ch;
		sPhase = "XXs";
		return;
	}
	
	if( "XXs" == sPhase )
	{//  .   -    .
		uCheckSumm |= word(ch)<<8;
		sPacketBuf += ch;
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			Log( LNG("HX: Bad Packet: CheckSum OK\n") );
			
			word ChSum = 0;
			byte ch;
		
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  2   ); //  .

			ch = 'R';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //   - .

			ch = 'N';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //  - NOT SUPPORTED !!!.
			
			ch = ChSum >> 8;
			ByteOutputSocket.SendByte(  ch  ); //    .

			ch = ChSum;
			ByteOutputSocket.SendByte(  ch  ); //    .
		}
		else
		{//      .
			Log( LNG("HX: Bad Packet: CheckSum ERROR\n") );
			//   -      .
			for( int nSize = sPacketBuf.size(), i = 0 ; i < nSize ; i++ )
			{
				TTY_OutputSocket.SendByte( sPacketBuf[i] );
			}
		}
		
		sPhase.clear();
		sPacketBuf.clear();
		return;
	}

	sPhase.clear();
	sPacketBuf.clear();	
}


void HX_tool::Cmd_READ_RAW( byte ch )
{
	sPacketBuf += ch;

	if( !sCmd_READ_RAW_Phase.size() )
	{//  "  ".   -  .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uUnit = ch;
		sCmd_READ_RAW_Phase = "U";
		return;
	}
	
	if( "U" == sCmd_READ_RAW_Phase )
	{//   - 1-   .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock = ch;
		
		sCmd_READ_RAW_Phase = "UB";
		return;
	}
	
	if( "UB" == sCmd_READ_RAW_Phase )
	{//   - 2-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= word(ch)<<8;
		
		sCmd_READ_RAW_Phase = "UBB";
		return;
	}
	
	if( "UBB" == sCmd_READ_RAW_Phase )
	{//   - 3-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= dword(ch)<<16;
		
		sCmd_READ_RAW_Phase = "UBBB";
		return;
	}
	
	if( "UBBB" == sCmd_READ_RAW_Phase )
	{//   - 4-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= dword(ch)<<24;
		
		sCmd_READ_RAW_Phase = "UBBBB";
		return;
	}
	
	if( "UBBBB" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uByteCount = ch;
		
		sCmd_READ_RAW_Phase = "UBBBBW";
		return;
	}
	
	if( "UBBBBW" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		uByteCount |= word(ch)<<8;

		if( !(--uPacketSize) ) 
		{//   .    .

			sCmd_READ_RAW_Phase = "UBBBBWW"; 
			return; 
		}

		//  .
		sCmd_READ_RAW_Phase.clear();
		sPhase = "X";
		return;
	}

	if( "UBBBBWW" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckSumm = ch;
		
		sCmd_READ_RAW_Phase = "UBBBBWWs";
		return;
	}

	if( "UBBBBWWs" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckSumm |= word(ch)<<8;

		sCmd_READ_RAW_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();		
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			Cmd_READ_RAW_Execute();  //       .
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}

		return;
	}

	sCmd_READ_RAW_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}


void HX_tool::Cmd_READ_RAW_Execute()
{
	char str[512];
	sprintf(str, LNG("HX: READ :  Unit: %u  |  Block:%7u  |  ByteCount: %5u  "), uUnit, uBlock, uByteCount );
	Log(str);
	
	word ChSum = 0;
	byte ch;

	dword uDSK_Blocks = DSK_Rec[uUnit].uDSK_Blocks;

	if( uBlock >= uDSK_Blocks )
	{//     .   EOF.
		Log( LNG("-- EOF\n") );

		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .

		ch = 'R';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //   - .

		ch = 'F';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //  -  .
		
		ch = ChSum;
		ByteOutputSocket.SendByte(  ch  ); //    .

		ch = ChSum >> 8;
		ByteOutputSocket.SendByte(  ch  ); //    .

		return;
	}

	if( uBlock + uByteCount/512 > uDSK_Blocks )
	{//     .   .
		uByteCount = (uDSK_Blocks - uBlock)*512;
	
		sprintf(str, ">  %u  ", uByteCount );
		Log(str);
	}
	
	byte DataBuf[1024*64];
	
	int nRes = ReadDSK( uUnit, uBlock, uByteCount, (word*)DataBuf );

	if( !nRes )
	{// .
		Log( LNG("-- ERROR\n") );

		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .

		ch = 'R';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //   - .

		ch = 'E';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //  -  .
		
		ch = ChSum;
		ByteOutputSocket.SendByte(  ch  ); //    .

		ch = ChSum >> 8;
		ByteOutputSocket.SendByte(  ch  ); //    .

		return;
	}
	//  .

	ByteOutputSocket.SendByte( 0376 ); //  .
	
	int nSize = uByteCount + 2;
	
	ch = nSize;
	ByteOutputSocket.SendByte( ch ); //    .

	ch = nSize>>8;
	ByteOutputSocket.SendByte( ch ); //    .
	
	ch = 'R';
	ChSum += ch;
	ByteOutputSocket.SendByte( ch ); //   - .

	ch = 'D';
	ChSum += ch;
	ByteOutputSocket.SendByte( ch ); //  -   .
	
	for( int i = 0 ; i < uByteCount ; i++ )
	{
		ch = DataBuf[i];
		ChSum += ch;
		ByteOutputSocket.SendByte( ch );
	}
	
	ch = ChSum;
	ByteOutputSocket.SendByte( ch ); //    .

	ch = ChSum >> 8;
	ByteOutputSocket.SendByte( ch ); //    .
	
	Log("\n");
}


void HX_tool::Cmd_SIZE( byte ch )
{
	sPacketBuf += ch;

	//  "".   -  .
	if( !sCmd_SIZE_Phase.size() )
	{
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{//   .    .
			uUnit = ch;
			sCmd_SIZE_Phase = "U";
			return;
		}

		//  .
		sCmd_SIZE_Phase.clear();
		sPhase = "X";
		return;
	}
	
	if( "U" == sCmd_SIZE_Phase )
	{//  "".   -    .
		uCheckSumm = ch;
		
		sCmd_SIZE_Phase = "Us";
		return;
	}

	if( "Us" == sCmd_SIZE_Phase )
	{//  "".   -    .
		uCheckSumm |= word(ch)<<8;

		sCmd_SIZE_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			word ChSum = 0;
			byte ch;

			dword uDSK_Blocks = DSK_Rec[uUnit].uDSK_Blocks;

			char str[512];
			sprintf(str, LNG("HX: SIZE :  Unit: %u  |  Blocks:%6u\n"), uUnit, uDSK_Blocks );
			Log(str);

			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  6   ); //  .
			
			ch = 'R';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //   - .

			ch = 's';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //  -    .
			
			ch = uDSK_Blocks;
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); // 1-  .

			ch = uDSK_Blocks >> 8;
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); // 2-  .

			ch = uDSK_Blocks >> 16;
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); // 3-  .

			ch = uDSK_Blocks >> 24;
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); // 4-  .

			ch = ChSum;
			ByteOutputSocket.SendByte(  ch  ); //    .

			ch = ChSum >> 8;
			ByteOutputSocket.SendByte(  ch  ); //    .
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}

		return;
	}

	sCmd_SIZE_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}


void HX_tool::Cmd_WRITE_RAW( byte ch )
{
	sPacketBuf += ch;

	int  nWrite_Res = 0;
	byte DataBuf[1024*64];

	if( !sCmd_WRITE_RAW_Phase.size() )
	{//   -  .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uUnit = ch;
		sCmd_WRITE_RAW_Phase = "U";
		return;
	}
	
	if( "U" == sCmd_WRITE_RAW_Phase )
	{//   - 1-   .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock = ch;
		
		sCmd_WRITE_RAW_Phase = "UB";
		return;
	}
	
	if( "UB" == sCmd_WRITE_RAW_Phase )
	{//   - 2-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= word(ch)<<8;
		
		sCmd_WRITE_RAW_Phase = "UBB";
		return;
	}
	
	if( "UBB" == sCmd_WRITE_RAW_Phase )
	{//   - 3-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= dword(ch)<<16;
		
		sCmd_WRITE_RAW_Phase = "UBBB";
		return;
	}
	
	if( "UBBB" == sCmd_WRITE_RAW_Phase )
	{//   - 4-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= dword(ch)<<24;
		
		sCmd_WRITE_RAW_Phase = "UBBBB";
		return;
	}
	
	if( "UBBBB" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uByteCount = ch;
		
		sCmd_WRITE_RAW_Phase = "UBBBBW";
		return;
	}
	
	if( "UBBBBW" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uByteCount |= word(ch)<<8;
		uByteCnt = uByteCount;
		
		if( uByteCount ) 
		{
			sCmd_WRITE_RAW_Phase = "UBBBBWW";
			memset( DataBuf, 0, uByteCount );
		}
		else
		{
			sCmd_WRITE_RAW_Phase = "UBBBBWWD";
			nWrite_Res = 1;
		}

		char str[512];
		sprintf(str, LNG("HX: WRITE:  Unit: %u  |  Block:%7u  |  ByteCount: %5u  "), uUnit, uBlock, uByteCount );
		Log(str);
		
		return;
	}

	if( "UBBBBWW" == sCmd_WRITE_RAW_Phase )
	{//   -   .
		uCheckedSumm += ch;
		
		DataBuf[ uByteCount - uByteCnt ] = ch;

		if( !(--uByteCnt) )
		{//      .
			sCmd_WRITE_RAW_Phase = "UBBBBWWD";

			if( (--uPacketSize) ) 
			{ //  .
				sCmd_WRITE_RAW_Phase.clear();
				sPhase = "X"; 
			}
			return;
		}
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
		}
		return;
	}

	if( "UBBBBWWD" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckSumm = ch;

		sCmd_WRITE_RAW_Phase = "UBBBBWWDs";
		return;
	}

	if( "UBBBBWWDs" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckSumm |= word(ch)<<8;

		sCmd_WRITE_RAW_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();
		
		if( uCheckSumm == uCheckedSumm )
		{//     .


			dword uDSK_Blocks = DSK_Rec[uUnit].uDSK_Blocks;

			if( uBlock >= uDSK_Blocks )
			{//     .   EOF.
				Log( LNG("-- EOF\n") );
				nWrite_Res = -1;
			}
			else
			if( uByteCount )
			{
				if( uBlock + uByteCount/512 > uDSK_Blocks )
				{//     .          EOF.
					uByteCount = (uDSK_Blocks - uBlock)*512;
					nWrite_Res = -1;
					
					char str[128];
					sprintf(str, ">  %u  ", uByteCount );
					Log(str);
				}
	
				int nRes = WriteDSK( uUnit, uBlock, uByteCount, (word*)DataBuf );
				if( nRes > 0 )
				{//  
					nWrite_Res = 1;
					Log("\n");
				}
				else
				{
					Log( LNG("-- ERROR\n") );
				}
			}
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
			return;
		}
		
		//   .
		
		word ChSum = 0;
		byte chr;
		
		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .
		
		chr = 'R';
		ChSum += chr;
		ByteOutputSocket.SendByte(  chr  ); //   - .

		if( nWrite_Res > 0 ) { chr = 'Y'; }  //   .
		else
		if( nWrite_Res < 0 ) { chr = 'F'; }  //  .
		else                 { chr = 'E'; }  //    .
		
		ChSum += chr;
		ByteOutputSocket.SendByte(  chr  ); //  - 'Y'  'E'.
		
		chr = ChSum;
		ByteOutputSocket.SendByte(  chr  ); //    .
		
		chr = ChSum >> 8;
		ByteOutputSocket.SendByte(  chr  ); //    .

		return;
	}

	sCmd_WRITE_RAW_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}


void HX_tool::Cmd_READ_PACKED_STREAM( byte ch )
{
	sPacketBuf += ch;

	if( !sCmd_READ_PACKED_STREAM_Phase.size() )
	{//  "  ".   -  .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uUnit = ch;
		sCmd_READ_PACKED_STREAM_Phase = "U";
		return;
	}
	
	if( "U" == sCmd_READ_PACKED_STREAM_Phase )
	{//   - 1-   .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock = ch;
		
		sCmd_READ_PACKED_STREAM_Phase = "UB";
		return;
	}
	
	if( "UB" == sCmd_READ_PACKED_STREAM_Phase )
	{//   - 2-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= word(ch)<<8;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBB";
		return;
	}
	
	if( "UBB" == sCmd_READ_PACKED_STREAM_Phase )
	{//   - 3-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= dword(ch)<<16;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBBB";
		return;
	}
	
	if( "UBBB" == sCmd_READ_PACKED_STREAM_Phase )
	{//   - 4-   .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= dword(ch)<<24;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBBBB";
		return;
	}
	
	if( "UBBBB" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uByteCount = ch;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBBBBW";
		return;
	}
	
	if( "UBBBBW" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckedSumm += ch;

		uByteCount |= word(ch)<<8;

		if( !(--uPacketSize) ) 
		{//   .    .

			sCmd_READ_PACKED_STREAM_Phase = "UBBBBWW"; 
			return; 
		}

		//  .
		sCmd_READ_PACKED_STREAM_Phase.clear();
		sPhase = "X";
		return;
	}

	if( "UBBBBWW" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckSumm = ch;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBBBBWWs";
		return;
	}

	if( "UBBBBWWs" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckSumm |= word(ch)<<8;

		sCmd_READ_PACKED_STREAM_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();		
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			Cmd_READ_PACKED_STREAM_Execute();  //       .
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}

		return;
	}

	sCmd_READ_PACKED_STREAM_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}

void HX_tool::Cmd_READ_PACKED_STREAM_Execute()
{
	char str[512];
	sprintf(str, LNG("HX: read :  Unit: %u  |  Block:%7u  |  ByteCount: %5u  "), uUnit, uBlock, uByteCount );
	Log(str);

	word ChSum = 0;
	byte ch;
	
	dword uDSK_Blocks = DSK_Rec[uUnit].uDSK_Blocks;

	if( uBlock >= uDSK_Blocks )
	{//     .   EOF.
		Log( LNG("-- EOF\n") );

		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .

		ch = 'R';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //   - .

		ch = 'F';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //  -  .
		
		ch = ChSum;
		ByteOutputSocket.SendByte(  ch  ); //    .

		ch = ChSum >> 8;
		ByteOutputSocket.SendByte(  ch  ); //    .

		return;
	}

	if( uBlock + uByteCount/512 > uDSK_Blocks )
	{//     .   .
		uByteCount = (uDSK_Blocks - uBlock)*512;
	
		sprintf(str, ">  %u  ", uByteCount );
		Log(str);
	}

	byte DataBuf[1024*64];
	memset( DataBuf, 0, uByteCount );
	
	int nRes = ReadDSK( uUnit, uBlock, uByteCount, (word*)DataBuf );

	if( !nRes )
	{// .
		Log( LNG("-- ERROR\n") );

		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .

		ch = 'R';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //   - .

		ch = 'E';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //  -  .
		
		ch = ChSum;
		ByteOutputSocket.SendByte(  ch  ); //    .

		ch = ChSum >> 8;
		ByteOutputSocket.SendByte(  ch  ); //    .

		return;
	}
	//  .

	ByteOutputSocket.SendByte( 0374 ); //  .
	
	int nHeaderBytesSent = 0;
	int nDataBytesSent   = 0;
	int nBytesSaved      = 0;
	
	int nBytesInBuf  = uByteCount;
	int nBytesToCopy = 0;
	int nCopyOffset  = 0;
	for( int nOffset = 0 ; nOffset < nBytesInBuf ; )
	{
		byte chr = DataBuf[ nOffset ];

		int nRept = 1;
		while( chr == DataBuf[ nOffset+nRept ] && nRept <= 255 && nOffset+nRept < nBytesInBuf )
		{
			nRept++;
		}

		if( nRept >= 6 )
		{
			if( nBytesToCopy )
			{
				if( nBytesToCopy == 1 )
				{
					ch = 01;		         // ByteCount == 1
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nHeaderBytesSent++;
					
					ch = 01;                 // ReptCount == 1
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nHeaderBytesSent++;

					ch = DataBuf[ nCopyOffset++ ];
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nDataBytesSent++;

					nBytesToCopy = 0;
				}
				else
				{
					ch = nBytesToCopy;		 // ByteCount == nBytesToCopy
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nHeaderBytesSent++;

					while( nBytesToCopy-- )
					{
						ch = DataBuf[ nCopyOffset++ ];
						ChSum += ch;
						ByteOutputSocket.SendByte( ch );
						nDataBytesSent++;
					}

					nBytesToCopy = 0;
				}
			}
		
			ch = 01;		// ByteCount == 1
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			ch = nRept;   // ReptCount == nRept
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			ch = chr;		// Byte == chr	
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nDataBytesSent++;
			
			nBytesSaved += nRept-1;
			
			nOffset     += nRept;
			nCopyOffset += nRept;
			continue;
		}

		//  -    .
		nBytesToCopy++;
		nOffset++;

		if( nBytesToCopy < 255 ) { continue; }

		//  -   255 .

		ch = 255;		    // ByteCount == 255
		ChSum += ch;
		ByteOutputSocket.SendByte( ch );
		nHeaderBytesSent++;
		
		for( int i = 0 ; i < 255 ; i++ )
		{
			ch = DataBuf[ nCopyOffset++ ];
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nDataBytesSent++;
		}
		
		nBytesToCopy = 0;
	}	

	if( nBytesToCopy )
	{
		if( nBytesToCopy == 1 )
		{
			ch = 01;		         // ByteCount == 1
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;
			
			ch = 01;                 // ReptCount == 1
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			ch = DataBuf[ nCopyOffset++ ];
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nDataBytesSent++;

			nBytesToCopy = 0;
		}
		else
		{
			ch = nBytesToCopy;		 // ByteCount == nBytesToCopy
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			while( nBytesToCopy-- )
			{
				ch = DataBuf[ nCopyOffset++ ];
				ChSum += ch;
				ByteOutputSocket.SendByte( ch );
				nDataBytesSent++;
			}

			nBytesToCopy = 0;
		}
	}

	ch = 00;						 //  .
	ChSum += ch;
	ByteOutputSocket.SendByte( ch );
	nHeaderBytesSent++;
	
	//*/
	
	ch = ChSum;
	ByteOutputSocket.SendByte( ch ); //    .
	
	ch = ChSum >> 8;
	ByteOutputSocket.SendByte( ch ); //    .

	if( uByteCount != nDataBytesSent + nBytesSaved )
	{
		sprintf(str, LNG("\nRAW Bytes: %5u  |  Header Bytes: %5u  |  Total Sent: %5u  |  To Restore: %5u\n"), 
	                 uByteCount, nHeaderBytesSent, nHeaderBytesSent + nDataBytesSent, nDataBytesSent + nBytesSaved );
	}
	else
	{
		sprintf(str, LNG("|  Bytes Saved: %5i\n"), nBytesSaved - nHeaderBytesSent + 4 );
	}
	Log(str);
}
